/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.TimeoutException;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.MultiFailOnItemTimeout;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;

public class MultiOnItemTimeout<T> {
    private final Multi<T> failure;
    private final Duration timeout;
    private final ScheduledExecutorService executor;

    public MultiOnItemTimeout(Multi<T> upstream, Duration timeout, ScheduledExecutorService executor) {
        this.failure = ParameterValidation.nonNull(upstream, "upstream");
        this.timeout = ParameterValidation.validate(timeout, "timeout");
        this.executor = executor;
    }

    public MultiOnItemTimeout<T> on(ScheduledExecutorService executor) {
        return new MultiOnItemTimeout<T>(this.failure, this.timeout, ParameterValidation.nonNull(executor, "executor"));
    }

    @CheckReturnValue
    public Multi<T> fail() {
        return Infrastructure.onMultiCreation(this.failWith(TimeoutException::new));
    }

    @CheckReturnValue
    public Multi<T> failWith(Throwable failure) {
        return this.failWith(() -> failure);
    }

    @CheckReturnValue
    public Multi<T> failWith(Supplier<? extends Throwable> supplier) {
        Supplier<? extends Throwable> actual = Infrastructure.decorate(ParameterValidation.nonNull(supplier, "supplier"));
        return Infrastructure.onMultiCreation(new MultiFailOnItemTimeout<T>(this.failure, this.timeout, actual, this.executor));
    }

    @CheckReturnValue
    public Multi<T> recoverWithCompletion() {
        return this.fail().onFailure(TimeoutException.class).recoverWithCompletion();
    }

    @CheckReturnValue
    public Multi<T> recoverWithMulti(Supplier<Multi<? extends T>> supplier) {
        return this.fail().onFailure(TimeoutException.class).recoverWithMulti(supplier);
    }

    @CheckReturnValue
    public Multi<T> recoverWithMulti(Multi<? extends T> fallback) {
        return this.fail().onFailure(TimeoutException.class).recoverWithMulti(fallback);
    }
}

