/*
 * This declarations of the PIC16LF1703 MCU.
 *
 * This file is part of the GNU PIC library for SDCC, originally
 * created by Molnar Karoly <molnarkaroly@users.sf.net> 2016.
 *
 * This file is generated automatically by the cinc2h.pl, 2016-04-13 17:23:11 UTC.
 *
 * SDCC is licensed under the GNU Public license (GPL) v2. Note that
 * this license covers the code to the compiler and other executables,
 * but explicitly does not cover any code or objects generated by sdcc.
 *
 * For pic device libraries and header files which are derived from
 * Microchip header (.inc) and linker script (.lkr) files Microchip
 * requires that "The header files should state that they are only to be
 * used with authentic Microchip devices" which makes them incompatible
 * with the GPL. Pic device libraries and header files are located at
 * non-free/lib and non-free/include directories respectively.
 * Sdcc should be run with the --use-non-free command line option in
 * order to include non-free header files and libraries.
 *
 * See http://sdcc.sourceforge.net/ for the latest information on sdcc.
 */

#ifndef __PIC16LF1703_H__
#define __PIC16LF1703_H__

//==============================================================================
//
//	Register Addresses
//
//==============================================================================

#ifndef NO_ADDR_DEFINES

#define INDF0_ADDR              0x0000
#define INDF1_ADDR              0x0001
#define PCL_ADDR                0x0002
#define STATUS_ADDR             0x0003
#define FSR0_ADDR               0x0004
#define FSR0L_ADDR              0x0004
#define FSR0H_ADDR              0x0005
#define FSR1_ADDR               0x0006
#define FSR1L_ADDR              0x0006
#define FSR1H_ADDR              0x0007
#define BSR_ADDR                0x0008
#define WREG_ADDR               0x0009
#define PCLATH_ADDR             0x000A
#define INTCON_ADDR             0x000B
#define PORTA_ADDR              0x000C
#define PORTC_ADDR              0x000E
#define PIR1_ADDR               0x0011
#define PIR2_ADDR               0x0012
#define PIR3_ADDR               0x0013
#define TMR0_ADDR               0x0015
#define TMR1_ADDR               0x0016
#define TMR1L_ADDR              0x0016
#define TMR1H_ADDR              0x0017
#define T1CON_ADDR              0x0018
#define T1GCON_ADDR             0x0019
#define TMR2_ADDR               0x001A
#define PR2_ADDR                0x001B
#define T2CON_ADDR              0x001C
#define TRISA_ADDR              0x008C
#define TRISC_ADDR              0x008E
#define PIE1_ADDR               0x0091
#define PIE2_ADDR               0x0092
#define PIE3_ADDR               0x0093
#define OPTION_REG_ADDR         0x0095
#define PCON_ADDR               0x0096
#define WDTCON_ADDR             0x0097
#define OSCTUNE_ADDR            0x0098
#define OSCCON_ADDR             0x0099
#define OSCSTAT_ADDR            0x009A
#define ADRES_ADDR              0x009B
#define ADRESL_ADDR             0x009B
#define ADRESH_ADDR             0x009C
#define ADCON0_ADDR             0x009D
#define ADCON1_ADDR             0x009E
#define ADCON2_ADDR             0x009F
#define LATA_ADDR               0x010C
#define LATC_ADDR               0x010E
#define BORCON_ADDR             0x0116
#define FVRCON_ADDR             0x0117
#define ZCD1CON_ADDR            0x011C
#define ANSELA_ADDR             0x018C
#define ANSELC_ADDR             0x018E
#define PMADR_ADDR              0x0191
#define PMADRL_ADDR             0x0191
#define PMADRH_ADDR             0x0192
#define PMDAT_ADDR              0x0193
#define PMDATL_ADDR             0x0193
#define PMDATH_ADDR             0x0194
#define PMCON1_ADDR             0x0195
#define PMCON2_ADDR             0x0196
#define WPUA_ADDR               0x020C
#define WPUC_ADDR               0x020E
#define SSP1BUF_ADDR            0x0211
#define SSPBUF_ADDR             0x0211
#define SSP1ADD_ADDR            0x0212
#define SSPADD_ADDR             0x0212
#define SSP1MSK_ADDR            0x0213
#define SSPMSK_ADDR             0x0213
#define SSP1STAT_ADDR           0x0214
#define SSPSTAT_ADDR            0x0214
#define SSP1CON_ADDR            0x0215
#define SSP1CON1_ADDR           0x0215
#define SSPCON_ADDR             0x0215
#define SSPCON1_ADDR            0x0215
#define SSP1CON2_ADDR           0x0216
#define SSPCON2_ADDR            0x0216
#define SSP1CON3_ADDR           0x0217
#define SSPCON3_ADDR            0x0217
#define ODCONA_ADDR             0x028C
#define ODCONC_ADDR             0x028E
#define CCPR1_ADDR              0x0291
#define CCPR1L_ADDR             0x0291
#define CCPR1H_ADDR             0x0292
#define CCP1CON_ADDR            0x0293
#define ECCP1CON_ADDR           0x0293
#define CCPR2_ADDR              0x0298
#define CCPR2L_ADDR             0x0298
#define CCPR2H_ADDR             0x0299
#define CCP2CON_ADDR            0x029A
#define ECCP2CON_ADDR           0x029A
#define SLRCONA_ADDR            0x030C
#define SLRCONC_ADDR            0x030E
#define INLVLA_ADDR             0x038C
#define INLVLC_ADDR             0x038E
#define IOCAP_ADDR              0x0391
#define IOCAN_ADDR              0x0392
#define IOCAF_ADDR              0x0393
#define IOCCP_ADDR              0x0397
#define IOCCN_ADDR              0x0398
#define IOCCF_ADDR              0x0399
#define OPA1CON_ADDR            0x0511
#define OPA2CON_ADDR            0x0515
#define PPSLOCK_ADDR            0x0E0F
#define INTPPS_ADDR             0x0E10
#define T0CKIPPS_ADDR           0x0E11
#define T1CKIPPS_ADDR           0x0E12
#define T1GPPS_ADDR             0x0E13
#define CCP1PPS_ADDR            0x0E14
#define CCP2PPS_ADDR            0x0E15
#define SSPCLKPPS_ADDR          0x0E20
#define SSPDATPPS_ADDR          0x0E21
#define SSPSSPPS_ADDR           0x0E22
#define RA0PPS_ADDR             0x0E90
#define RA1PPS_ADDR             0x0E91
#define RA2PPS_ADDR             0x0E92
#define RA4PPS_ADDR             0x0E94
#define RA5PPS_ADDR             0x0E95
#define RC0PPS_ADDR             0x0EA0
#define RC1PPS_ADDR             0x0EA1
#define RC2PPS_ADDR             0x0EA2
#define RC3PPS_ADDR             0x0EA3
#define RC4PPS_ADDR             0x0EA4
#define RC5PPS_ADDR             0x0EA5
#define ICDBK0H_ADDR            0x0F9E
#define STATUS_SHAD_ADDR        0x0FE4
#define WREG_SHAD_ADDR          0x0FE5
#define BSR_SHAD_ADDR           0x0FE6
#define PCLATH_SHAD_ADDR        0x0FE7
#define FSR0L_SHAD_ADDR         0x0FE8
#define FSR0H_SHAD_ADDR         0x0FE9
#define FSR1L_SHAD_ADDR         0x0FEA
#define FSR1H_SHAD_ADDR         0x0FEB
#define STKPTR_ADDR             0x0FED
#define TOSL_ADDR               0x0FEE
#define TOSH_ADDR               0x0FEF

#endif // #ifndef NO_ADDR_DEFINES

//==============================================================================
//
//	Register Definitions
//
//==============================================================================

extern __at(0x0000) __sfr INDF0;
extern __at(0x0001) __sfr INDF1;
extern __at(0x0002) __sfr PCL;

//==============================================================================
//        STATUS Bits

extern __at(0x0003) __sfr STATUS;

typedef struct
  {
  unsigned C                    : 1;
  unsigned DC                   : 1;
  unsigned Z                    : 1;
  unsigned NOT_PD               : 1;
  unsigned NOT_TO               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __STATUSbits_t;

extern __at(0x0003) volatile __STATUSbits_t STATUSbits;

#define _C                      0x01
#define _DC                     0x02
#define _Z                      0x04
#define _NOT_PD                 0x08
#define _NOT_TO                 0x10

//==============================================================================

extern __at(0x0004) __sfr FSR0;
extern __at(0x0004) __sfr FSR0L;
extern __at(0x0005) __sfr FSR0H;
extern __at(0x0006) __sfr FSR1;
extern __at(0x0006) __sfr FSR1L;
extern __at(0x0007) __sfr FSR1H;

//==============================================================================
//        BSR Bits

extern __at(0x0008) __sfr BSR;

typedef union
  {
  struct
    {
    unsigned BSR0               : 1;
    unsigned BSR1               : 1;
    unsigned BSR2               : 1;
    unsigned BSR3               : 1;
    unsigned BSR4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned BSR                : 5;
    unsigned                    : 3;
    };
  } __BSRbits_t;

extern __at(0x0008) volatile __BSRbits_t BSRbits;

#define _BSR0                   0x01
#define _BSR1                   0x02
#define _BSR2                   0x04
#define _BSR3                   0x08
#define _BSR4                   0x10

//==============================================================================

extern __at(0x0009) __sfr WREG;
extern __at(0x000A) __sfr PCLATH;

//==============================================================================
//        INTCON Bits

extern __at(0x000B) __sfr INTCON;

typedef union
  {
  struct
    {
    unsigned IOCIF              : 1;
    unsigned INTF               : 1;
    unsigned TMR0IF             : 1;
    unsigned IOCIE              : 1;
    unsigned INTE               : 1;
    unsigned TMR0IE             : 1;
    unsigned PEIE               : 1;
    unsigned GIE                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0IF               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0IE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __INTCONbits_t;

extern __at(0x000B) volatile __INTCONbits_t INTCONbits;

#define _IOCIF                  0x01
#define _INTF                   0x02
#define _TMR0IF                 0x04
#define _T0IF                   0x04
#define _IOCIE                  0x08
#define _INTE                   0x10
#define _TMR0IE                 0x20
#define _T0IE                   0x20
#define _PEIE                   0x40
#define _GIE                    0x80

//==============================================================================


//==============================================================================
//        PORTA Bits

extern __at(0x000C) __sfr PORTA;

typedef union
  {
  struct
    {
    unsigned RA0                : 1;
    unsigned RA1                : 1;
    unsigned RA2                : 1;
    unsigned RA3                : 1;
    unsigned RA4                : 1;
    unsigned RA5                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RA                 : 6;
    unsigned                    : 2;
    };
  } __PORTAbits_t;

extern __at(0x000C) volatile __PORTAbits_t PORTAbits;

#define _RA0                    0x01
#define _RA1                    0x02
#define _RA2                    0x04
#define _RA3                    0x08
#define _RA4                    0x10
#define _RA5                    0x20

//==============================================================================


//==============================================================================
//        PORTC Bits

extern __at(0x000E) __sfr PORTC;

typedef union
  {
  struct
    {
    unsigned RC0                : 1;
    unsigned RC1                : 1;
    unsigned RC2                : 1;
    unsigned RC3                : 1;
    unsigned RC4                : 1;
    unsigned RC5                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RC                 : 6;
    unsigned                    : 2;
    };
  } __PORTCbits_t;

extern __at(0x000E) volatile __PORTCbits_t PORTCbits;

#define _RC0                    0x01
#define _RC1                    0x02
#define _RC2                    0x04
#define _RC3                    0x08
#define _RC4                    0x10
#define _RC5                    0x20

//==============================================================================


//==============================================================================
//        PIR1 Bits

extern __at(0x0011) __sfr PIR1;

typedef union
  {
  struct
    {
    unsigned TMR1IF             : 1;
    unsigned TMR2IF             : 1;
    unsigned CCP1IF             : 1;
    unsigned SSP1IF             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADIF               : 1;
    unsigned TMR1GIF            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCPIF              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PIR1bits_t;

extern __at(0x0011) volatile __PIR1bits_t PIR1bits;

#define _TMR1IF                 0x01
#define _TMR2IF                 0x02
#define _CCP1IF                 0x04
#define _CCPIF                  0x04
#define _SSP1IF                 0x08
#define _ADIF                   0x40
#define _TMR1GIF                0x80

//==============================================================================


//==============================================================================
//        PIR2 Bits

extern __at(0x0012) __sfr PIR2;

typedef struct
  {
  unsigned CCP2IF               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned BCL1IF               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIR2bits_t;

extern __at(0x0012) volatile __PIR2bits_t PIR2bits;

#define _CCP2IF                 0x01
#define _BCL1IF                 0x08

//==============================================================================


//==============================================================================
//        PIR3 Bits

extern __at(0x0013) __sfr PIR3;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned ZCDIF                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIR3bits_t;

extern __at(0x0013) volatile __PIR3bits_t PIR3bits;

#define _ZCDIF                  0x10

//==============================================================================

extern __at(0x0015) __sfr TMR0;
extern __at(0x0016) __sfr TMR1;
extern __at(0x0016) __sfr TMR1L;
extern __at(0x0017) __sfr TMR1H;

//==============================================================================
//        T1CON Bits

extern __at(0x0018) __sfr T1CON;

typedef union
  {
  struct
    {
    unsigned TMR1ON             : 1;
    unsigned                    : 1;
    unsigned NOT_T1SYNC         : 1;
    unsigned T1OSCEN            : 1;
    unsigned T1CKPS0            : 1;
    unsigned T1CKPS1            : 1;
    unsigned TMR1CS0            : 1;
    unsigned TMR1CS1            : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T1CKPS             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned TMR1CS             : 2;
    };
  } __T1CONbits_t;

extern __at(0x0018) volatile __T1CONbits_t T1CONbits;

#define _TMR1ON                 0x01
#define _NOT_T1SYNC             0x04
#define _T1OSCEN                0x08
#define _T1CKPS0                0x10
#define _T1CKPS1                0x20
#define _TMR1CS0                0x40
#define _TMR1CS1                0x80

//==============================================================================


//==============================================================================
//        T1GCON Bits

extern __at(0x0019) __sfr T1GCON;

typedef union
  {
  struct
    {
    unsigned T1GSS0             : 1;
    unsigned T1GSS1             : 1;
    unsigned T1GVAL             : 1;
    unsigned T1GGO_NOT_DONE     : 1;
    unsigned T1GSPM             : 1;
    unsigned T1GTM              : 1;
    unsigned T1GPOL             : 1;
    unsigned TMR1GE             : 1;
    };

  struct
    {
    unsigned T1GSS              : 2;
    unsigned                    : 6;
    };
  } __T1GCONbits_t;

extern __at(0x0019) volatile __T1GCONbits_t T1GCONbits;

#define _T1GSS0                 0x01
#define _T1GSS1                 0x02
#define _T1GVAL                 0x04
#define _T1GGO_NOT_DONE         0x08
#define _T1GSPM                 0x10
#define _T1GTM                  0x20
#define _T1GPOL                 0x40
#define _TMR1GE                 0x80

//==============================================================================

extern __at(0x001A) __sfr TMR2;
extern __at(0x001B) __sfr PR2;

//==============================================================================
//        T2CON Bits

extern __at(0x001C) __sfr T2CON;

typedef union
  {
  struct
    {
    unsigned T2CKPS0            : 1;
    unsigned T2CKPS1            : 1;
    unsigned TMR2ON             : 1;
    unsigned T2OUTPS0           : 1;
    unsigned T2OUTPS1           : 1;
    unsigned T2OUTPS2           : 1;
    unsigned T2OUTPS3           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T2CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned T2OUTPS            : 4;
    unsigned                    : 1;
    };
  } __T2CONbits_t;

extern __at(0x001C) volatile __T2CONbits_t T2CONbits;

#define _T2CKPS0                0x01
#define _T2CKPS1                0x02
#define _TMR2ON                 0x04
#define _T2OUTPS0               0x08
#define _T2OUTPS1               0x10
#define _T2OUTPS2               0x20
#define _T2OUTPS3               0x40

//==============================================================================


//==============================================================================
//        TRISA Bits

extern __at(0x008C) __sfr TRISA;

typedef struct
  {
  unsigned TRISA0               : 1;
  unsigned TRISA1               : 1;
  unsigned TRISA2               : 1;
  unsigned                      : 1;
  unsigned TRISA4               : 1;
  unsigned TRISA5               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __TRISAbits_t;

extern __at(0x008C) volatile __TRISAbits_t TRISAbits;

#define _TRISA0                 0x01
#define _TRISA1                 0x02
#define _TRISA2                 0x04
#define _TRISA4                 0x10
#define _TRISA5                 0x20

//==============================================================================


//==============================================================================
//        TRISC Bits

extern __at(0x008E) __sfr TRISC;

typedef union
  {
  struct
    {
    unsigned TRISC0             : 1;
    unsigned TRISC1             : 1;
    unsigned TRISC2             : 1;
    unsigned TRISC3             : 1;
    unsigned TRISC4             : 1;
    unsigned TRISC5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TRISC              : 6;
    unsigned                    : 2;
    };
  } __TRISCbits_t;

extern __at(0x008E) volatile __TRISCbits_t TRISCbits;

#define _TRISC0                 0x01
#define _TRISC1                 0x02
#define _TRISC2                 0x04
#define _TRISC3                 0x08
#define _TRISC4                 0x10
#define _TRISC5                 0x20

//==============================================================================


//==============================================================================
//        PIE1 Bits

extern __at(0x0091) __sfr PIE1;

typedef union
  {
  struct
    {
    unsigned TMR1IE             : 1;
    unsigned TMR2IE             : 1;
    unsigned CCP1IE             : 1;
    unsigned SSP1IE             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADIE               : 1;
    unsigned TMR1GIE            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCPIE              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PIE1bits_t;

extern __at(0x0091) volatile __PIE1bits_t PIE1bits;

#define _TMR1IE                 0x01
#define _TMR2IE                 0x02
#define _CCP1IE                 0x04
#define _CCPIE                  0x04
#define _SSP1IE                 0x08
#define _ADIE                   0x40
#define _TMR1GIE                0x80

//==============================================================================


//==============================================================================
//        PIE2 Bits

extern __at(0x0092) __sfr PIE2;

typedef struct
  {
  unsigned CCP2IE               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned BCL1IE               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIE2bits_t;

extern __at(0x0092) volatile __PIE2bits_t PIE2bits;

#define _CCP2IE                 0x01
#define _BCL1IE                 0x08

//==============================================================================


//==============================================================================
//        PIE3 Bits

extern __at(0x0093) __sfr PIE3;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned ZCDIE                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIE3bits_t;

extern __at(0x0093) volatile __PIE3bits_t PIE3bits;

#define _ZCDIE                  0x10

//==============================================================================


//==============================================================================
//        OPTION_REG Bits

extern __at(0x0095) __sfr OPTION_REG;

typedef union
  {
  struct
    {
    unsigned PS0                : 1;
    unsigned PS1                : 1;
    unsigned PS2                : 1;
    unsigned PSA                : 1;
    unsigned TMR0SE             : 1;
    unsigned TMR0CS             : 1;
    unsigned INTEDG             : 1;
    unsigned NOT_WPUEN          : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0SE               : 1;
    unsigned T0CS               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PS                 : 3;
    unsigned                    : 5;
    };
  } __OPTION_REGbits_t;

extern __at(0x0095) volatile __OPTION_REGbits_t OPTION_REGbits;

#define _PS0                    0x01
#define _PS1                    0x02
#define _PS2                    0x04
#define _PSA                    0x08
#define _TMR0SE                 0x10
#define _T0SE                   0x10
#define _TMR0CS                 0x20
#define _T0CS                   0x20
#define _INTEDG                 0x40
#define _NOT_WPUEN              0x80

//==============================================================================


//==============================================================================
//        PCON Bits

extern __at(0x0096) __sfr PCON;

typedef struct
  {
  unsigned NOT_BOR              : 1;
  unsigned NOT_POR              : 1;
  unsigned NOT_RI               : 1;
  unsigned NOT_RMCLR            : 1;
  unsigned NOT_RWDT             : 1;
  unsigned                      : 1;
  unsigned STKUNF               : 1;
  unsigned STKOVF               : 1;
  } __PCONbits_t;

extern __at(0x0096) volatile __PCONbits_t PCONbits;

#define _NOT_BOR                0x01
#define _NOT_POR                0x02
#define _NOT_RI                 0x04
#define _NOT_RMCLR              0x08
#define _NOT_RWDT               0x10
#define _STKUNF                 0x40
#define _STKOVF                 0x80

//==============================================================================


//==============================================================================
//        WDTCON Bits

extern __at(0x0097) __sfr WDTCON;

typedef union
  {
  struct
    {
    unsigned SWDTEN             : 1;
    unsigned WDTPS0             : 1;
    unsigned WDTPS1             : 1;
    unsigned WDTPS2             : 1;
    unsigned WDTPS3             : 1;
    unsigned WDTPS4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned WDTPS              : 5;
    unsigned                    : 2;
    };
  } __WDTCONbits_t;

extern __at(0x0097) volatile __WDTCONbits_t WDTCONbits;

#define _SWDTEN                 0x01
#define _WDTPS0                 0x02
#define _WDTPS1                 0x04
#define _WDTPS2                 0x08
#define _WDTPS3                 0x10
#define _WDTPS4                 0x20

//==============================================================================


//==============================================================================
//        OSCTUNE Bits

extern __at(0x0098) __sfr OSCTUNE;

typedef union
  {
  struct
    {
    unsigned TUN0               : 1;
    unsigned TUN1               : 1;
    unsigned TUN2               : 1;
    unsigned TUN3               : 1;
    unsigned TUN4               : 1;
    unsigned TUN5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TUN                : 6;
    unsigned                    : 2;
    };
  } __OSCTUNEbits_t;

extern __at(0x0098) volatile __OSCTUNEbits_t OSCTUNEbits;

#define _TUN0                   0x01
#define _TUN1                   0x02
#define _TUN2                   0x04
#define _TUN3                   0x08
#define _TUN4                   0x10
#define _TUN5                   0x20

//==============================================================================


//==============================================================================
//        OSCCON Bits

extern __at(0x0099) __sfr OSCCON;

typedef union
  {
  struct
    {
    unsigned SCS0               : 1;
    unsigned SCS1               : 1;
    unsigned                    : 1;
    unsigned IRCF0              : 1;
    unsigned IRCF1              : 1;
    unsigned IRCF2              : 1;
    unsigned IRCF3              : 1;
    unsigned SPLLEN             : 1;
    };

  struct
    {
    unsigned SCS                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned IRCF               : 4;
    unsigned                    : 1;
    };
  } __OSCCONbits_t;

extern __at(0x0099) volatile __OSCCONbits_t OSCCONbits;

#define _SCS0                   0x01
#define _SCS1                   0x02
#define _IRCF0                  0x08
#define _IRCF1                  0x10
#define _IRCF2                  0x20
#define _IRCF3                  0x40
#define _SPLLEN                 0x80

//==============================================================================


//==============================================================================
//        OSCSTAT Bits

extern __at(0x009A) __sfr OSCSTAT;

typedef struct
  {
  unsigned HFIOFS               : 1;
  unsigned LFIOFR               : 1;
  unsigned MFIOFR               : 1;
  unsigned HFIOFL               : 1;
  unsigned HFIOFR               : 1;
  unsigned OSTS                 : 1;
  unsigned PLLR                 : 1;
  unsigned SOSCR                : 1;
  } __OSCSTATbits_t;

extern __at(0x009A) volatile __OSCSTATbits_t OSCSTATbits;

#define _HFIOFS                 0x01
#define _LFIOFR                 0x02
#define _MFIOFR                 0x04
#define _HFIOFL                 0x08
#define _HFIOFR                 0x10
#define _OSTS                   0x20
#define _PLLR                   0x40
#define _SOSCR                  0x80

//==============================================================================

extern __at(0x009B) __sfr ADRES;
extern __at(0x009B) __sfr ADRESL;
extern __at(0x009C) __sfr ADRESH;

//==============================================================================
//        ADCON0 Bits

extern __at(0x009D) __sfr ADCON0;

typedef union
  {
  struct
    {
    unsigned ADON               : 1;
    unsigned GO_NOT_DONE        : 1;
    unsigned CHS0               : 1;
    unsigned CHS1               : 1;
    unsigned CHS2               : 1;
    unsigned CHS3               : 1;
    unsigned CHS4               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned ADGO               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CHS                : 5;
    unsigned                    : 1;
    };
  } __ADCON0bits_t;

extern __at(0x009D) volatile __ADCON0bits_t ADCON0bits;

#define _ADON                   0x01
#define _GO_NOT_DONE            0x02
#define _ADGO                   0x02
#define _GO                     0x02
#define _CHS0                   0x04
#define _CHS1                   0x08
#define _CHS2                   0x10
#define _CHS3                   0x20
#define _CHS4                   0x40

//==============================================================================


//==============================================================================
//        ADCON1 Bits

extern __at(0x009E) __sfr ADCON1;

typedef union
  {
  struct
    {
    unsigned ADPREF0            : 1;
    unsigned ADPREF1            : 1;
    unsigned ADNREF             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADFM               : 1;
    };

  struct
    {
    unsigned ADPREF             : 2;
    unsigned                    : 6;
    };
  } __ADCON1bits_t;

extern __at(0x009E) volatile __ADCON1bits_t ADCON1bits;

#define _ADPREF0                0x01
#define _ADPREF1                0x02
#define _ADNREF                 0x04
#define _ADFM                   0x80

//==============================================================================


//==============================================================================
//        ADCON2 Bits

extern __at(0x009F) __sfr ADCON2;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TRIGSEL0           : 1;
    unsigned TRIGSEL1           : 1;
    unsigned TRIGSEL2           : 1;
    unsigned TRIGSEL3           : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned TRIGSEL            : 4;
    };
  } __ADCON2bits_t;

extern __at(0x009F) volatile __ADCON2bits_t ADCON2bits;

#define _TRIGSEL0               0x10
#define _TRIGSEL1               0x20
#define _TRIGSEL2               0x40
#define _TRIGSEL3               0x80

//==============================================================================


//==============================================================================
//        LATA Bits

extern __at(0x010C) __sfr LATA;

typedef struct
  {
  unsigned LATA0                : 1;
  unsigned LATA1                : 1;
  unsigned LATA2                : 1;
  unsigned                      : 1;
  unsigned LATA4                : 1;
  unsigned LATA5                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __LATAbits_t;

extern __at(0x010C) volatile __LATAbits_t LATAbits;

#define _LATA0                  0x01
#define _LATA1                  0x02
#define _LATA2                  0x04
#define _LATA4                  0x10
#define _LATA5                  0x20

//==============================================================================


//==============================================================================
//        LATC Bits

extern __at(0x010E) __sfr LATC;

typedef union
  {
  struct
    {
    unsigned LATC0              : 1;
    unsigned LATC1              : 1;
    unsigned LATC2              : 1;
    unsigned LATC3              : 1;
    unsigned LATC4              : 1;
    unsigned LATC5              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LATC               : 6;
    unsigned                    : 2;
    };
  } __LATCbits_t;

extern __at(0x010E) volatile __LATCbits_t LATCbits;

#define _LATC0                  0x01
#define _LATC1                  0x02
#define _LATC2                  0x04
#define _LATC3                  0x08
#define _LATC4                  0x10
#define _LATC5                  0x20

//==============================================================================


//==============================================================================
//        BORCON Bits

extern __at(0x0116) __sfr BORCON;

typedef struct
  {
  unsigned BORRDY               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned BORFS                : 1;
  unsigned SBOREN               : 1;
  } __BORCONbits_t;

extern __at(0x0116) volatile __BORCONbits_t BORCONbits;

#define _BORRDY                 0x01
#define _BORFS                  0x40
#define _SBOREN                 0x80

//==============================================================================


//==============================================================================
//        FVRCON Bits

extern __at(0x0117) __sfr FVRCON;

typedef union
  {
  struct
    {
    unsigned ADFVR0             : 1;
    unsigned ADFVR1             : 1;
    unsigned CDAFVR0            : 1;
    unsigned CDAFVR1            : 1;
    unsigned TSRNG              : 1;
    unsigned TSEN               : 1;
    unsigned FVRRDY             : 1;
    unsigned FVREN              : 1;
    };

  struct
    {
    unsigned ADFVR              : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CDAFVR             : 2;
    unsigned                    : 4;
    };
  } __FVRCONbits_t;

extern __at(0x0117) volatile __FVRCONbits_t FVRCONbits;

#define _ADFVR0                 0x01
#define _ADFVR1                 0x02
#define _CDAFVR0                0x04
#define _CDAFVR1                0x08
#define _TSRNG                  0x10
#define _TSEN                   0x20
#define _FVRRDY                 0x40
#define _FVREN                  0x80

//==============================================================================


//==============================================================================
//        ZCD1CON Bits

extern __at(0x011C) __sfr ZCD1CON;

typedef struct
  {
  unsigned ZCD1INTN             : 1;
  unsigned ZCD1INTP             : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned ZCD1POL              : 1;
  unsigned ZCD1OUT              : 1;
  unsigned                      : 1;
  unsigned ZCD1EN               : 1;
  } __ZCD1CONbits_t;

extern __at(0x011C) volatile __ZCD1CONbits_t ZCD1CONbits;

#define _ZCD1INTN               0x01
#define _ZCD1INTP               0x02
#define _ZCD1POL                0x10
#define _ZCD1OUT                0x20
#define _ZCD1EN                 0x80

//==============================================================================


//==============================================================================
//        ANSELA Bits

extern __at(0x018C) __sfr ANSELA;

typedef struct
  {
  unsigned ANSA0                : 1;
  unsigned ANSA1                : 1;
  unsigned ANSA2                : 1;
  unsigned                      : 1;
  unsigned ANSA4                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __ANSELAbits_t;

extern __at(0x018C) volatile __ANSELAbits_t ANSELAbits;

#define _ANSA0                  0x01
#define _ANSA1                  0x02
#define _ANSA2                  0x04
#define _ANSA4                  0x10

//==============================================================================


//==============================================================================
//        ANSELC Bits

extern __at(0x018E) __sfr ANSELC;

typedef union
  {
  struct
    {
    unsigned ANSC0              : 1;
    unsigned ANSC1              : 1;
    unsigned ANSC2              : 1;
    unsigned ANSC3              : 1;
    unsigned ANSC4              : 1;
    unsigned ANSC5              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ANSC               : 6;
    unsigned                    : 2;
    };
  } __ANSELCbits_t;

extern __at(0x018E) volatile __ANSELCbits_t ANSELCbits;

#define _ANSC0                  0x01
#define _ANSC1                  0x02
#define _ANSC2                  0x04
#define _ANSC3                  0x08
#define _ANSC4                  0x10
#define _ANSC5                  0x20

//==============================================================================

extern __at(0x0191) __sfr PMADR;
extern __at(0x0191) __sfr PMADRL;
extern __at(0x0192) __sfr PMADRH;
extern __at(0x0193) __sfr PMDAT;
extern __at(0x0193) __sfr PMDATL;
extern __at(0x0194) __sfr PMDATH;

//==============================================================================
//        PMCON1 Bits

extern __at(0x0195) __sfr PMCON1;

typedef struct
  {
  unsigned RD                   : 1;
  unsigned WR                   : 1;
  unsigned WREN                 : 1;
  unsigned WRERR                : 1;
  unsigned FREE                 : 1;
  unsigned LWLO                 : 1;
  unsigned CFGS                 : 1;
  unsigned                      : 1;
  } __PMCON1bits_t;

extern __at(0x0195) volatile __PMCON1bits_t PMCON1bits;

#define _RD                     0x01
#define _WR                     0x02
#define _WREN                   0x04
#define _WRERR                  0x08
#define _FREE                   0x10
#define _LWLO                   0x20
#define _CFGS                   0x40

//==============================================================================

extern __at(0x0196) __sfr PMCON2;

//==============================================================================
//        WPUA Bits

extern __at(0x020C) __sfr WPUA;

typedef union
  {
  struct
    {
    unsigned WPUA0              : 1;
    unsigned WPUA1              : 1;
    unsigned WPUA2              : 1;
    unsigned WPUA3              : 1;
    unsigned WPUA4              : 1;
    unsigned WPUA5              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned WPUA               : 6;
    unsigned                    : 2;
    };
  } __WPUAbits_t;

extern __at(0x020C) volatile __WPUAbits_t WPUAbits;

#define _WPUA0                  0x01
#define _WPUA1                  0x02
#define _WPUA2                  0x04
#define _WPUA3                  0x08
#define _WPUA4                  0x10
#define _WPUA5                  0x20

//==============================================================================


//==============================================================================
//        WPUC Bits

extern __at(0x020E) __sfr WPUC;

typedef union
  {
  struct
    {
    unsigned WPUC0              : 1;
    unsigned WPUC1              : 1;
    unsigned WPUC2              : 1;
    unsigned WPUC3              : 1;
    unsigned WPUC4              : 1;
    unsigned WPUC5              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned WPUC               : 6;
    unsigned                    : 2;
    };
  } __WPUCbits_t;

extern __at(0x020E) volatile __WPUCbits_t WPUCbits;

#define _WPUC0                  0x01
#define _WPUC1                  0x02
#define _WPUC2                  0x04
#define _WPUC3                  0x08
#define _WPUC4                  0x10
#define _WPUC5                  0x20

//==============================================================================


//==============================================================================
//        SSP1BUF Bits

extern __at(0x0211) __sfr SSP1BUF;

typedef union
  {
  struct
    {
    unsigned SSP1BUF0           : 1;
    unsigned SSP1BUF1           : 1;
    unsigned SSP1BUF2           : 1;
    unsigned SSP1BUF3           : 1;
    unsigned SSP1BUF4           : 1;
    unsigned SSP1BUF5           : 1;
    unsigned SSP1BUF6           : 1;
    unsigned SSP1BUF7           : 1;
    };

  struct
    {
    unsigned BUF0               : 1;
    unsigned BUF1               : 1;
    unsigned BUF2               : 1;
    unsigned BUF3               : 1;
    unsigned BUF4               : 1;
    unsigned BUF5               : 1;
    unsigned BUF6               : 1;
    unsigned BUF7               : 1;
    };
  } __SSP1BUFbits_t;

extern __at(0x0211) volatile __SSP1BUFbits_t SSP1BUFbits;

#define _SSP1BUF0               0x01
#define _BUF0                   0x01
#define _SSP1BUF1               0x02
#define _BUF1                   0x02
#define _SSP1BUF2               0x04
#define _BUF2                   0x04
#define _SSP1BUF3               0x08
#define _BUF3                   0x08
#define _SSP1BUF4               0x10
#define _BUF4                   0x10
#define _SSP1BUF5               0x20
#define _BUF5                   0x20
#define _SSP1BUF6               0x40
#define _BUF6                   0x40
#define _SSP1BUF7               0x80
#define _BUF7                   0x80

//==============================================================================


//==============================================================================
//        SSPBUF Bits

extern __at(0x0211) __sfr SSPBUF;

typedef union
  {
  struct
    {
    unsigned SSP1BUF0           : 1;
    unsigned SSP1BUF1           : 1;
    unsigned SSP1BUF2           : 1;
    unsigned SSP1BUF3           : 1;
    unsigned SSP1BUF4           : 1;
    unsigned SSP1BUF5           : 1;
    unsigned SSP1BUF6           : 1;
    unsigned SSP1BUF7           : 1;
    };

  struct
    {
    unsigned BUF0               : 1;
    unsigned BUF1               : 1;
    unsigned BUF2               : 1;
    unsigned BUF3               : 1;
    unsigned BUF4               : 1;
    unsigned BUF5               : 1;
    unsigned BUF6               : 1;
    unsigned BUF7               : 1;
    };
  } __SSPBUFbits_t;

extern __at(0x0211) volatile __SSPBUFbits_t SSPBUFbits;

#define _SSPBUF_SSP1BUF0        0x01
#define _SSPBUF_BUF0            0x01
#define _SSPBUF_SSP1BUF1        0x02
#define _SSPBUF_BUF1            0x02
#define _SSPBUF_SSP1BUF2        0x04
#define _SSPBUF_BUF2            0x04
#define _SSPBUF_SSP1BUF3        0x08
#define _SSPBUF_BUF3            0x08
#define _SSPBUF_SSP1BUF4        0x10
#define _SSPBUF_BUF4            0x10
#define _SSPBUF_SSP1BUF5        0x20
#define _SSPBUF_BUF5            0x20
#define _SSPBUF_SSP1BUF6        0x40
#define _SSPBUF_BUF6            0x40
#define _SSPBUF_SSP1BUF7        0x80
#define _SSPBUF_BUF7            0x80

//==============================================================================


//==============================================================================
//        SSP1ADD Bits

extern __at(0x0212) __sfr SSP1ADD;

typedef union
  {
  struct
    {
    unsigned SSP1ADD0           : 1;
    unsigned SSP1ADD1           : 1;
    unsigned SSP1ADD2           : 1;
    unsigned SSP1ADD3           : 1;
    unsigned SSP1ADD4           : 1;
    unsigned SSP1ADD5           : 1;
    unsigned SSP1ADD6           : 1;
    unsigned SSP1ADD7           : 1;
    };

  struct
    {
    unsigned ADD0               : 1;
    unsigned ADD1               : 1;
    unsigned ADD2               : 1;
    unsigned ADD3               : 1;
    unsigned ADD4               : 1;
    unsigned ADD5               : 1;
    unsigned ADD6               : 1;
    unsigned ADD7               : 1;
    };
  } __SSP1ADDbits_t;

extern __at(0x0212) volatile __SSP1ADDbits_t SSP1ADDbits;

#define _SSP1ADD0               0x01
#define _ADD0                   0x01
#define _SSP1ADD1               0x02
#define _ADD1                   0x02
#define _SSP1ADD2               0x04
#define _ADD2                   0x04
#define _SSP1ADD3               0x08
#define _ADD3                   0x08
#define _SSP1ADD4               0x10
#define _ADD4                   0x10
#define _SSP1ADD5               0x20
#define _ADD5                   0x20
#define _SSP1ADD6               0x40
#define _ADD6                   0x40
#define _SSP1ADD7               0x80
#define _ADD7                   0x80

//==============================================================================


//==============================================================================
//        SSPADD Bits

extern __at(0x0212) __sfr SSPADD;

typedef union
  {
  struct
    {
    unsigned SSP1ADD0           : 1;
    unsigned SSP1ADD1           : 1;
    unsigned SSP1ADD2           : 1;
    unsigned SSP1ADD3           : 1;
    unsigned SSP1ADD4           : 1;
    unsigned SSP1ADD5           : 1;
    unsigned SSP1ADD6           : 1;
    unsigned SSP1ADD7           : 1;
    };

  struct
    {
    unsigned ADD0               : 1;
    unsigned ADD1               : 1;
    unsigned ADD2               : 1;
    unsigned ADD3               : 1;
    unsigned ADD4               : 1;
    unsigned ADD5               : 1;
    unsigned ADD6               : 1;
    unsigned ADD7               : 1;
    };
  } __SSPADDbits_t;

extern __at(0x0212) volatile __SSPADDbits_t SSPADDbits;

#define _SSPADD_SSP1ADD0        0x01
#define _SSPADD_ADD0            0x01
#define _SSPADD_SSP1ADD1        0x02
#define _SSPADD_ADD1            0x02
#define _SSPADD_SSP1ADD2        0x04
#define _SSPADD_ADD2            0x04
#define _SSPADD_SSP1ADD3        0x08
#define _SSPADD_ADD3            0x08
#define _SSPADD_SSP1ADD4        0x10
#define _SSPADD_ADD4            0x10
#define _SSPADD_SSP1ADD5        0x20
#define _SSPADD_ADD5            0x20
#define _SSPADD_SSP1ADD6        0x40
#define _SSPADD_ADD6            0x40
#define _SSPADD_SSP1ADD7        0x80
#define _SSPADD_ADD7            0x80

//==============================================================================


//==============================================================================
//        SSP1MSK Bits

extern __at(0x0213) __sfr SSP1MSK;

typedef union
  {
  struct
    {
    unsigned SSP1MSK0           : 1;
    unsigned SSP1MSK1           : 1;
    unsigned SSP1MSK2           : 1;
    unsigned SSP1MSK3           : 1;
    unsigned SSP1MSK4           : 1;
    unsigned SSP1MSK5           : 1;
    unsigned SSP1MSK6           : 1;
    unsigned SSP1MSK7           : 1;
    };

  struct
    {
    unsigned MSK0               : 1;
    unsigned MSK1               : 1;
    unsigned MSK2               : 1;
    unsigned MSK3               : 1;
    unsigned MSK4               : 1;
    unsigned MSK5               : 1;
    unsigned MSK6               : 1;
    unsigned MSK7               : 1;
    };
  } __SSP1MSKbits_t;

extern __at(0x0213) volatile __SSP1MSKbits_t SSP1MSKbits;

#define _SSP1MSK0               0x01
#define _MSK0                   0x01
#define _SSP1MSK1               0x02
#define _MSK1                   0x02
#define _SSP1MSK2               0x04
#define _MSK2                   0x04
#define _SSP1MSK3               0x08
#define _MSK3                   0x08
#define _SSP1MSK4               0x10
#define _MSK4                   0x10
#define _SSP1MSK5               0x20
#define _MSK5                   0x20
#define _SSP1MSK6               0x40
#define _MSK6                   0x40
#define _SSP1MSK7               0x80
#define _MSK7                   0x80

//==============================================================================


//==============================================================================
//        SSPMSK Bits

extern __at(0x0213) __sfr SSPMSK;

typedef union
  {
  struct
    {
    unsigned SSP1MSK0           : 1;
    unsigned SSP1MSK1           : 1;
    unsigned SSP1MSK2           : 1;
    unsigned SSP1MSK3           : 1;
    unsigned SSP1MSK4           : 1;
    unsigned SSP1MSK5           : 1;
    unsigned SSP1MSK6           : 1;
    unsigned SSP1MSK7           : 1;
    };

  struct
    {
    unsigned MSK0               : 1;
    unsigned MSK1               : 1;
    unsigned MSK2               : 1;
    unsigned MSK3               : 1;
    unsigned MSK4               : 1;
    unsigned MSK5               : 1;
    unsigned MSK6               : 1;
    unsigned MSK7               : 1;
    };
  } __SSPMSKbits_t;

extern __at(0x0213) volatile __SSPMSKbits_t SSPMSKbits;

#define _SSPMSK_SSP1MSK0        0x01
#define _SSPMSK_MSK0            0x01
#define _SSPMSK_SSP1MSK1        0x02
#define _SSPMSK_MSK1            0x02
#define _SSPMSK_SSP1MSK2        0x04
#define _SSPMSK_MSK2            0x04
#define _SSPMSK_SSP1MSK3        0x08
#define _SSPMSK_MSK3            0x08
#define _SSPMSK_SSP1MSK4        0x10
#define _SSPMSK_MSK4            0x10
#define _SSPMSK_SSP1MSK5        0x20
#define _SSPMSK_MSK5            0x20
#define _SSPMSK_SSP1MSK6        0x40
#define _SSPMSK_MSK6            0x40
#define _SSPMSK_SSP1MSK7        0x80
#define _SSPMSK_MSK7            0x80

//==============================================================================


//==============================================================================
//        SSP1STAT Bits

extern __at(0x0214) __sfr SSP1STAT;

typedef struct
  {
  unsigned BF                   : 1;
  unsigned UA                   : 1;
  unsigned R_NOT_W              : 1;
  unsigned S                    : 1;
  unsigned P                    : 1;
  unsigned D_NOT_A              : 1;
  unsigned CKE                  : 1;
  unsigned SMP                  : 1;
  } __SSP1STATbits_t;

extern __at(0x0214) volatile __SSP1STATbits_t SSP1STATbits;

#define _BF                     0x01
#define _UA                     0x02
#define _R_NOT_W                0x04
#define _S                      0x08
#define _P                      0x10
#define _D_NOT_A                0x20
#define _CKE                    0x40
#define _SMP                    0x80

//==============================================================================


//==============================================================================
//        SSPSTAT Bits

extern __at(0x0214) __sfr SSPSTAT;

typedef struct
  {
  unsigned BF                   : 1;
  unsigned UA                   : 1;
  unsigned R_NOT_W              : 1;
  unsigned S                    : 1;
  unsigned P                    : 1;
  unsigned D_NOT_A              : 1;
  unsigned CKE                  : 1;
  unsigned SMP                  : 1;
  } __SSPSTATbits_t;

extern __at(0x0214) volatile __SSPSTATbits_t SSPSTATbits;

#define _SSPSTAT_BF             0x01
#define _SSPSTAT_UA             0x02
#define _SSPSTAT_R_NOT_W        0x04
#define _SSPSTAT_S              0x08
#define _SSPSTAT_P              0x10
#define _SSPSTAT_D_NOT_A        0x20
#define _SSPSTAT_CKE            0x40
#define _SSPSTAT_SMP            0x80

//==============================================================================


//==============================================================================
//        SSP1CON Bits

extern __at(0x0215) __sfr SSP1CON;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSP1CONbits_t;

extern __at(0x0215) volatile __SSP1CONbits_t SSP1CONbits;

#define _SSPM0                  0x01
#define _SSPM1                  0x02
#define _SSPM2                  0x04
#define _SSPM3                  0x08
#define _CKP                    0x10
#define _SSPEN                  0x20
#define _SSPOV                  0x40
#define _WCOL                   0x80

//==============================================================================


//==============================================================================
//        SSP1CON1 Bits

extern __at(0x0215) __sfr SSP1CON1;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSP1CON1bits_t;

extern __at(0x0215) volatile __SSP1CON1bits_t SSP1CON1bits;

#define _SSP1CON1_SSPM0         0x01
#define _SSP1CON1_SSPM1         0x02
#define _SSP1CON1_SSPM2         0x04
#define _SSP1CON1_SSPM3         0x08
#define _SSP1CON1_CKP           0x10
#define _SSP1CON1_SSPEN         0x20
#define _SSP1CON1_SSPOV         0x40
#define _SSP1CON1_WCOL          0x80

//==============================================================================


//==============================================================================
//        SSPCON Bits

extern __at(0x0215) __sfr SSPCON;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSPCONbits_t;

extern __at(0x0215) volatile __SSPCONbits_t SSPCONbits;

#define _SSPCON_SSPM0           0x01
#define _SSPCON_SSPM1           0x02
#define _SSPCON_SSPM2           0x04
#define _SSPCON_SSPM3           0x08
#define _SSPCON_CKP             0x10
#define _SSPCON_SSPEN           0x20
#define _SSPCON_SSPOV           0x40
#define _SSPCON_WCOL            0x80

//==============================================================================


//==============================================================================
//        SSPCON1 Bits

extern __at(0x0215) __sfr SSPCON1;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSPCON1bits_t;

extern __at(0x0215) volatile __SSPCON1bits_t SSPCON1bits;

#define _SSPCON1_SSPM0          0x01
#define _SSPCON1_SSPM1          0x02
#define _SSPCON1_SSPM2          0x04
#define _SSPCON1_SSPM3          0x08
#define _SSPCON1_CKP            0x10
#define _SSPCON1_SSPEN          0x20
#define _SSPCON1_SSPOV          0x40
#define _SSPCON1_WCOL           0x80

//==============================================================================


//==============================================================================
//        SSP1CON2 Bits

extern __at(0x0216) __sfr SSP1CON2;

typedef struct
  {
  unsigned SEN                  : 1;
  unsigned RSEN                 : 1;
  unsigned PEN                  : 1;
  unsigned RCEN                 : 1;
  unsigned ACKEN                : 1;
  unsigned ACKDT                : 1;
  unsigned ACKSTAT              : 1;
  unsigned GCEN                 : 1;
  } __SSP1CON2bits_t;

extern __at(0x0216) volatile __SSP1CON2bits_t SSP1CON2bits;

#define _SEN                    0x01
#define _RSEN                   0x02
#define _PEN                    0x04
#define _RCEN                   0x08
#define _ACKEN                  0x10
#define _ACKDT                  0x20
#define _ACKSTAT                0x40
#define _GCEN                   0x80

//==============================================================================


//==============================================================================
//        SSPCON2 Bits

extern __at(0x0216) __sfr SSPCON2;

typedef struct
  {
  unsigned SEN                  : 1;
  unsigned RSEN                 : 1;
  unsigned PEN                  : 1;
  unsigned RCEN                 : 1;
  unsigned ACKEN                : 1;
  unsigned ACKDT                : 1;
  unsigned ACKSTAT              : 1;
  unsigned GCEN                 : 1;
  } __SSPCON2bits_t;

extern __at(0x0216) volatile __SSPCON2bits_t SSPCON2bits;

#define _SSPCON2_SEN            0x01
#define _SSPCON2_RSEN           0x02
#define _SSPCON2_PEN            0x04
#define _SSPCON2_RCEN           0x08
#define _SSPCON2_ACKEN          0x10
#define _SSPCON2_ACKDT          0x20
#define _SSPCON2_ACKSTAT        0x40
#define _SSPCON2_GCEN           0x80

//==============================================================================


//==============================================================================
//        SSP1CON3 Bits

extern __at(0x0217) __sfr SSP1CON3;

typedef struct
  {
  unsigned DHEN                 : 1;
  unsigned AHEN                 : 1;
  unsigned SBCDE                : 1;
  unsigned SDAHT                : 1;
  unsigned BOEN                 : 1;
  unsigned SCIE                 : 1;
  unsigned PCIE                 : 1;
  unsigned ACKTIM               : 1;
  } __SSP1CON3bits_t;

extern __at(0x0217) volatile __SSP1CON3bits_t SSP1CON3bits;

#define _DHEN                   0x01
#define _AHEN                   0x02
#define _SBCDE                  0x04
#define _SDAHT                  0x08
#define _BOEN                   0x10
#define _SCIE                   0x20
#define _PCIE                   0x40
#define _ACKTIM                 0x80

//==============================================================================


//==============================================================================
//        SSPCON3 Bits

extern __at(0x0217) __sfr SSPCON3;

typedef struct
  {
  unsigned DHEN                 : 1;
  unsigned AHEN                 : 1;
  unsigned SBCDE                : 1;
  unsigned SDAHT                : 1;
  unsigned BOEN                 : 1;
  unsigned SCIE                 : 1;
  unsigned PCIE                 : 1;
  unsigned ACKTIM               : 1;
  } __SSPCON3bits_t;

extern __at(0x0217) volatile __SSPCON3bits_t SSPCON3bits;

#define _SSPCON3_DHEN           0x01
#define _SSPCON3_AHEN           0x02
#define _SSPCON3_SBCDE          0x04
#define _SSPCON3_SDAHT          0x08
#define _SSPCON3_BOEN           0x10
#define _SSPCON3_SCIE           0x20
#define _SSPCON3_PCIE           0x40
#define _SSPCON3_ACKTIM         0x80

//==============================================================================


//==============================================================================
//        ODCONA Bits

extern __at(0x028C) __sfr ODCONA;

typedef struct
  {
  unsigned ODA0                 : 1;
  unsigned ODA1                 : 1;
  unsigned ODA2                 : 1;
  unsigned                      : 1;
  unsigned ODA4                 : 1;
  unsigned ODA5                 : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __ODCONAbits_t;

extern __at(0x028C) volatile __ODCONAbits_t ODCONAbits;

#define _ODA0                   0x01
#define _ODA1                   0x02
#define _ODA2                   0x04
#define _ODA4                   0x10
#define _ODA5                   0x20

//==============================================================================


//==============================================================================
//        ODCONC Bits

extern __at(0x028E) __sfr ODCONC;

typedef union
  {
  struct
    {
    unsigned ODC0               : 1;
    unsigned ODC1               : 1;
    unsigned ODC2               : 1;
    unsigned ODC3               : 1;
    unsigned ODC4               : 1;
    unsigned ODC5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ODC                : 6;
    unsigned                    : 2;
    };
  } __ODCONCbits_t;

extern __at(0x028E) volatile __ODCONCbits_t ODCONCbits;

#define _ODC0                   0x01
#define _ODC1                   0x02
#define _ODC2                   0x04
#define _ODC3                   0x08
#define _ODC4                   0x10
#define _ODC5                   0x20

//==============================================================================

extern __at(0x0291) __sfr CCPR1;
extern __at(0x0291) __sfr CCPR1L;
extern __at(0x0292) __sfr CCPR1H;

//==============================================================================
//        CCP1CON Bits

extern __at(0x0293) __sfr CCP1CON;

typedef union
  {
  struct
    {
    unsigned CCP1M0             : 1;
    unsigned CCP1M1             : 1;
    unsigned CCP1M2             : 1;
    unsigned CCP1M3             : 1;
    unsigned DC1B0              : 1;
    unsigned DC1B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP1Y              : 1;
    unsigned CCP1X              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP1M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC1B               : 2;
    unsigned                    : 2;
    };
  } __CCP1CONbits_t;

extern __at(0x0293) volatile __CCP1CONbits_t CCP1CONbits;

#define _CCP1M0                 0x01
#define _CCP1M1                 0x02
#define _CCP1M2                 0x04
#define _CCP1M3                 0x08
#define _DC1B0                  0x10
#define _CCP1Y                  0x10
#define _DC1B1                  0x20
#define _CCP1X                  0x20

//==============================================================================


//==============================================================================
//        ECCP1CON Bits

extern __at(0x0293) __sfr ECCP1CON;

typedef union
  {
  struct
    {
    unsigned CCP1M0             : 1;
    unsigned CCP1M1             : 1;
    unsigned CCP1M2             : 1;
    unsigned CCP1M3             : 1;
    unsigned DC1B0              : 1;
    unsigned DC1B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP1Y              : 1;
    unsigned CCP1X              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP1M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC1B               : 2;
    unsigned                    : 2;
    };
  } __ECCP1CONbits_t;

extern __at(0x0293) volatile __ECCP1CONbits_t ECCP1CONbits;

#define _ECCP1CON_CCP1M0        0x01
#define _ECCP1CON_CCP1M1        0x02
#define _ECCP1CON_CCP1M2        0x04
#define _ECCP1CON_CCP1M3        0x08
#define _ECCP1CON_DC1B0         0x10
#define _ECCP1CON_CCP1Y         0x10
#define _ECCP1CON_DC1B1         0x20
#define _ECCP1CON_CCP1X         0x20

//==============================================================================

extern __at(0x0298) __sfr CCPR2;
extern __at(0x0298) __sfr CCPR2L;
extern __at(0x0299) __sfr CCPR2H;

//==============================================================================
//        CCP2CON Bits

extern __at(0x029A) __sfr CCP2CON;

typedef union
  {
  struct
    {
    unsigned CCP2M0             : 1;
    unsigned CCP2M1             : 1;
    unsigned CCP2M2             : 1;
    unsigned CCP2M3             : 1;
    unsigned DC2B0              : 1;
    unsigned DC2B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP2Y              : 1;
    unsigned CCP2X              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP2M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC2B               : 2;
    unsigned                    : 2;
    };
  } __CCP2CONbits_t;

extern __at(0x029A) volatile __CCP2CONbits_t CCP2CONbits;

#define _CCP2M0                 0x01
#define _CCP2M1                 0x02
#define _CCP2M2                 0x04
#define _CCP2M3                 0x08
#define _DC2B0                  0x10
#define _CCP2Y                  0x10
#define _DC2B1                  0x20
#define _CCP2X                  0x20

//==============================================================================


//==============================================================================
//        ECCP2CON Bits

extern __at(0x029A) __sfr ECCP2CON;

typedef union
  {
  struct
    {
    unsigned CCP2M0             : 1;
    unsigned CCP2M1             : 1;
    unsigned CCP2M2             : 1;
    unsigned CCP2M3             : 1;
    unsigned DC2B0              : 1;
    unsigned DC2B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP2Y              : 1;
    unsigned CCP2X              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP2M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC2B               : 2;
    unsigned                    : 2;
    };
  } __ECCP2CONbits_t;

extern __at(0x029A) volatile __ECCP2CONbits_t ECCP2CONbits;

#define _ECCP2CON_CCP2M0        0x01
#define _ECCP2CON_CCP2M1        0x02
#define _ECCP2CON_CCP2M2        0x04
#define _ECCP2CON_CCP2M3        0x08
#define _ECCP2CON_DC2B0         0x10
#define _ECCP2CON_CCP2Y         0x10
#define _ECCP2CON_DC2B1         0x20
#define _ECCP2CON_CCP2X         0x20

//==============================================================================


//==============================================================================
//        SLRCONA Bits

extern __at(0x030C) __sfr SLRCONA;

typedef struct
  {
  unsigned SLRA0                : 1;
  unsigned SLRA1                : 1;
  unsigned SLRA2                : 1;
  unsigned                      : 1;
  unsigned SLRA4                : 1;
  unsigned SLRA5                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __SLRCONAbits_t;

extern __at(0x030C) volatile __SLRCONAbits_t SLRCONAbits;

#define _SLRA0                  0x01
#define _SLRA1                  0x02
#define _SLRA2                  0x04
#define _SLRA4                  0x10
#define _SLRA5                  0x20

//==============================================================================


//==============================================================================
//        SLRCONC Bits

extern __at(0x030E) __sfr SLRCONC;

typedef union
  {
  struct
    {
    unsigned SLRC0              : 1;
    unsigned SLRC1              : 1;
    unsigned SLRC2              : 1;
    unsigned SLRC3              : 1;
    unsigned SLRC4              : 1;
    unsigned SLRC5              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SLRC               : 6;
    unsigned                    : 2;
    };
  } __SLRCONCbits_t;

extern __at(0x030E) volatile __SLRCONCbits_t SLRCONCbits;

#define _SLRC0                  0x01
#define _SLRC1                  0x02
#define _SLRC2                  0x04
#define _SLRC3                  0x08
#define _SLRC4                  0x10
#define _SLRC5                  0x20

//==============================================================================


//==============================================================================
//        INLVLA Bits

extern __at(0x038C) __sfr INLVLA;

typedef union
  {
  struct
    {
    unsigned INLVLA0            : 1;
    unsigned INLVLA1            : 1;
    unsigned INLVLA2            : 1;
    unsigned INLVLA3            : 1;
    unsigned INLVLA4            : 1;
    unsigned INLVLA5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned INLVLA             : 6;
    unsigned                    : 2;
    };
  } __INLVLAbits_t;

extern __at(0x038C) volatile __INLVLAbits_t INLVLAbits;

#define _INLVLA0                0x01
#define _INLVLA1                0x02
#define _INLVLA2                0x04
#define _INLVLA3                0x08
#define _INLVLA4                0x10
#define _INLVLA5                0x20

//==============================================================================


//==============================================================================
//        INLVLC Bits

extern __at(0x038E) __sfr INLVLC;

typedef union
  {
  struct
    {
    unsigned INLVLC0            : 1;
    unsigned INLVLC1            : 1;
    unsigned INLVLC2            : 1;
    unsigned INLVLC3            : 1;
    unsigned INLVLC4            : 1;
    unsigned INLVLC5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned INLVLC             : 6;
    unsigned                    : 2;
    };
  } __INLVLCbits_t;

extern __at(0x038E) volatile __INLVLCbits_t INLVLCbits;

#define _INLVLC0                0x01
#define _INLVLC1                0x02
#define _INLVLC2                0x04
#define _INLVLC3                0x08
#define _INLVLC4                0x10
#define _INLVLC5                0x20

//==============================================================================


//==============================================================================
//        IOCAP Bits

extern __at(0x0391) __sfr IOCAP;

typedef union
  {
  struct
    {
    unsigned IOCAP0             : 1;
    unsigned IOCAP1             : 1;
    unsigned IOCAP2             : 1;
    unsigned IOCAP3             : 1;
    unsigned IOCAP4             : 1;
    unsigned IOCAP5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned IOCAP              : 6;
    unsigned                    : 2;
    };
  } __IOCAPbits_t;

extern __at(0x0391) volatile __IOCAPbits_t IOCAPbits;

#define _IOCAP0                 0x01
#define _IOCAP1                 0x02
#define _IOCAP2                 0x04
#define _IOCAP3                 0x08
#define _IOCAP4                 0x10
#define _IOCAP5                 0x20

//==============================================================================


//==============================================================================
//        IOCAN Bits

extern __at(0x0392) __sfr IOCAN;

typedef union
  {
  struct
    {
    unsigned IOCAN0             : 1;
    unsigned IOCAN1             : 1;
    unsigned IOCAN2             : 1;
    unsigned IOCAN3             : 1;
    unsigned IOCAN4             : 1;
    unsigned IOCAN5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned IOCAN              : 6;
    unsigned                    : 2;
    };
  } __IOCANbits_t;

extern __at(0x0392) volatile __IOCANbits_t IOCANbits;

#define _IOCAN0                 0x01
#define _IOCAN1                 0x02
#define _IOCAN2                 0x04
#define _IOCAN3                 0x08
#define _IOCAN4                 0x10
#define _IOCAN5                 0x20

//==============================================================================


//==============================================================================
//        IOCAF Bits

extern __at(0x0393) __sfr IOCAF;

typedef union
  {
  struct
    {
    unsigned IOCAF0             : 1;
    unsigned IOCAF1             : 1;
    unsigned IOCAF2             : 1;
    unsigned IOCAF3             : 1;
    unsigned IOCAF4             : 1;
    unsigned IOCAF5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned IOCAF              : 6;
    unsigned                    : 2;
    };
  } __IOCAFbits_t;

extern __at(0x0393) volatile __IOCAFbits_t IOCAFbits;

#define _IOCAF0                 0x01
#define _IOCAF1                 0x02
#define _IOCAF2                 0x04
#define _IOCAF3                 0x08
#define _IOCAF4                 0x10
#define _IOCAF5                 0x20

//==============================================================================


//==============================================================================
//        IOCCP Bits

extern __at(0x0397) __sfr IOCCP;

typedef union
  {
  struct
    {
    unsigned IOCCP0             : 1;
    unsigned IOCCP1             : 1;
    unsigned IOCCP2             : 1;
    unsigned IOCCP3             : 1;
    unsigned IOCCP4             : 1;
    unsigned IOCCP5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned IOCCP              : 6;
    unsigned                    : 2;
    };
  } __IOCCPbits_t;

extern __at(0x0397) volatile __IOCCPbits_t IOCCPbits;

#define _IOCCP0                 0x01
#define _IOCCP1                 0x02
#define _IOCCP2                 0x04
#define _IOCCP3                 0x08
#define _IOCCP4                 0x10
#define _IOCCP5                 0x20

//==============================================================================


//==============================================================================
//        IOCCN Bits

extern __at(0x0398) __sfr IOCCN;

typedef union
  {
  struct
    {
    unsigned IOCCN0             : 1;
    unsigned IOCCN1             : 1;
    unsigned IOCCN2             : 1;
    unsigned IOCCN3             : 1;
    unsigned IOCCN4             : 1;
    unsigned IOCCN5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned IOCCN              : 6;
    unsigned                    : 2;
    };
  } __IOCCNbits_t;

extern __at(0x0398) volatile __IOCCNbits_t IOCCNbits;

#define _IOCCN0                 0x01
#define _IOCCN1                 0x02
#define _IOCCN2                 0x04
#define _IOCCN3                 0x08
#define _IOCCN4                 0x10
#define _IOCCN5                 0x20

//==============================================================================


//==============================================================================
//        IOCCF Bits

extern __at(0x0399) __sfr IOCCF;

typedef union
  {
  struct
    {
    unsigned IOCCF0             : 1;
    unsigned IOCCF1             : 1;
    unsigned IOCCF2             : 1;
    unsigned IOCCF3             : 1;
    unsigned IOCCF4             : 1;
    unsigned IOCCF5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned IOCCF              : 6;
    unsigned                    : 2;
    };
  } __IOCCFbits_t;

extern __at(0x0399) volatile __IOCCFbits_t IOCCFbits;

#define _IOCCF0                 0x01
#define _IOCCF1                 0x02
#define _IOCCF2                 0x04
#define _IOCCF3                 0x08
#define _IOCCF4                 0x10
#define _IOCCF5                 0x20

//==============================================================================


//==============================================================================
//        OPA1CON Bits

extern __at(0x0511) __sfr OPA1CON;

typedef union
  {
  struct
    {
    unsigned OPA1PCH0           : 1;
    unsigned OPA1PCH1           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned OPA1UG             : 1;
    unsigned                    : 1;
    unsigned OPA1SP             : 1;
    unsigned OPA1EN             : 1;
    };

  struct
    {
    unsigned OPA1PCH            : 2;
    unsigned                    : 6;
    };
  } __OPA1CONbits_t;

extern __at(0x0511) volatile __OPA1CONbits_t OPA1CONbits;

#define _OPA1PCH0               0x01
#define _OPA1PCH1               0x02
#define _OPA1UG                 0x10
#define _OPA1SP                 0x40
#define _OPA1EN                 0x80

//==============================================================================


//==============================================================================
//        OPA2CON Bits

extern __at(0x0515) __sfr OPA2CON;

typedef union
  {
  struct
    {
    unsigned OPA2PCH0           : 1;
    unsigned OPA2PCH1           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned OPA2UG             : 1;
    unsigned                    : 1;
    unsigned OPA2SP             : 1;
    unsigned OPA2EN             : 1;
    };

  struct
    {
    unsigned OPA2PCH            : 2;
    unsigned                    : 6;
    };
  } __OPA2CONbits_t;

extern __at(0x0515) volatile __OPA2CONbits_t OPA2CONbits;

#define _OPA2PCH0               0x01
#define _OPA2PCH1               0x02
#define _OPA2UG                 0x10
#define _OPA2SP                 0x40
#define _OPA2EN                 0x80

//==============================================================================


//==============================================================================
//        PPSLOCK Bits

extern __at(0x0E0F) __sfr PPSLOCK;

typedef struct
  {
  unsigned PPSLOCKED            : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PPSLOCKbits_t;

extern __at(0x0E0F) volatile __PPSLOCKbits_t PPSLOCKbits;

#define _PPSLOCKED              0x01

//==============================================================================

extern __at(0x0E10) __sfr INTPPS;
extern __at(0x0E11) __sfr T0CKIPPS;
extern __at(0x0E12) __sfr T1CKIPPS;
extern __at(0x0E13) __sfr T1GPPS;
extern __at(0x0E14) __sfr CCP1PPS;
extern __at(0x0E15) __sfr CCP2PPS;
extern __at(0x0E20) __sfr SSPCLKPPS;
extern __at(0x0E21) __sfr SSPDATPPS;
extern __at(0x0E22) __sfr SSPSSPPS;
extern __at(0x0E90) __sfr RA0PPS;
extern __at(0x0E91) __sfr RA1PPS;
extern __at(0x0E92) __sfr RA2PPS;
extern __at(0x0E94) __sfr RA4PPS;
extern __at(0x0E95) __sfr RA5PPS;
extern __at(0x0EA0) __sfr RC0PPS;
extern __at(0x0EA1) __sfr RC1PPS;
extern __at(0x0EA2) __sfr RC2PPS;
extern __at(0x0EA3) __sfr RC3PPS;
extern __at(0x0EA4) __sfr RC4PPS;
extern __at(0x0EA5) __sfr RC5PPS;

//==============================================================================
//        ICDBK0H Bits

extern __at(0x0F9E) __sfr ICDBK0H;

typedef struct
  {
  unsigned BKA8                 : 1;
  unsigned BKA9                 : 1;
  unsigned BKA10                : 1;
  unsigned BKA11                : 1;
  unsigned BKA12                : 1;
  unsigned BKA13                : 1;
  unsigned BKA14                : 1;
  unsigned                      : 1;
  } __ICDBK0Hbits_t;

extern __at(0x0F9E) volatile __ICDBK0Hbits_t ICDBK0Hbits;

#define _BKA8                   0x01
#define _BKA9                   0x02
#define _BKA10                  0x04
#define _BKA11                  0x08
#define _BKA12                  0x10
#define _BKA13                  0x20
#define _BKA14                  0x40

//==============================================================================


//==============================================================================
//        STATUS_SHAD Bits

extern __at(0x0FE4) __sfr STATUS_SHAD;

typedef struct
  {
  unsigned C_SHAD               : 1;
  unsigned DC_SHAD              : 1;
  unsigned Z_SHAD               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __STATUS_SHADbits_t;

extern __at(0x0FE4) volatile __STATUS_SHADbits_t STATUS_SHADbits;

#define _C_SHAD                 0x01
#define _DC_SHAD                0x02
#define _Z_SHAD                 0x04

//==============================================================================

extern __at(0x0FE5) __sfr WREG_SHAD;
extern __at(0x0FE6) __sfr BSR_SHAD;
extern __at(0x0FE7) __sfr PCLATH_SHAD;
extern __at(0x0FE8) __sfr FSR0L_SHAD;
extern __at(0x0FE9) __sfr FSR0H_SHAD;
extern __at(0x0FEA) __sfr FSR1L_SHAD;
extern __at(0x0FEB) __sfr FSR1H_SHAD;
extern __at(0x0FED) __sfr STKPTR;
extern __at(0x0FEE) __sfr TOSL;
extern __at(0x0FEF) __sfr TOSH;

//==============================================================================
//
//        Configuration Bits
//
//==============================================================================

#define _CONFIG1                0x8007
#define _CONFIG2                0x8008

//----------------------------- CONFIG1 Options -------------------------------

#define _FOSC_INTOSC            0x3FFC  // Internal HFINTOSC. I/O function on RA4 and RA5.
#define _FOSC_ECL               0x3FFD  // External oscillator, low power. I/O function on RA4.
#define _FOSC_ECM               0x3FFE  // External oscillator, medium power. I/O function on RA4.
#define _FOSC_ECH               0x3FFF  // External oscillator, high power. I/O function on RA4.
#define _WDTE_OFF               0x3FE7  // WDT disabled.
#define _WDTE_SWDTEN            0x3FEF  // WDT controlled by the SWDTEN bit in the WDTCON register.
#define _WDTE_NSLEEP            0x3FF7  // WDT enabled while running and disabled in Sleep.
#define _WDTE_ON                0x3FFF  // WDT enabled.
#define _PWRTE_ON               0x3FDF  // PWRT enabled.
#define _PWRTE_OFF              0x3FFF  // PWRT disabled.
#define _MCLRE_OFF              0x3FBF  // MCLR/VPP pin function is digital input.
#define _MCLRE_ON               0x3FFF  // MCLR/VPP pin function is MCLR.
#define _CP_ON                  0x3F7F  // Program memory code protection is enabled.
#define _CP_OFF                 0x3FFF  // Program memory code protection is disabled.
#define _BOREN_OFF              0x39FF  // Brown-out Reset disabled.
#define _BOREN_SBODEN           0x3BFF  // Brown-out Reset controlled by the SBOREN bit in the BORCON register.
#define _BOREN_NSLEEP           0x3DFF  // Brown-out Reset enabled while running and disabled in Sleep.
#define _BOREN_ON               0x3FFF  // Brown-out Reset enabled.
#define _CLKOUTEN_ON            0x37FF  // CLKOUT function is enabled on the CLKOUT pin.
#define _CLKOUTEN_OFF           0x3FFF  // CLKOUT function is disabled. I/O or oscillator function on the CLKOUT pin.

//----------------------------- CONFIG2 Options -------------------------------

#define _WRT_ALL                0x3FFC  // 000h to 1FFFh write protected, no addresses may be modified by EECON control.
#define _WRT_HALF               0x3FFD  // 000h to FFFh write protected, 1000h to 1FFFh may be modified by EECON control.
#define _WRT_BOOT               0x3FFE  // 000h to 1FFh write protected, 200h to 1FFFh may be modified by EECON control.
#define _WRT_OFF                0x3FFF  // Write protection off.
#define _PPS1WAY_OFF            0x3FFB  // The PPSLOCK bit can be set and cleared repeatedly by software.
#define _PPS1WAY_ON             0x3FFF  // The PPSLOCK bit cannot be cleared once it is set by software.
#define _ZCDDIS_OFF             0x3F7F  // Zero-cross detect circuit is enabled at POR.
#define _ZCDDIS_ON              0x3FFF  // Zero-cross detect circuit is disabled at POR.
#define _PLLEN_OFF              0x3EFF  // 4x PLL is enabled when software sets the SPLLEN bit.
#define _PLLEN_ON               0x3FFF  // 4x PLL is always enabled.
#define _STVREN_OFF             0x3DFF  // Stack Overflow or Underflow will not cause a Reset.
#define _STVREN_ON              0x3FFF  // Stack Overflow or Underflow will cause a Reset.
#define _BORV_HI                0x3BFF  // Brown-out Reset Voltage (Vbor), high trip point selected.
#define _BORV_LO                0x3FFF  // Brown-out Reset Voltage (Vbor), low trip point selected.
#define _LPBOR_ON               0x37FF  // Low-Power BOR is enabled.
#define _LPBOR_OFF              0x3FFF  // Low-Power BOR is disabled.
#define _DEBUG_ON               0x2FFF  // In-Circuit Debugger enabled, ICSPCLK and ICSPDAT are dedicated to the debugger.
#define _DEBUG_OFF              0x3FFF  // In-Circuit Debugger disabled, ICSPCLK and ICSPDAT are general purpose I/O pins.
#define _LVP_OFF                0x1FFF  // High-voltage on MCLR/VPP must be used for programming.
#define _LVP_ON                 0x3FFF  // Low-voltage programming enabled.

//==============================================================================

#define _DEVID1                 0x8006

#define _IDLOC0                 0x8000
#define _IDLOC1                 0x8001
#define _IDLOC2                 0x8002
#define _IDLOC3                 0x8003

//==============================================================================

#ifndef NO_BIT_DEFINES

#define ADON                    ADCON0bits.ADON                 // bit 0
#define GO_NOT_DONE             ADCON0bits.GO_NOT_DONE          // bit 1, shadows bit in ADCON0bits
#define ADGO                    ADCON0bits.ADGO                 // bit 1, shadows bit in ADCON0bits
#define GO                      ADCON0bits.GO                   // bit 1, shadows bit in ADCON0bits
#define CHS0                    ADCON0bits.CHS0                 // bit 2
#define CHS1                    ADCON0bits.CHS1                 // bit 3
#define CHS2                    ADCON0bits.CHS2                 // bit 4
#define CHS3                    ADCON0bits.CHS3                 // bit 5
#define CHS4                    ADCON0bits.CHS4                 // bit 6

#define ADPREF0                 ADCON1bits.ADPREF0              // bit 0
#define ADPREF1                 ADCON1bits.ADPREF1              // bit 1
#define ADNREF                  ADCON1bits.ADNREF               // bit 2
#define ADFM                    ADCON1bits.ADFM                 // bit 7

#define TRIGSEL0                ADCON2bits.TRIGSEL0             // bit 4
#define TRIGSEL1                ADCON2bits.TRIGSEL1             // bit 5
#define TRIGSEL2                ADCON2bits.TRIGSEL2             // bit 6
#define TRIGSEL3                ADCON2bits.TRIGSEL3             // bit 7

#define ANSA0                   ANSELAbits.ANSA0                // bit 0
#define ANSA1                   ANSELAbits.ANSA1                // bit 1
#define ANSA2                   ANSELAbits.ANSA2                // bit 2
#define ANSA4                   ANSELAbits.ANSA4                // bit 4

#define ANSC0                   ANSELCbits.ANSC0                // bit 0
#define ANSC1                   ANSELCbits.ANSC1                // bit 1
#define ANSC2                   ANSELCbits.ANSC2                // bit 2
#define ANSC3                   ANSELCbits.ANSC3                // bit 3
#define ANSC4                   ANSELCbits.ANSC4                // bit 4
#define ANSC5                   ANSELCbits.ANSC5                // bit 5

#define BORRDY                  BORCONbits.BORRDY               // bit 0
#define BORFS                   BORCONbits.BORFS                // bit 6
#define SBOREN                  BORCONbits.SBOREN               // bit 7

#define BSR0                    BSRbits.BSR0                    // bit 0
#define BSR1                    BSRbits.BSR1                    // bit 1
#define BSR2                    BSRbits.BSR2                    // bit 2
#define BSR3                    BSRbits.BSR3                    // bit 3
#define BSR4                    BSRbits.BSR4                    // bit 4

#define CCP1M0                  CCP1CONbits.CCP1M0              // bit 0
#define CCP1M1                  CCP1CONbits.CCP1M1              // bit 1
#define CCP1M2                  CCP1CONbits.CCP1M2              // bit 2
#define CCP1M3                  CCP1CONbits.CCP1M3              // bit 3
#define DC1B0                   CCP1CONbits.DC1B0               // bit 4, shadows bit in CCP1CONbits
#define CCP1Y                   CCP1CONbits.CCP1Y               // bit 4, shadows bit in CCP1CONbits
#define DC1B1                   CCP1CONbits.DC1B1               // bit 5, shadows bit in CCP1CONbits
#define CCP1X                   CCP1CONbits.CCP1X               // bit 5, shadows bit in CCP1CONbits

#define CCP2M0                  CCP2CONbits.CCP2M0              // bit 0
#define CCP2M1                  CCP2CONbits.CCP2M1              // bit 1
#define CCP2M2                  CCP2CONbits.CCP2M2              // bit 2
#define CCP2M3                  CCP2CONbits.CCP2M3              // bit 3
#define DC2B0                   CCP2CONbits.DC2B0               // bit 4, shadows bit in CCP2CONbits
#define CCP2Y                   CCP2CONbits.CCP2Y               // bit 4, shadows bit in CCP2CONbits
#define DC2B1                   CCP2CONbits.DC2B1               // bit 5, shadows bit in CCP2CONbits
#define CCP2X                   CCP2CONbits.CCP2X               // bit 5, shadows bit in CCP2CONbits

#define ADFVR0                  FVRCONbits.ADFVR0               // bit 0
#define ADFVR1                  FVRCONbits.ADFVR1               // bit 1
#define CDAFVR0                 FVRCONbits.CDAFVR0              // bit 2
#define CDAFVR1                 FVRCONbits.CDAFVR1              // bit 3
#define TSRNG                   FVRCONbits.TSRNG                // bit 4
#define TSEN                    FVRCONbits.TSEN                 // bit 5
#define FVRRDY                  FVRCONbits.FVRRDY               // bit 6
#define FVREN                   FVRCONbits.FVREN                // bit 7

#define BKA8                    ICDBK0Hbits.BKA8                // bit 0
#define BKA9                    ICDBK0Hbits.BKA9                // bit 1
#define BKA10                   ICDBK0Hbits.BKA10               // bit 2
#define BKA11                   ICDBK0Hbits.BKA11               // bit 3
#define BKA12                   ICDBK0Hbits.BKA12               // bit 4
#define BKA13                   ICDBK0Hbits.BKA13               // bit 5
#define BKA14                   ICDBK0Hbits.BKA14               // bit 6

#define INLVLA0                 INLVLAbits.INLVLA0              // bit 0
#define INLVLA1                 INLVLAbits.INLVLA1              // bit 1
#define INLVLA2                 INLVLAbits.INLVLA2              // bit 2
#define INLVLA3                 INLVLAbits.INLVLA3              // bit 3
#define INLVLA4                 INLVLAbits.INLVLA4              // bit 4
#define INLVLA5                 INLVLAbits.INLVLA5              // bit 5

#define INLVLC0                 INLVLCbits.INLVLC0              // bit 0
#define INLVLC1                 INLVLCbits.INLVLC1              // bit 1
#define INLVLC2                 INLVLCbits.INLVLC2              // bit 2
#define INLVLC3                 INLVLCbits.INLVLC3              // bit 3
#define INLVLC4                 INLVLCbits.INLVLC4              // bit 4
#define INLVLC5                 INLVLCbits.INLVLC5              // bit 5

#define IOCIF                   INTCONbits.IOCIF                // bit 0
#define INTF                    INTCONbits.INTF                 // bit 1
#define TMR0IF                  INTCONbits.TMR0IF               // bit 2, shadows bit in INTCONbits
#define T0IF                    INTCONbits.T0IF                 // bit 2, shadows bit in INTCONbits
#define IOCIE                   INTCONbits.IOCIE                // bit 3
#define INTE                    INTCONbits.INTE                 // bit 4
#define TMR0IE                  INTCONbits.TMR0IE               // bit 5, shadows bit in INTCONbits
#define T0IE                    INTCONbits.T0IE                 // bit 5, shadows bit in INTCONbits
#define PEIE                    INTCONbits.PEIE                 // bit 6
#define GIE                     INTCONbits.GIE                  // bit 7

#define IOCAF0                  IOCAFbits.IOCAF0                // bit 0
#define IOCAF1                  IOCAFbits.IOCAF1                // bit 1
#define IOCAF2                  IOCAFbits.IOCAF2                // bit 2
#define IOCAF3                  IOCAFbits.IOCAF3                // bit 3
#define IOCAF4                  IOCAFbits.IOCAF4                // bit 4
#define IOCAF5                  IOCAFbits.IOCAF5                // bit 5

#define IOCAN0                  IOCANbits.IOCAN0                // bit 0
#define IOCAN1                  IOCANbits.IOCAN1                // bit 1
#define IOCAN2                  IOCANbits.IOCAN2                // bit 2
#define IOCAN3                  IOCANbits.IOCAN3                // bit 3
#define IOCAN4                  IOCANbits.IOCAN4                // bit 4
#define IOCAN5                  IOCANbits.IOCAN5                // bit 5

#define IOCAP0                  IOCAPbits.IOCAP0                // bit 0
#define IOCAP1                  IOCAPbits.IOCAP1                // bit 1
#define IOCAP2                  IOCAPbits.IOCAP2                // bit 2
#define IOCAP3                  IOCAPbits.IOCAP3                // bit 3
#define IOCAP4                  IOCAPbits.IOCAP4                // bit 4
#define IOCAP5                  IOCAPbits.IOCAP5                // bit 5

#define IOCCF0                  IOCCFbits.IOCCF0                // bit 0
#define IOCCF1                  IOCCFbits.IOCCF1                // bit 1
#define IOCCF2                  IOCCFbits.IOCCF2                // bit 2
#define IOCCF3                  IOCCFbits.IOCCF3                // bit 3
#define IOCCF4                  IOCCFbits.IOCCF4                // bit 4
#define IOCCF5                  IOCCFbits.IOCCF5                // bit 5

#define IOCCN0                  IOCCNbits.IOCCN0                // bit 0
#define IOCCN1                  IOCCNbits.IOCCN1                // bit 1
#define IOCCN2                  IOCCNbits.IOCCN2                // bit 2
#define IOCCN3                  IOCCNbits.IOCCN3                // bit 3
#define IOCCN4                  IOCCNbits.IOCCN4                // bit 4
#define IOCCN5                  IOCCNbits.IOCCN5                // bit 5

#define IOCCP0                  IOCCPbits.IOCCP0                // bit 0
#define IOCCP1                  IOCCPbits.IOCCP1                // bit 1
#define IOCCP2                  IOCCPbits.IOCCP2                // bit 2
#define IOCCP3                  IOCCPbits.IOCCP3                // bit 3
#define IOCCP4                  IOCCPbits.IOCCP4                // bit 4
#define IOCCP5                  IOCCPbits.IOCCP5                // bit 5

#define LATA0                   LATAbits.LATA0                  // bit 0
#define LATA1                   LATAbits.LATA1                  // bit 1
#define LATA2                   LATAbits.LATA2                  // bit 2
#define LATA4                   LATAbits.LATA4                  // bit 4
#define LATA5                   LATAbits.LATA5                  // bit 5

#define LATC0                   LATCbits.LATC0                  // bit 0
#define LATC1                   LATCbits.LATC1                  // bit 1
#define LATC2                   LATCbits.LATC2                  // bit 2
#define LATC3                   LATCbits.LATC3                  // bit 3
#define LATC4                   LATCbits.LATC4                  // bit 4
#define LATC5                   LATCbits.LATC5                  // bit 5

#define ODA0                    ODCONAbits.ODA0                 // bit 0
#define ODA1                    ODCONAbits.ODA1                 // bit 1
#define ODA2                    ODCONAbits.ODA2                 // bit 2
#define ODA4                    ODCONAbits.ODA4                 // bit 4
#define ODA5                    ODCONAbits.ODA5                 // bit 5

#define ODC0                    ODCONCbits.ODC0                 // bit 0
#define ODC1                    ODCONCbits.ODC1                 // bit 1
#define ODC2                    ODCONCbits.ODC2                 // bit 2
#define ODC3                    ODCONCbits.ODC3                 // bit 3
#define ODC4                    ODCONCbits.ODC4                 // bit 4
#define ODC5                    ODCONCbits.ODC5                 // bit 5

#define OPA1PCH0                OPA1CONbits.OPA1PCH0            // bit 0
#define OPA1PCH1                OPA1CONbits.OPA1PCH1            // bit 1
#define OPA1UG                  OPA1CONbits.OPA1UG              // bit 4
#define OPA1SP                  OPA1CONbits.OPA1SP              // bit 6
#define OPA1EN                  OPA1CONbits.OPA1EN              // bit 7

#define OPA2PCH0                OPA2CONbits.OPA2PCH0            // bit 0
#define OPA2PCH1                OPA2CONbits.OPA2PCH1            // bit 1
#define OPA2UG                  OPA2CONbits.OPA2UG              // bit 4
#define OPA2SP                  OPA2CONbits.OPA2SP              // bit 6
#define OPA2EN                  OPA2CONbits.OPA2EN              // bit 7

#define PS0                     OPTION_REGbits.PS0              // bit 0
#define PS1                     OPTION_REGbits.PS1              // bit 1
#define PS2                     OPTION_REGbits.PS2              // bit 2
#define PSA                     OPTION_REGbits.PSA              // bit 3
#define TMR0SE                  OPTION_REGbits.TMR0SE           // bit 4, shadows bit in OPTION_REGbits
#define T0SE                    OPTION_REGbits.T0SE             // bit 4, shadows bit in OPTION_REGbits
#define TMR0CS                  OPTION_REGbits.TMR0CS           // bit 5, shadows bit in OPTION_REGbits
#define T0CS                    OPTION_REGbits.T0CS             // bit 5, shadows bit in OPTION_REGbits
#define INTEDG                  OPTION_REGbits.INTEDG           // bit 6
#define NOT_WPUEN               OPTION_REGbits.NOT_WPUEN        // bit 7

#define SCS0                    OSCCONbits.SCS0                 // bit 0
#define SCS1                    OSCCONbits.SCS1                 // bit 1
#define IRCF0                   OSCCONbits.IRCF0                // bit 3
#define IRCF1                   OSCCONbits.IRCF1                // bit 4
#define IRCF2                   OSCCONbits.IRCF2                // bit 5
#define IRCF3                   OSCCONbits.IRCF3                // bit 6
#define SPLLEN                  OSCCONbits.SPLLEN               // bit 7

#define HFIOFS                  OSCSTATbits.HFIOFS              // bit 0
#define LFIOFR                  OSCSTATbits.LFIOFR              // bit 1
#define MFIOFR                  OSCSTATbits.MFIOFR              // bit 2
#define HFIOFL                  OSCSTATbits.HFIOFL              // bit 3
#define HFIOFR                  OSCSTATbits.HFIOFR              // bit 4
#define OSTS                    OSCSTATbits.OSTS                // bit 5
#define PLLR                    OSCSTATbits.PLLR                // bit 6
#define SOSCR                   OSCSTATbits.SOSCR               // bit 7

#define TUN0                    OSCTUNEbits.TUN0                // bit 0
#define TUN1                    OSCTUNEbits.TUN1                // bit 1
#define TUN2                    OSCTUNEbits.TUN2                // bit 2
#define TUN3                    OSCTUNEbits.TUN3                // bit 3
#define TUN4                    OSCTUNEbits.TUN4                // bit 4
#define TUN5                    OSCTUNEbits.TUN5                // bit 5

#define NOT_BOR                 PCONbits.NOT_BOR                // bit 0
#define NOT_POR                 PCONbits.NOT_POR                // bit 1
#define NOT_RI                  PCONbits.NOT_RI                 // bit 2
#define NOT_RMCLR               PCONbits.NOT_RMCLR              // bit 3
#define NOT_RWDT                PCONbits.NOT_RWDT               // bit 4
#define STKUNF                  PCONbits.STKUNF                 // bit 6
#define STKOVF                  PCONbits.STKOVF                 // bit 7

#define TMR1IE                  PIE1bits.TMR1IE                 // bit 0
#define TMR2IE                  PIE1bits.TMR2IE                 // bit 1
#define CCP1IE                  PIE1bits.CCP1IE                 // bit 2, shadows bit in PIE1bits
#define CCPIE                   PIE1bits.CCPIE                  // bit 2, shadows bit in PIE1bits
#define SSP1IE                  PIE1bits.SSP1IE                 // bit 3
#define ADIE                    PIE1bits.ADIE                   // bit 6
#define TMR1GIE                 PIE1bits.TMR1GIE                // bit 7

#define CCP2IE                  PIE2bits.CCP2IE                 // bit 0
#define BCL1IE                  PIE2bits.BCL1IE                 // bit 3

#define ZCDIE                   PIE3bits.ZCDIE                  // bit 4

#define TMR1IF                  PIR1bits.TMR1IF                 // bit 0
#define TMR2IF                  PIR1bits.TMR2IF                 // bit 1
#define CCP1IF                  PIR1bits.CCP1IF                 // bit 2, shadows bit in PIR1bits
#define CCPIF                   PIR1bits.CCPIF                  // bit 2, shadows bit in PIR1bits
#define SSP1IF                  PIR1bits.SSP1IF                 // bit 3
#define ADIF                    PIR1bits.ADIF                   // bit 6
#define TMR1GIF                 PIR1bits.TMR1GIF                // bit 7

#define CCP2IF                  PIR2bits.CCP2IF                 // bit 0
#define BCL1IF                  PIR2bits.BCL1IF                 // bit 3

#define ZCDIF                   PIR3bits.ZCDIF                  // bit 4

#define RD                      PMCON1bits.RD                   // bit 0
#define WR                      PMCON1bits.WR                   // bit 1
#define WREN                    PMCON1bits.WREN                 // bit 2
#define WRERR                   PMCON1bits.WRERR                // bit 3
#define FREE                    PMCON1bits.FREE                 // bit 4
#define LWLO                    PMCON1bits.LWLO                 // bit 5
#define CFGS                    PMCON1bits.CFGS                 // bit 6

#define RA0                     PORTAbits.RA0                   // bit 0
#define RA1                     PORTAbits.RA1                   // bit 1
#define RA2                     PORTAbits.RA2                   // bit 2
#define RA3                     PORTAbits.RA3                   // bit 3
#define RA4                     PORTAbits.RA4                   // bit 4
#define RA5                     PORTAbits.RA5                   // bit 5

#define RC0                     PORTCbits.RC0                   // bit 0
#define RC1                     PORTCbits.RC1                   // bit 1
#define RC2                     PORTCbits.RC2                   // bit 2
#define RC3                     PORTCbits.RC3                   // bit 3
#define RC4                     PORTCbits.RC4                   // bit 4
#define RC5                     PORTCbits.RC5                   // bit 5

#define PPSLOCKED               PPSLOCKbits.PPSLOCKED           // bit 0

#define SLRA0                   SLRCONAbits.SLRA0               // bit 0
#define SLRA1                   SLRCONAbits.SLRA1               // bit 1
#define SLRA2                   SLRCONAbits.SLRA2               // bit 2
#define SLRA4                   SLRCONAbits.SLRA4               // bit 4
#define SLRA5                   SLRCONAbits.SLRA5               // bit 5

#define SLRC0                   SLRCONCbits.SLRC0               // bit 0
#define SLRC1                   SLRCONCbits.SLRC1               // bit 1
#define SLRC2                   SLRCONCbits.SLRC2               // bit 2
#define SLRC3                   SLRCONCbits.SLRC3               // bit 3
#define SLRC4                   SLRCONCbits.SLRC4               // bit 4
#define SLRC5                   SLRCONCbits.SLRC5               // bit 5

#define SSP1ADD0                SSP1ADDbits.SSP1ADD0            // bit 0, shadows bit in SSP1ADDbits
#define ADD0                    SSP1ADDbits.ADD0                // bit 0, shadows bit in SSP1ADDbits
#define SSP1ADD1                SSP1ADDbits.SSP1ADD1            // bit 1, shadows bit in SSP1ADDbits
#define ADD1                    SSP1ADDbits.ADD1                // bit 1, shadows bit in SSP1ADDbits
#define SSP1ADD2                SSP1ADDbits.SSP1ADD2            // bit 2, shadows bit in SSP1ADDbits
#define ADD2                    SSP1ADDbits.ADD2                // bit 2, shadows bit in SSP1ADDbits
#define SSP1ADD3                SSP1ADDbits.SSP1ADD3            // bit 3, shadows bit in SSP1ADDbits
#define ADD3                    SSP1ADDbits.ADD3                // bit 3, shadows bit in SSP1ADDbits
#define SSP1ADD4                SSP1ADDbits.SSP1ADD4            // bit 4, shadows bit in SSP1ADDbits
#define ADD4                    SSP1ADDbits.ADD4                // bit 4, shadows bit in SSP1ADDbits
#define SSP1ADD5                SSP1ADDbits.SSP1ADD5            // bit 5, shadows bit in SSP1ADDbits
#define ADD5                    SSP1ADDbits.ADD5                // bit 5, shadows bit in SSP1ADDbits
#define SSP1ADD6                SSP1ADDbits.SSP1ADD6            // bit 6, shadows bit in SSP1ADDbits
#define ADD6                    SSP1ADDbits.ADD6                // bit 6, shadows bit in SSP1ADDbits
#define SSP1ADD7                SSP1ADDbits.SSP1ADD7            // bit 7, shadows bit in SSP1ADDbits
#define ADD7                    SSP1ADDbits.ADD7                // bit 7, shadows bit in SSP1ADDbits

#define SSP1BUF0                SSP1BUFbits.SSP1BUF0            // bit 0, shadows bit in SSP1BUFbits
#define BUF0                    SSP1BUFbits.BUF0                // bit 0, shadows bit in SSP1BUFbits
#define SSP1BUF1                SSP1BUFbits.SSP1BUF1            // bit 1, shadows bit in SSP1BUFbits
#define BUF1                    SSP1BUFbits.BUF1                // bit 1, shadows bit in SSP1BUFbits
#define SSP1BUF2                SSP1BUFbits.SSP1BUF2            // bit 2, shadows bit in SSP1BUFbits
#define BUF2                    SSP1BUFbits.BUF2                // bit 2, shadows bit in SSP1BUFbits
#define SSP1BUF3                SSP1BUFbits.SSP1BUF3            // bit 3, shadows bit in SSP1BUFbits
#define BUF3                    SSP1BUFbits.BUF3                // bit 3, shadows bit in SSP1BUFbits
#define SSP1BUF4                SSP1BUFbits.SSP1BUF4            // bit 4, shadows bit in SSP1BUFbits
#define BUF4                    SSP1BUFbits.BUF4                // bit 4, shadows bit in SSP1BUFbits
#define SSP1BUF5                SSP1BUFbits.SSP1BUF5            // bit 5, shadows bit in SSP1BUFbits
#define BUF5                    SSP1BUFbits.BUF5                // bit 5, shadows bit in SSP1BUFbits
#define SSP1BUF6                SSP1BUFbits.SSP1BUF6            // bit 6, shadows bit in SSP1BUFbits
#define BUF6                    SSP1BUFbits.BUF6                // bit 6, shadows bit in SSP1BUFbits
#define SSP1BUF7                SSP1BUFbits.SSP1BUF7            // bit 7, shadows bit in SSP1BUFbits
#define BUF7                    SSP1BUFbits.BUF7                // bit 7, shadows bit in SSP1BUFbits

#define SSPM0                   SSP1CONbits.SSPM0               // bit 0
#define SSPM1                   SSP1CONbits.SSPM1               // bit 1
#define SSPM2                   SSP1CONbits.SSPM2               // bit 2
#define SSPM3                   SSP1CONbits.SSPM3               // bit 3
#define CKP                     SSP1CONbits.CKP                 // bit 4
#define SSPEN                   SSP1CONbits.SSPEN               // bit 5
#define SSPOV                   SSP1CONbits.SSPOV               // bit 6
#define WCOL                    SSP1CONbits.WCOL                // bit 7

#define SEN                     SSP1CON2bits.SEN                // bit 0
#define RSEN                    SSP1CON2bits.RSEN               // bit 1
#define PEN                     SSP1CON2bits.PEN                // bit 2
#define RCEN                    SSP1CON2bits.RCEN               // bit 3
#define ACKEN                   SSP1CON2bits.ACKEN              // bit 4
#define ACKDT                   SSP1CON2bits.ACKDT              // bit 5
#define ACKSTAT                 SSP1CON2bits.ACKSTAT            // bit 6
#define GCEN                    SSP1CON2bits.GCEN               // bit 7

#define DHEN                    SSP1CON3bits.DHEN               // bit 0
#define AHEN                    SSP1CON3bits.AHEN               // bit 1
#define SBCDE                   SSP1CON3bits.SBCDE              // bit 2
#define SDAHT                   SSP1CON3bits.SDAHT              // bit 3
#define BOEN                    SSP1CON3bits.BOEN               // bit 4
#define SCIE                    SSP1CON3bits.SCIE               // bit 5
#define PCIE                    SSP1CON3bits.PCIE               // bit 6
#define ACKTIM                  SSP1CON3bits.ACKTIM             // bit 7

#define SSP1MSK0                SSP1MSKbits.SSP1MSK0            // bit 0, shadows bit in SSP1MSKbits
#define MSK0                    SSP1MSKbits.MSK0                // bit 0, shadows bit in SSP1MSKbits
#define SSP1MSK1                SSP1MSKbits.SSP1MSK1            // bit 1, shadows bit in SSP1MSKbits
#define MSK1                    SSP1MSKbits.MSK1                // bit 1, shadows bit in SSP1MSKbits
#define SSP1MSK2                SSP1MSKbits.SSP1MSK2            // bit 2, shadows bit in SSP1MSKbits
#define MSK2                    SSP1MSKbits.MSK2                // bit 2, shadows bit in SSP1MSKbits
#define SSP1MSK3                SSP1MSKbits.SSP1MSK3            // bit 3, shadows bit in SSP1MSKbits
#define MSK3                    SSP1MSKbits.MSK3                // bit 3, shadows bit in SSP1MSKbits
#define SSP1MSK4                SSP1MSKbits.SSP1MSK4            // bit 4, shadows bit in SSP1MSKbits
#define MSK4                    SSP1MSKbits.MSK4                // bit 4, shadows bit in SSP1MSKbits
#define SSP1MSK5                SSP1MSKbits.SSP1MSK5            // bit 5, shadows bit in SSP1MSKbits
#define MSK5                    SSP1MSKbits.MSK5                // bit 5, shadows bit in SSP1MSKbits
#define SSP1MSK6                SSP1MSKbits.SSP1MSK6            // bit 6, shadows bit in SSP1MSKbits
#define MSK6                    SSP1MSKbits.MSK6                // bit 6, shadows bit in SSP1MSKbits
#define SSP1MSK7                SSP1MSKbits.SSP1MSK7            // bit 7, shadows bit in SSP1MSKbits
#define MSK7                    SSP1MSKbits.MSK7                // bit 7, shadows bit in SSP1MSKbits

#define BF                      SSP1STATbits.BF                 // bit 0
#define UA                      SSP1STATbits.UA                 // bit 1
#define R_NOT_W                 SSP1STATbits.R_NOT_W            // bit 2
#define S                       SSP1STATbits.S                  // bit 3
#define P                       SSP1STATbits.P                  // bit 4
#define D_NOT_A                 SSP1STATbits.D_NOT_A            // bit 5
#define CKE                     SSP1STATbits.CKE                // bit 6
#define SMP                     SSP1STATbits.SMP                // bit 7

#define C                       STATUSbits.C                    // bit 0
#define DC                      STATUSbits.DC                   // bit 1
#define Z                       STATUSbits.Z                    // bit 2
#define NOT_PD                  STATUSbits.NOT_PD               // bit 3
#define NOT_TO                  STATUSbits.NOT_TO               // bit 4

#define C_SHAD                  STATUS_SHADbits.C_SHAD          // bit 0
#define DC_SHAD                 STATUS_SHADbits.DC_SHAD         // bit 1
#define Z_SHAD                  STATUS_SHADbits.Z_SHAD          // bit 2

#define TMR1ON                  T1CONbits.TMR1ON                // bit 0
#define NOT_T1SYNC              T1CONbits.NOT_T1SYNC            // bit 2
#define T1OSCEN                 T1CONbits.T1OSCEN               // bit 3
#define T1CKPS0                 T1CONbits.T1CKPS0               // bit 4
#define T1CKPS1                 T1CONbits.T1CKPS1               // bit 5
#define TMR1CS0                 T1CONbits.TMR1CS0               // bit 6
#define TMR1CS1                 T1CONbits.TMR1CS1               // bit 7

#define T1GSS0                  T1GCONbits.T1GSS0               // bit 0
#define T1GSS1                  T1GCONbits.T1GSS1               // bit 1
#define T1GVAL                  T1GCONbits.T1GVAL               // bit 2
#define T1GGO_NOT_DONE          T1GCONbits.T1GGO_NOT_DONE       // bit 3
#define T1GSPM                  T1GCONbits.T1GSPM               // bit 4
#define T1GTM                   T1GCONbits.T1GTM                // bit 5
#define T1GPOL                  T1GCONbits.T1GPOL               // bit 6
#define TMR1GE                  T1GCONbits.TMR1GE               // bit 7

#define T2CKPS0                 T2CONbits.T2CKPS0               // bit 0
#define T2CKPS1                 T2CONbits.T2CKPS1               // bit 1
#define TMR2ON                  T2CONbits.TMR2ON                // bit 2
#define T2OUTPS0                T2CONbits.T2OUTPS0              // bit 3
#define T2OUTPS1                T2CONbits.T2OUTPS1              // bit 4
#define T2OUTPS2                T2CONbits.T2OUTPS2              // bit 5
#define T2OUTPS3                T2CONbits.T2OUTPS3              // bit 6

#define TRISA0                  TRISAbits.TRISA0                // bit 0
#define TRISA1                  TRISAbits.TRISA1                // bit 1
#define TRISA2                  TRISAbits.TRISA2                // bit 2
#define TRISA4                  TRISAbits.TRISA4                // bit 4
#define TRISA5                  TRISAbits.TRISA5                // bit 5

#define TRISC0                  TRISCbits.TRISC0                // bit 0
#define TRISC1                  TRISCbits.TRISC1                // bit 1
#define TRISC2                  TRISCbits.TRISC2                // bit 2
#define TRISC3                  TRISCbits.TRISC3                // bit 3
#define TRISC4                  TRISCbits.TRISC4                // bit 4
#define TRISC5                  TRISCbits.TRISC5                // bit 5

#define SWDTEN                  WDTCONbits.SWDTEN               // bit 0
#define WDTPS0                  WDTCONbits.WDTPS0               // bit 1
#define WDTPS1                  WDTCONbits.WDTPS1               // bit 2
#define WDTPS2                  WDTCONbits.WDTPS2               // bit 3
#define WDTPS3                  WDTCONbits.WDTPS3               // bit 4
#define WDTPS4                  WDTCONbits.WDTPS4               // bit 5

#define WPUA0                   WPUAbits.WPUA0                  // bit 0
#define WPUA1                   WPUAbits.WPUA1                  // bit 1
#define WPUA2                   WPUAbits.WPUA2                  // bit 2
#define WPUA3                   WPUAbits.WPUA3                  // bit 3
#define WPUA4                   WPUAbits.WPUA4                  // bit 4
#define WPUA5                   WPUAbits.WPUA5                  // bit 5

#define WPUC0                   WPUCbits.WPUC0                  // bit 0
#define WPUC1                   WPUCbits.WPUC1                  // bit 1
#define WPUC2                   WPUCbits.WPUC2                  // bit 2
#define WPUC3                   WPUCbits.WPUC3                  // bit 3
#define WPUC4                   WPUCbits.WPUC4                  // bit 4
#define WPUC5                   WPUCbits.WPUC5                  // bit 5

#define ZCD1INTN                ZCD1CONbits.ZCD1INTN            // bit 0
#define ZCD1INTP                ZCD1CONbits.ZCD1INTP            // bit 1
#define ZCD1POL                 ZCD1CONbits.ZCD1POL             // bit 4
#define ZCD1OUT                 ZCD1CONbits.ZCD1OUT             // bit 5
#define ZCD1EN                  ZCD1CONbits.ZCD1EN              // bit 7

#endif // #ifndef NO_BIT_DEFINES

#endif // #ifndef __PIC16LF1703_H__
