/**
A WebRTC connection between the local computer and a remote peer. It provides methods to connect to a remote peer, maintain and monitor the connection, and close the connection once it's no longer needed.

@returns {RTCPeerConnection}
*/
RTCPeerConnection = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Boolean | null)} boolean | null
**/
RTCPeerConnection.prototype.canTrickleIceCandidates = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {("closed" | "connected" | "connecting" | "disconnected" | "failed" | "new")} RTCPeerConnectionState
**/
RTCPeerConnection.prototype.connectionState = new Object();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(RTCSessionDescription | null)} RTCSessionDescription | null
**/
RTCPeerConnection.prototype.currentLocalDescription = new RTCSessionDescription();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(RTCSessionDescription | null)} RTCSessionDescription | null
**/
RTCPeerConnection.prototype.currentRemoteDescription = new RTCSessionDescription();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {("checking" | "closed" | "completed" | "connected" | "disconnected" | "failed" | "new")} RTCIceConnectionState
**/
RTCPeerConnection.prototype.iceConnectionState = new Object();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {("complete" | "gathering" | "new")} RTCIceGatheringState
**/
RTCPeerConnection.prototype.iceGatheringState = new Object();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(RTCSessionDescription | null)} RTCSessionDescription | null
**/
RTCPeerConnection.prototype.localDescription = new RTCSessionDescription();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: RTCPeerConnection, ev: Event) => any) | null
**/
RTCPeerConnection.prototype.onconnectionstatechange = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: RTCPeerConnection, ev: RTCDataChannelEvent) => any) | null
**/
RTCPeerConnection.prototype.ondatachannel = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: RTCPeerConnection, ev: RTCPeerConnectionIceEvent) => any) | null
**/
RTCPeerConnection.prototype.onicecandidate = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: RTCPeerConnection, ev: Event) => any) | null
**/
RTCPeerConnection.prototype.onicecandidateerror = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: RTCPeerConnection, ev: Event) => any) | null
**/
RTCPeerConnection.prototype.oniceconnectionstatechange = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: RTCPeerConnection, ev: Event) => any) | null
**/
RTCPeerConnection.prototype.onicegatheringstatechange = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: RTCPeerConnection, ev: Event) => any) | null
**/
RTCPeerConnection.prototype.onnegotiationneeded = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: RTCPeerConnection, ev: Event) => any) | null
**/
RTCPeerConnection.prototype.onsignalingstatechange = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Function | null)} ((this: RTCPeerConnection, ev: RTCTrackEvent) => any) | null
**/
RTCPeerConnection.prototype.ontrack = new Function();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(RTCSessionDescription | null)} RTCSessionDescription | null
**/
RTCPeerConnection.prototype.pendingLocalDescription = new RTCSessionDescription();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(RTCSessionDescription | null)} RTCSessionDescription | null
**/
RTCPeerConnection.prototype.pendingRemoteDescription = new RTCSessionDescription();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(RTCSessionDescription | null)} RTCSessionDescription | null
**/
RTCPeerConnection.prototype.remoteDescription = new RTCSessionDescription();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {("closed" | "have-local-offer" | "have-local-pranswer" | "have-remote-offer" | "have-remote-pranswer" | "stable")} RTCSignalingState
**/
RTCPeerConnection.prototype.signalingState = new Object();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {RTCIceCandidateInit} candidate RTCIceCandidateInit
@param {VoidFunction} successCallback VoidFunction
@param {RTCPeerConnectionErrorCallback} failureCallback RTCPeerConnectionErrorCallback
@returns {Promise}
**/
RTCPeerConnection.prototype.addIceCandidate = function(candidate, successCallback, failureCallback) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {MediaStreamTrack} track MediaStreamTrack
@param {MediaStream[]} streams MediaStream[]
@returns {RTCRtpSender}
**/
RTCPeerConnection.prototype.addTrack = function(track, streams) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(MediaStreamTrack | String)} trackOrKind MediaStreamTrack | string
@param {RTCRtpTransceiverInit} [init] RTCRtpTransceiverInit
@returns {RTCRtpTransceiver}
**/
RTCPeerConnection.prototype.addTransceiver = function(trackOrKind) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {undefined}
**/
RTCPeerConnection.prototype.close = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {RTCSessionDescriptionCallback} successCallback RTCSessionDescriptionCallback
@param {RTCPeerConnectionErrorCallback} failureCallback RTCPeerConnectionErrorCallback
@returns {Promise}
**/
RTCPeerConnection.prototype.createAnswer = function(successCallback, failureCallback) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {String} label
@param {RTCDataChannelInit} [dataChannelDict] RTCDataChannelInit
@returns {RTCDataChannel}
**/
RTCPeerConnection.prototype.createDataChannel = function(label) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {RTCSessionDescriptionCallback} successCallback RTCSessionDescriptionCallback
@param {RTCPeerConnectionErrorCallback} failureCallback RTCPeerConnectionErrorCallback
@param {RTCOfferOptions} [options] RTCOfferOptions
@returns {Promise}
**/
RTCPeerConnection.prototype.createOffer = function(successCallback, failureCallback) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {RTCConfiguration}
**/
RTCPeerConnection.prototype.getConfiguration = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {RTCRtpReceiver[]}
**/
RTCPeerConnection.prototype.getReceivers = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {RTCRtpSender[]}
**/
RTCPeerConnection.prototype.getSenders = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {(MediaStreamTrack | null)} [selector] MediaStreamTrack | null
@returns {Promise}
**/
RTCPeerConnection.prototype.getStats = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {RTCRtpTransceiver[]}
**/
RTCPeerConnection.prototype.getTransceivers = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {RTCRtpSender} sender RTCRtpSender
@returns {undefined}
**/
RTCPeerConnection.prototype.removeTrack = function(sender) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {undefined}
**/
RTCPeerConnection.prototype.restartIce = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {RTCConfiguration} [configuration] RTCConfiguration
@returns {undefined}
**/
RTCPeerConnection.prototype.setConfiguration = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {RTCLocalSessionDescriptionInit} description RTCLocalSessionDescriptionInit
@param {VoidFunction} successCallback VoidFunction
@param {RTCPeerConnectionErrorCallback} failureCallback RTCPeerConnectionErrorCallback
@returns {Promise}
**/
RTCPeerConnection.prototype.setLocalDescription = function(description, successCallback, failureCallback) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@param {RTCSessionDescriptionInit} description RTCSessionDescriptionInit
@param {VoidFunction} successCallback VoidFunction
@param {RTCPeerConnectionErrorCallback} failureCallback RTCPeerConnectionErrorCallback
@returns {Promise}
**/
RTCPeerConnection.prototype.setRemoteDescription = function(description, successCallback, failureCallback) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Appends an event listener for events whose type attribute value is type. The callback argument sets the callback that will be invoked when the event is dispatched.

The options argument sets listener-specific options. For compatibility this can be a boolean, in which case the method behaves exactly as if the value was specified as options's capture.

When set to true, options's capture prevents callback from being invoked when the event's eventPhase attribute value is BUBBLING_PHASE. When false (or not present), callback will not be invoked when event's eventPhase attribute value is CAPTURING_PHASE. Either way, callback will be invoked if event's eventPhase attribute value is AT_TARGET.

When set to true, options's passive indicates that the callback will not cancel the event by invoking preventDefault(). This is used to enable performance optimizations described in § 2.8 Observing event listeners.

When set to true, options's once indicates that the callback will only be invoked once after which the event listener will be removed.

If an AbortSignal is passed for options's signal, then the event listener will be removed when signal is aborted.

The event listener is appended to target's event listener list and is not appended if it has the same type, callback, and capture.

@param {String} type
@param {(EventListener | EventListenerObject)} listener EventListenerOrEventListenerObject
@param {(Boolean | AddEventListenerOptions)} [options] boolean | AddEventListenerOptions
@returns {undefined}
**/
RTCPeerConnection.prototype.addEventListener = function(type, listener) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Removes the event listener in target's event listener list with the same type, callback, and options.

@param {String} type
@param {(EventListener | EventListenerObject)} listener EventListenerOrEventListenerObject
@param {(Boolean | EventListenerOptions)} [options] boolean | EventListenerOptions
@returns {undefined}
**/
RTCPeerConnection.prototype.removeEventListener = function(type, listener) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Appends an event listener for events whose type attribute value is type. The callback argument sets the callback that will be invoked when the event is dispatched.

The options argument sets listener-specific options. For compatibility this can be a boolean, in which case the method behaves exactly as if the value was specified as options's capture.

When set to true, options's capture prevents callback from being invoked when the event's eventPhase attribute value is BUBBLING_PHASE. When false (or not present), callback will not be invoked when event's eventPhase attribute value is CAPTURING_PHASE. Either way, callback will be invoked if event's eventPhase attribute value is AT_TARGET.

When set to true, options's passive indicates that the callback will not cancel the event by invoking preventDefault(). This is used to enable performance optimizations described in § 2.8 Observing event listeners.

When set to true, options's once indicates that the callback will only be invoked once after which the event listener will be removed.

If an AbortSignal is passed for options's signal, then the event listener will be removed when signal is aborted.

The event listener is appended to target's event listener list and is not appended if it has the same type, callback, and capture.

@param {String} type
@param {(EventListener | EventListenerObject | null)} callback EventListenerOrEventListenerObject | null
@param {(AddEventListenerOptions | Boolean)} [options] AddEventListenerOptions | boolean
@returns {undefined}
**/
RTCPeerConnection.prototype.addEventListener = function(type, callback) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Dispatches a synthetic event event to target and returns true if either event's cancelable attribute value is false or its preventDefault() method was not invoked, and false otherwise.

@param {Event} event Event
@returns {Boolean}
**/
RTCPeerConnection.prototype.dispatchEvent = function(event) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Removes the event listener in target's event listener list with the same type, callback, and options.

@param {String} type
@param {(EventListener | EventListenerObject | null)} callback EventListenerOrEventListenerObject | null
@param {(EventListenerOptions | Boolean)} [options] EventListenerOptions | boolean
@returns {undefined}
**/
RTCPeerConnection.prototype.removeEventListener = function(type, callback) {};

