/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.model;

import org.netbeans.modules.websvc.jaxwsmodelapi.WSOperation;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSPort;
import org.netbeans.modules.websvc.jaxwsmodelapi.java.JavaMethod;
import org.netbeans.modules.websvc.saas.model.SaasMethod;
import org.netbeans.modules.websvc.saas.model.WsdlSaas;
import org.netbeans.modules.websvc.saas.model.WsdlSaasPort;
import org.netbeans.modules.websvc.saas.model.jaxb.Method;

public class WsdlSaasMethod
extends SaasMethod {
    WsdlSaasPort parent;
    WSPort port;
    WSOperation operation;

    public WsdlSaasMethod(WsdlSaas saas, Method method) {
        super(saas, method);
    }

    public WsdlSaasMethod(WsdlSaasPort port, WSOperation operation) {
        super(port.getParentSaas(), null);
        this.parent = port;
        this.port = port.getWsdlPort();
        this.operation = operation;
    }

    @Override
    public String getName() {
        if (this.getMethod() != null) {
            return this.getMethod().getName();
        }
        assert (this.operation != null) : "Should have non-null operation when filter method does not exist";
        return this.operation.getName();
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public WsdlSaas getSaas() {
        return (WsdlSaas)super.getSaas();
    }

    public WSOperation getWsdlOperation() {
        this.init();
        return this.operation;
    }

    public WSPort getWsdlPort() {
        this.init();
        return this.port;
    }

    public JavaMethod getJavaMethod() {
        return this.getWsdlOperation().getJavaMethod();
    }

    private void init() {
        if (this.port == null || this.operation == null) {
            assert (this.getMethod() != null) : "Should have non-null filter method";
            for (WSPort p : this.getSaas().getWsdlModel().getPorts()) {
                if (!p.getName().equals(this.getMethod().getPortName())) continue;
                this.port = p;
                for (WSOperation op : this.port.getOperations()) {
                    if (!op.getName().equals(this.getMethod().getOperationName())) continue;
                    this.operation = op;
                    return;
                }
            }
        }
    }
}

