/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter;

public class SVNScheduleKind {
    private int kind;
    private static final int normal = 0;
    private static final int add = 1;
    private static final int delete = 2;
    private static final int replace = 3;
    public static final SVNScheduleKind NORMAL = new SVNScheduleKind(0);
    public static final SVNScheduleKind ADD = new SVNScheduleKind(1);
    public static final SVNScheduleKind DELETE = new SVNScheduleKind(2);
    public static final SVNScheduleKind REPLACE = new SVNScheduleKind(3);

    private SVNScheduleKind(int kind) {
        this.kind = kind;
    }

    public int toInt() {
        return this.kind;
    }

    public SVNScheduleKind fromInt(int scheduleKind) {
        switch (scheduleKind) {
            case 0: {
                return NORMAL;
            }
            case 1: {
                return ADD;
            }
            case 2: {
                return DELETE;
            }
            case 3: {
                return REPLACE;
            }
        }
        return null;
    }

    public static SVNScheduleKind fromString(String scheduleKind) {
        if (NORMAL.toString().equals(scheduleKind)) {
            return NORMAL;
        }
        if (ADD.toString().equals(scheduleKind)) {
            return ADD;
        }
        if (DELETE.toString().equals(scheduleKind)) {
            return DELETE;
        }
        if (REPLACE.toString().equals(scheduleKind)) {
            return REPLACE;
        }
        return null;
    }

    public String toString() {
        switch (this.kind) {
            case 0: {
                return "normal";
            }
            case 1: {
                return "add";
            }
            case 2: {
                return "delete";
            }
            case 3: {
                return "replace";
            }
        }
        return "";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SVNScheduleKind)) {
            return false;
        }
        return ((SVNScheduleKind)obj).kind == this.kind;
    }

    public int hashCode() {
        return new Integer(this.kind).hashCode();
    }
}

