/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly.nodes;

import java.awt.Image;
import java.util.Collection;
import javax.swing.Action;
import org.netbeans.modules.javaee.wildfly.nodes.actions.OpenURLAction;
import org.netbeans.modules.javaee.wildfly.nodes.actions.OpenURLActionCookie;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.SystemAction;

public class WildflyJaxrsResourceMethodsChildren
extends Children.Keys {
    private final String serverUrl;

    public WildflyJaxrsResourceMethodsChildren(String serverUrl, Collection methods) {
        super(false);
        this.serverUrl = serverUrl;
        this.setKeys(methods);
    }

    protected Node[] createNodes(Object key) {
        return new Node[]{new JaxrsResourceMethodNode(key.toString(), this.serverUrl)};
    }

    private static class JaxrsResourceMethodNode
    extends AbstractNode {
        private final String url;

        public JaxrsResourceMethodNode(String jaxrsMethod, String serverUrl) {
            super(Children.LEAF);
            this.setDisplayName(jaxrsMethod);
            this.setName(jaxrsMethod);
            this.setShortDescription(jaxrsMethod);
            int baseIndex = jaxrsMethod.indexOf(32);
            String removedMethod = jaxrsMethod.substring(baseIndex + 1);
            this.url = serverUrl + removedMethod.substring(0, removedMethod.indexOf(32));
            if (this.url != null) {
                this.getCookieSet().add((Node.Cookie)new OpenURLActionCookieImpl(this.url));
            }
        }

        public Action[] getActions(boolean context) {
            if (this.url != null) {
                return new SystemAction[]{SystemAction.get(OpenURLAction.class)};
            }
            return new SystemAction[0];
        }

        public Image getIcon(int type) {
            return ImageUtilities.loadImage((String)"org/netbeans/modules/javaee/wildfly/resources/method.png");
        }

        public Image getOpenedIcon(int type) {
            return ImageUtilities.loadImage((String)"org/netbeans/modules/javaee/wildfly/resources/method.png");
        }

        private static class OpenURLActionCookieImpl
        implements OpenURLActionCookie {
            private final String url;

            public OpenURLActionCookieImpl(String url) {
                this.url = url;
            }

            @Override
            public String getWebURL() {
                return this.url;
            }
        }
    }
}

