/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly.ide.ui;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceCreationException;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.javaee.wildfly.ide.ui.AddServerLocationPanel;
import org.netbeans.modules.javaee.wildfly.ide.ui.AddServerPropertiesPanel;
import org.netbeans.modules.javaee.wildfly.ide.ui.AddServerPropertiesVisualPanel;
import org.netbeans.modules.javaee.wildfly.ide.ui.WildflyPluginUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

public class WildflyInstantiatingIterator
implements WizardDescriptor.InstantiatingIterator,
ChangeListener {
    private static final String PROP_DISPLAY_NAME = "ServInstWizard_displayName";
    private static final String WILDFLY_JAVA_OPTS = "-Xms128m -Xmx512m";
    public final boolean skipServerLocationStep = false;
    private transient AddServerLocationPanel locationPanel = null;
    private transient AddServerPropertiesPanel propertiesPanel = null;
    private WizardDescriptor wizard;
    private transient int index = 0;
    private transient WizardDescriptor.Panel[] panels = null;
    private final transient Set listeners = new HashSet(1);
    private transient String[] steps = null;
    private String host;
    private String port;
    private String adminPort;
    private String portOffset;
    private String userName = "";
    private String password = "";
    private String server;
    private String installLocation;
    private String deployDir;
    private String serverPath;
    private String configFile = "standalone-full.xml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    public void uninitialize(WizardDescriptor wizard) {
    }

    public void initialize(WizardDescriptor wizard) {
        this.wizard = wizard;
    }

    public void previousPanel() {
        --this.index;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public String name() {
        return "JBoss Server AddInstanceIterator";
    }

    public static void showInformation(final String msg, final String title) {
        Runnable info = new Runnable(){

            @Override
            public void run() {
                NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)msg, 1);
                d.setTitle(title);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            info.run();
        } else {
            SwingUtilities.invokeLater(info);
        }
    }

    public Set instantiate() throws IOException {
        HashSet<InstanceProperties> result = new HashSet<InstanceProperties>();
        String displayName = (String)this.wizard.getProperty(PROP_DISPLAY_NAME);
        WildflyPluginUtils.Version version = WildflyPluginUtils.getServerVersion(new File(this.installLocation));
        String url = "wildfly-deployer:";
        url = version != null && "7".equals(version.getMajorNumber()) ? url + "//" + this.host + ":" + this.port + "?targetType=as7" : url + this.host + ":" + this.port;
        if (this.server != null && !this.server.equals("")) {
            url = url + "#" + this.server;
        }
        url = url + "&" + this.installLocation;
        try {
            HashMap<String, String> initialProperties = new HashMap<String, String>();
            initialProperties.put("server", this.server);
            initialProperties.put("deploy-dir", this.deployDir);
            initialProperties.put("server-dir", this.serverPath);
            initialProperties.put("root-dir", this.installLocation);
            initialProperties.put("host", this.host);
            initialProperties.put("port", this.port);
            initialProperties.put("port-offset", this.portOffset);
            initialProperties.put("config_file", this.configFile);
            initialProperties.put("admin-port", this.adminPort);
            initialProperties.put("java_opts", WILDFLY_JAVA_OPTS);
            InstanceProperties ip = InstanceProperties.createInstanceProperties((String)url, (String)this.userName, (String)this.password, (String)displayName, initialProperties);
            result.add(ip);
        }
        catch (InstanceCreationException e) {
            WildflyInstantiatingIterator.showInformation(e.getLocalizedMessage(), NbBundle.getMessage(AddServerPropertiesVisualPanel.class, (String)"MSG_INSTANCE_REGISTRATION_FAILED"));
            Logger.getLogger("global").log(Level.SEVERE, e.getMessage());
        }
        return result;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    protected String[] createSteps() {
        return new String[]{NbBundle.getMessage(WildflyInstantiatingIterator.class, (String)"STEP_ServerLocation"), NbBundle.getMessage(WildflyInstantiatingIterator.class, (String)"STEP_Properties")};
    }

    protected final String[] getSteps() {
        if (this.steps == null) {
            this.steps = this.createSteps();
        }
        return this.steps;
    }

    protected final WizardDescriptor.Panel[] getPanels() {
        if (this.panels == null) {
            this.panels = this.createPanels();
        }
        return this.panels;
    }

    protected WizardDescriptor.Panel[] createPanels() {
        if (this.locationPanel == null) {
            this.locationPanel = new AddServerLocationPanel(this);
            this.locationPanel.addChangeListener(this);
        }
        if (this.propertiesPanel == null) {
            this.propertiesPanel = new AddServerPropertiesPanel(this);
            this.propertiesPanel.addChangeListener(this);
        }
        return new WizardDescriptor.Panel[]{this.locationPanel, this.propertiesPanel};
    }

    protected final int getIndex() {
        return this.index;
    }

    public WizardDescriptor.Panel current() {
        WizardDescriptor.Panel result = this.getPanels()[this.index];
        JComponent component = (JComponent)result.getComponent();
        component.putClientProperty("WizardPanel_contentData", this.getSteps());
        component.putClientProperty("WizardPanel_contentSelectedIndex", this.getIndex());
        return result;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.fireChangeEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator it;
        Set set = this.listeners;
        synchronized (set) {
            it = new HashSet(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            ((ChangeListener)it.next()).stateChanged(ev);
        }
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile.trim();
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setHost(String host) {
        this.host = host.trim();
    }

    public void setPort(String port) {
        this.port = port.trim();
    }

    public void setAdminPort(String port) {
        this.adminPort = port.trim();
    }

    public void setPortOffset(String portOffset) {
        this.portOffset = portOffset;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public void setServerPath(String serverPath) {
        this.serverPath = serverPath;
    }

    public void setDeployDir(String deployDir) {
        this.deployDir = deployDir;
    }

    public void setInstallLocation(String installLocation) {
        this.installLocation = installLocation;
        this.propertiesPanel.installLocationChanged();
    }
}

