/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.client.match;

import java.io.IOException;
import java.text.ParseException;
import org.hamcrest.Matcher;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.mock.http.client.MockClientHttpRequest;
import org.springframework.test.util.JsonPathExpectationsHelper;
import org.springframework.test.web.client.RequestMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonPathRequestMatchers {
    private JsonPathExpectationsHelper jsonPathHelper;

    protected JsonPathRequestMatchers(String expression, Object ... args) {
        this.jsonPathHelper = new JsonPathExpectationsHelper(expression, args);
    }

    public <T> RequestMatcher value(final Matcher<T> matcher) {
        return new AbstractJsonPathRequestMatcher(){

            protected void matchInternal(MockClientHttpRequest request) throws IOException, ParseException {
                JsonPathRequestMatchers.this.jsonPathHelper.assertValue(request.getBodyAsString(), matcher);
            }
        };
    }

    public RequestMatcher value(final Object expectedValue) {
        return new AbstractJsonPathRequestMatcher(){

            protected void matchInternal(MockClientHttpRequest request) throws IOException, ParseException {
                JsonPathRequestMatchers.this.jsonPathHelper.assertValue(request.getBodyAsString(), expectedValue);
            }
        };
    }

    public RequestMatcher exists() {
        return new AbstractJsonPathRequestMatcher(){

            protected void matchInternal(MockClientHttpRequest request) throws IOException, ParseException {
                JsonPathRequestMatchers.this.jsonPathHelper.exists(request.getBodyAsString());
            }
        };
    }

    public RequestMatcher doesNotExist() {
        return new AbstractJsonPathRequestMatcher(){

            protected void matchInternal(MockClientHttpRequest request) throws IOException, ParseException {
                JsonPathRequestMatchers.this.jsonPathHelper.doesNotExist(request.getBodyAsString());
            }
        };
    }

    public RequestMatcher isArray() {
        return new AbstractJsonPathRequestMatcher(){

            protected void matchInternal(MockClientHttpRequest request) throws IOException, ParseException {
                JsonPathRequestMatchers.this.jsonPathHelper.assertValueIsArray(request.getBodyAsString());
            }
        };
    }

    private static abstract class AbstractJsonPathRequestMatcher
    implements RequestMatcher {
        private AbstractJsonPathRequestMatcher() {
        }

        public final void match(ClientHttpRequest request) throws IOException, AssertionError {
            try {
                MockClientHttpRequest mockRequest = (MockClientHttpRequest)request;
                this.matchInternal(mockRequest);
            }
            catch (ParseException ex) {
                throw new AssertionError((Object)("Failed to parse JSON request content: " + ex.getMessage()));
            }
        }

        protected abstract void matchInternal(MockClientHttpRequest var1) throws IOException, ParseException;
    }
}

