/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.ContextCache;
import org.springframework.test.context.ContextLoader;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.SmartContextLoader;
import org.springframework.util.Assert;

public class CacheAwareContextLoaderDelegate {
    private static final Log logger = LogFactory.getLog(CacheAwareContextLoaderDelegate.class);
    private static final Log statsLogger = LogFactory.getLog((String)"org.springframework.test.context.cache");
    private final ContextCache contextCache;

    CacheAwareContextLoaderDelegate(ContextCache contextCache) {
        Assert.notNull((Object)contextCache, (String)"ContextCache must not be null");
        this.contextCache = contextCache;
    }

    private ApplicationContext loadContextInternal(MergedContextConfiguration mergedContextConfiguration) throws Exception {
        ApplicationContext applicationContext;
        ContextLoader contextLoader = mergedContextConfiguration.getContextLoader();
        Assert.notNull((Object)contextLoader, (String)"Cannot load an ApplicationContext with a NULL 'contextLoader'. Consider annotating your test class with @ContextConfiguration or @ContextHierarchy.");
        if (contextLoader instanceof SmartContextLoader) {
            SmartContextLoader smartContextLoader = (SmartContextLoader)contextLoader;
            applicationContext = smartContextLoader.loadContext(mergedContextConfiguration);
        } else {
            String[] locations = mergedContextConfiguration.getLocations();
            Assert.notNull((Object)locations, (String)"Cannot load an ApplicationContext with a NULL 'locations' array. Consider annotating your test class with @ContextConfiguration or @ContextHierarchy.");
            applicationContext = contextLoader.loadContext(locations);
        }
        return applicationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationContext loadContext(MergedContextConfiguration mergedContextConfiguration) {
        ContextCache contextCache = this.contextCache;
        synchronized (contextCache) {
            ApplicationContext context = this.contextCache.get(mergedContextConfiguration);
            if (context == null) {
                try {
                    context = this.loadContextInternal(mergedContextConfiguration);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)String.format("Storing ApplicationContext in cache under key [%s]", mergedContextConfiguration));
                    }
                    this.contextCache.put(mergedContextConfiguration, context);
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Failed to load ApplicationContext", ex);
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Retrieved ApplicationContext from cache with key [%s]", mergedContextConfiguration));
            }
            if (statsLogger.isDebugEnabled()) {
                statsLogger.debug((Object)("Spring test ApplicationContext cache statistics: " + this.contextCache));
            }
            return context;
        }
    }
}

