/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.ui.nodes;

import java.util.Comparator;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.modules.tomcat5.deploy.TomcatManager;
import org.netbeans.modules.tomcat5.deploy.TomcatModule;
import org.netbeans.modules.tomcat5.ui.nodes.TomcatWebModuleNode;
import org.netbeans.modules.tomcat5.ui.nodes.actions.TomcatWebModuleCookie;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;

public class TomcatWebModule
implements TomcatWebModuleCookie {
    private static RequestProcessor rp;
    public static final Comparator<TomcatWebModule> TOMCAT_WEB_MODULE_COMPARATOR;
    private final TomcatModule tomcatModule;
    private final TomcatManager manager;
    private volatile boolean isRunning;
    private Node node;
    private final TargetModuleID[] target;

    private static synchronized RequestProcessor rp() {
        if (rp == null) {
            rp = new RequestProcessor("Tomcat web module", 1);
        }
        return rp;
    }

    public TomcatWebModule(DeploymentManager manager, TomcatModule tomcatModule, boolean isRunning) {
        this.tomcatModule = tomcatModule;
        this.manager = (TomcatManager)manager;
        this.isRunning = isRunning;
        this.target = new TargetModuleID[]{tomcatModule};
    }

    public TomcatModule getTomcatModule() {
        return this.tomcatModule;
    }

    public void setRepresentedNode(Node node) {
        this.node = node;
    }

    public Node getRepresentedNode() {
        return this.node;
    }

    public DeploymentManager getDeploymentManager() {
        return this.manager;
    }

    @Override
    public RequestProcessor.Task undeploy() {
        return TomcatWebModule.rp().post(() -> {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(TomcatWebModule.class, (String)"MSG_START_UNDEPLOY", (Object[])new Object[]{this.getTomcatModule().getPath()}));
            ProgressObject po = this.manager.undeploy(this.target);
            TomcatProgressListener listener = new TomcatProgressListener(po);
            po.addProgressListener((ProgressListener)listener);
            listener.updateState();
            CompletionWait wait = new CompletionWait(po);
            wait.init();
            wait.waitFinished();
        }, 0);
    }

    @Override
    public void start() {
        TomcatWebModule.rp().post(() -> {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(TomcatWebModule.class, (String)"MSG_START_STARTING", (Object[])new Object[]{this.getTomcatModule().getPath()}));
            ProgressObject po = this.manager.start(this.target);
            TomcatProgressListener listener = new TomcatProgressListener(po);
            po.addProgressListener((ProgressListener)listener);
            listener.updateState();
        }, 0);
    }

    @Override
    public void stop() {
        TomcatWebModule.rp().post(() -> {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(TomcatWebModule.class, (String)"MSG_START_STOPPING", (Object[])new Object[]{this.getTomcatModule().getPath()}));
            ProgressObject po = this.manager.stop(this.target);
            TomcatProgressListener listener = new TomcatProgressListener(po);
            po.addProgressListener((ProgressListener)listener);
            listener.updateState();
        }, 0);
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    private String constructDisplayName() {
        if (this.isRunning()) {
            return this.getTomcatModule().getPath();
        }
        return this.getTomcatModule().getPath() + " [" + NbBundle.getMessage(TomcatWebModuleNode.class, (String)"LBL_Stopped") + "]";
    }

    @Override
    public void openLog() {
        this.manager.logManager().openContextLog(this.tomcatModule);
    }

    @Override
    public boolean hasLogger() {
        return this.manager.logManager().hasContextLogger(this.tomcatModule);
    }

    static {
        TOMCAT_WEB_MODULE_COMPARATOR = (wm1, wm2) -> wm1.getTomcatModule().getModuleID().compareTo(wm2.getTomcatModule().getModuleID());
    }

    private static class CompletionWait
    implements ProgressListener {
        private final ProgressObject progressObject;
        private boolean completed;

        public CompletionWait(ProgressObject progressObject) {
            Parameters.notNull((CharSequence)"progressObject", (Object)progressObject);
            this.progressObject = progressObject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void init() {
            CompletionWait completionWait = this;
            synchronized (completionWait) {
                this.progressObject.addProgressListener((ProgressListener)this);
                this.handleProgressEvent(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleProgressEvent(ProgressEvent evt) {
            CompletionWait completionWait = this;
            synchronized (completionWait) {
                DeploymentStatus status = this.progressObject.getDeploymentStatus();
                if (status.isCompleted() || status.isFailed()) {
                    this.completed = true;
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitFinished() {
            CompletionWait completionWait = this;
            synchronized (completionWait) {
                if (this.completed) {
                    return;
                }
                while (!this.completed) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    private class TomcatProgressListener
    implements ProgressListener {
        private final ProgressObject progressObject;
        private boolean finished;

        public TomcatProgressListener(ProgressObject progressObject) {
            this.progressObject = progressObject;
        }

        public void handleProgressEvent(ProgressEvent progressEvent) {
            this.updateState();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateState() {
            DeploymentStatus deployStatus = this.progressObject.getDeploymentStatus();
            TomcatProgressListener tomcatProgressListener = this;
            synchronized (tomcatProgressListener) {
                if (this.finished || deployStatus == null) {
                    return;
                }
                if (deployStatus.isCompleted() || deployStatus.isFailed()) {
                    this.finished = true;
                }
                if (deployStatus.getState() == StateType.COMPLETED) {
                    CommandType command = deployStatus.getCommand();
                    if (command == CommandType.START || command == CommandType.STOP) {
                        StatusDisplayer.getDefault().setStatusText(deployStatus.getMessage());
                        TomcatWebModule.this.isRunning = command == CommandType.START;
                        TomcatWebModule.this.node.setDisplayName(TomcatWebModule.this.constructDisplayName());
                    } else if (command == CommandType.UNDEPLOY) {
                        StatusDisplayer.getDefault().setStatusText(deployStatus.getMessage());
                    }
                } else if (deployStatus.getState() == StateType.FAILED) {
                    NotifyDescriptor.Message notDesc = new NotifyDescriptor.Message((Object)deployStatus.getMessage(), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)notDesc);
                    StatusDisplayer.getDefault().setStatusText(deployStatus.getMessage());
                }
            }
        }
    }
}

