/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.config;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.common.api.DatasourceAlreadyExistsException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ContextRootConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.DatasourceConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.DeploymentPlanConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ModuleConfiguration;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.schema2beans.Schema2BeansException;
import org.netbeans.modules.tomcat5.config.TomcatDatasource;
import org.netbeans.modules.tomcat5.config.TomcatDatasourceManager;
import org.netbeans.modules.tomcat5.config.gen.Context;
import org.netbeans.modules.tomcat5.config.gen.Parameter;
import org.netbeans.modules.tomcat5.config.gen.ResourceParams;
import org.netbeans.modules.tomcat5.config.gen.TomeeResources;
import org.netbeans.modules.tomcat5.deploy.TomcatManager;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class TomcatModuleConfiguration
implements ModuleConfiguration,
ContextRootConfiguration,
DatasourceConfiguration,
DeploymentPlanConfiguration,
PropertyChangeListener {
    private final J2eeModule j2eeModule;
    private final TomcatManager.TomcatVersion tomcatVersion;
    private final TomcatManager.TomEEVersion tomeeVersion;
    private DataObject contextDataObject;
    private DataObject resourcesDataObject;
    private final File contextXml;
    private final File resourcesXml;
    private Context context;
    private TomeeResources resources;
    private static final String ATTR_PATH = "path";
    private static final Logger LOGGER = Logger.getLogger(TomcatModuleConfiguration.class.getName());

    public TomcatModuleConfiguration(J2eeModule j2eeModule, TomcatManager.TomcatVersion tomcatVersion, TomcatManager.TomEEVersion tomeeVersion) {
        this.j2eeModule = j2eeModule;
        this.tomcatVersion = tomcatVersion;
        this.tomeeVersion = tomeeVersion;
        this.contextXml = j2eeModule.getDeploymentConfigurationFile("META-INF/context.xml");
        this.resourcesXml = j2eeModule.getDeploymentConfigurationFile("WEB-INF/resources.xml");
        this.init(this.contextXml);
    }

    private void init(File contextXml) {
        try {
            this.getContext();
        }
        catch (ConfigurationException e) {
            LOGGER.log(Level.INFO, null, e);
        }
        if (this.contextDataObject == null) {
            try {
                this.contextDataObject = DataObject.find((FileObject)FileUtil.toFileObject((File)FileUtil.normalizeFile((File)contextXml)));
                this.contextDataObject.addPropertyChangeListener((PropertyChangeListener)this);
            }
            catch (DataObjectNotFoundException donfe) {
                LOGGER.log(Level.FINE, null, donfe);
            }
        }
    }

    public Lookup getLookup() {
        return Lookups.fixed((Object[])new Object[]{this});
    }

    public void dispose() {
    }

    public boolean supportsCreateDatasource() {
        return true;
    }

    public synchronized Context getContext() throws ConfigurationException {
        if (this.context == null) {
            if (this.contextXml.exists()) {
                try {
                    this.context = Context.createGraph(this.contextXml);
                }
                catch (IOException e) {
                    String msg = NbBundle.getMessage(TomcatModuleConfiguration.class, (String)"MSG_ConfigurationXmlReadFail", (Object)this.contextXml.getPath());
                    throw new ConfigurationException(msg, (Throwable)e);
                }
                catch (RuntimeException e) {
                    String msg = NbBundle.getMessage(TomcatModuleConfiguration.class, (String)"MSG_ConfigurationXmlBroken", (Object)this.contextXml.getPath());
                    throw new ConfigurationException(msg, (Throwable)e);
                }
            } else {
                this.context = this.genereateContext();
                TomcatModuleConfiguration.writeToFile(this.contextXml, () -> this.getContext());
            }
        }
        return this.context;
    }

    @CheckForNull
    public synchronized TomeeResources getResources(boolean create) throws ConfigurationException {
        if (this.resources == null) {
            if (this.resourcesXml.exists()) {
                try {
                    this.resources = TomeeResources.createGraph(this.resourcesXml);
                }
                catch (IOException e) {
                    String msg = NbBundle.getMessage(TomcatModuleConfiguration.class, (String)"MSG_ConfigurationXmlReadFail", (Object)this.resourcesXml.getPath());
                    throw new ConfigurationException(msg, (Throwable)e);
                }
                catch (RuntimeException e) {
                    String msg = NbBundle.getMessage(TomcatModuleConfiguration.class, (String)"MSG_ConfigurationXmlBroken", (Object)this.resourcesXml.getPath());
                    throw new ConfigurationException(msg, (Throwable)e);
                }
            } else if (create) {
                this.resources = this.genereateResources();
                TomcatModuleConfiguration.writeToFile(this.resourcesXml, () -> this.getResources(create));
            }
            if (this.resourcesXml.exists() && this.resourcesDataObject == null) {
                try {
                    this.resourcesDataObject = DataObject.find((FileObject)FileUtil.toFileObject((File)FileUtil.normalizeFile((File)this.resourcesXml)));
                }
                catch (DataObjectNotFoundException donfe) {
                    LOGGER.log(Level.FINE, null, donfe);
                }
            }
        }
        return this.resources;
    }

    public String getContextRoot() throws ConfigurationException {
        return this.getContext().getAttributeValue(ATTR_PATH);
    }

    public Set<Datasource> getDatasources() throws ConfigurationException {
        Context context = this.getContext();
        HashSet<Datasource> result = new HashSet<Datasource>();
        int length = context.getResource().length;
        if (this.tomcatVersion.isAtLeast(TomcatManager.TomcatVersion.TOMCAT_55)) {
            TomeeResources actualResources;
            for (int i = 0; i < length; ++i) {
                String type = context.getResourceType(i);
                if (!"javax.sql.DataSource".equals(type)) continue;
                String name = context.getResourceName(i);
                String username = context.getResourceUsername(i);
                String url = context.getResourceUrl(i);
                String password = context.getResourcePassword(i);
                String driverClassName = context.getResourceDriverClassName(i);
                if (name == null || username == null || url == null || driverClassName == null) continue;
                result.add(new TomcatDatasource(username, url, password, name, driverClassName));
            }
            if (this.tomeeVersion != null && (actualResources = this.getResources(false)) != null) {
                result.addAll(TomcatModuleConfiguration.getTomeeDatasources(actualResources));
            }
        } else {
            ResourceParams[] resourceParams = context.getResourceParams();
            for (int i = 0; i < length; ++i) {
                String type = context.getResourceType(i);
                if (!"javax.sql.DataSource".equals(type)) continue;
                String name = context.getResourceName(i);
                for (int j = 0; j < resourceParams.length; ++j) {
                    if (!name.equals(resourceParams[j].getName())) continue;
                    Parameter[] params = resourceParams[j].getParameter();
                    HashMap<String, String> paramNameValueMap = new HashMap<String, String>(params.length);
                    for (Parameter parameter : params) {
                        paramNameValueMap.put(parameter.getName(), parameter.getValue());
                    }
                    String username = (String)paramNameValueMap.get("username");
                    String url = (String)paramNameValueMap.get("url");
                    String password = (String)paramNameValueMap.get("password");
                    String driverClassName = (String)paramNameValueMap.get("driverClassName");
                    if (username == null || url == null || driverClassName == null) continue;
                    result.add(new TomcatDatasource(username, url, password, name, driverClassName));
                }
            }
        }
        return result;
    }

    public Datasource createDatasource(String name, String url, String username, String password, String driverClassName) throws ConfigurationException, DatasourceAlreadyExistsException {
        ArrayList<Datasource> conflictingDS = new ArrayList<Datasource>();
        for (Datasource datasource : this.getDatasources()) {
            if (!name.equals(datasource.getJndiName())) continue;
            conflictingDS.add(datasource);
        }
        if (conflictingDS.size() > 0) {
            throw new DatasourceAlreadyExistsException(conflictingDS);
        }
        if (this.tomcatVersion.isAtLeast(TomcatManager.TomcatVersion.TOMCAT_55)) {
            if (this.tomeeVersion != null) {
                TomeeResources resources = this.getResources(true);
                assert (resources != null);
                this.modifyResources(tomee -> {
                    Properties props = new Properties();
                    props.put("userName", username);
                    props.put("password", password);
                    props.put("jdbcUrl", url);
                    props.put("jdbcDriver", driverClassName);
                    StringWriter sw = new StringWriter();
                    try {
                        props.store(sw, null);
                    }
                    catch (IOException ex) {
                        LOGGER.log(Level.WARNING, null, ex);
                    }
                    int idx = tomee.addTomeeResource(sw.toString());
                    tomee.setTomeeResourceId(idx, name);
                    tomee.setTomeeResourceType(idx, "javax.sql.DataSource");
                });
            } else {
                this.modifyContext(context -> {
                    int idx = context.addResource(true);
                    context.setResourceName(idx, name);
                    context.setResourceAuth(idx, "Container");
                    context.setResourceType(idx, "javax.sql.DataSource");
                    context.setResourceDriverClassName(idx, driverClassName);
                    context.setResourceUrl(idx, url);
                    context.setResourceUsername(idx, username);
                    context.setResourcePassword(idx, password);
                    context.setResourceMaxActive(idx, "20");
                    context.setResourceMaxIdle(idx, "10");
                    context.setResourceMaxWait(idx, "-1");
                });
            }
        } else {
            this.modifyContext(context -> {
                int idx = context.addResource(true);
                context.setResourceName(idx, name);
                context.setResourceAuth(idx, "Container");
                context.setResourceType(idx, "javax.sql.DataSource");
                ResourceParams[] resourceParams = context.getResourceParams();
                for (int i = 0; i < resourceParams.length; ++i) {
                    if (!name.equals(resourceParams[i].getName())) continue;
                    context.removeResourceParams(resourceParams[i]);
                }
                ResourceParams newResourceParams = TomcatModuleConfiguration.createResourceParams(name, new Parameter[]{TomcatModuleConfiguration.createParameter("factory", "org.apache.commons.dbcp.BasicDataSourceFactory"), TomcatModuleConfiguration.createParameter("driverClassName", driverClassName), TomcatModuleConfiguration.createParameter("url", url), TomcatModuleConfiguration.createParameter("username", username), TomcatModuleConfiguration.createParameter("password", password), TomcatModuleConfiguration.createParameter("maxActive", "20"), TomcatModuleConfiguration.createParameter("maxIdle", "10"), TomcatModuleConfiguration.createParameter("maxWait", "-1")});
                context.addResourceParams(newResourceParams);
            });
        }
        return new TomcatDatasource(username, url, password, name, driverClassName);
    }

    public void setContextRoot(String contextPath) throws ConfigurationException {
        if (!this.isCorrectCP(contextPath)) {
            String ctxRoot = contextPath;
            StringTokenizer tok = new StringTokenizer(contextPath, "/");
            StringBuilder buf = new StringBuilder();
            while (tok.hasMoreTokens()) {
                buf.append("/").append(tok.nextToken());
            }
            ctxRoot = buf.toString();
            NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)NbBundle.getMessage(TomcatModuleConfiguration.class, (String)"MSG_invalidCP", (Object)contextPath), 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            contextPath = ctxRoot;
        }
        String newContextPath = contextPath;
        this.modifyContext(context -> {
            if (this.tomcatVersion == TomcatManager.TomcatVersion.TOMCAT_50) {
                String oldContextPath = context.getAttributeValue(ATTR_PATH);
                String oldPrefix = context.getLoggerPrefix();
                if (oldPrefix != null && oldPrefix.equals(TomcatModuleConfiguration.computeLoggerPrefix(oldContextPath))) {
                    context.setLoggerPrefix(TomcatModuleConfiguration.computeLoggerPrefix(newContextPath));
                }
            }
            context.setAttributeValue(ATTR_PATH, newContextPath);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "modified" && evt.getNewValue() == Boolean.FALSE) {
            TomcatModuleConfiguration tomcatModuleConfiguration = this;
            synchronized (tomcatModuleConfiguration) {
                this.context = null;
            }
        }
    }

    public J2eeModule getJ2eeModule() {
        return this.j2eeModule;
    }

    public void save(OutputStream os) throws ConfigurationException {
        Context ctx = this.getContext();
        try {
            ctx.write(os);
        }
        catch (IOException ioe) {
            String msg = NbBundle.getMessage(TomcatModuleConfiguration.class, (String)"MSG_ConfigurationXmlWriteFail", (Object)this.contextXml.getPath());
            throw new ConfigurationException(msg, (Throwable)ioe);
        }
    }

    private Context genereateContext() {
        Context newContext = new Context();
        String path = "";
        newContext.setAttributeValue(ATTR_PATH, path);
        if (this.tomcatVersion == TomcatManager.TomcatVersion.TOMCAT_50) {
            newContext.setLogger(true);
            newContext.setLoggerClassName("org.apache.catalina.logger.FileLogger");
            newContext.setLoggerPrefix(TomcatModuleConfiguration.computeLoggerPrefix(path));
            newContext.setLoggerSuffix(".log");
            newContext.setLoggerTimestamp("true");
        } else if (this.tomcatVersion == TomcatManager.TomcatVersion.TOMCAT_55 || this.tomcatVersion == TomcatManager.TomcatVersion.TOMCAT_60 || this.tomcatVersion == TomcatManager.TomcatVersion.TOMCAT_70) {
            newContext.setAntiJARLocking("true");
        }
        return newContext;
    }

    private TomeeResources genereateResources() {
        return new TomeeResources();
    }

    private void modifyContext(final ContextModifier modifier) throws ConfigurationException {
        TomcatModuleConfiguration.modifyConfiguration(this.contextDataObject, new ConfigurationModifier<Context>(){

            @Override
            public void modify(Context configuration) {
                modifier.modify(configuration);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void finished(Context configuration) {
                TomcatModuleConfiguration tomcatModuleConfiguration = TomcatModuleConfiguration.this;
                synchronized (tomcatModuleConfiguration) {
                    TomcatModuleConfiguration.this.context = configuration;
                }
            }
        }, new ConfigurationFactory<Context>(){

            @Override
            public Context create(byte[] content) {
                return Context.createGraph(new ByteArrayInputStream(content));
            }
        }, new ConfigurationValue<Context>(){

            @Override
            public Context getValue() throws ConfigurationException {
                return TomcatModuleConfiguration.this.getContext();
            }
        });
    }

    private void modifyResources(final ResourcesModifier modifier) throws ConfigurationException {
        TomcatModuleConfiguration.modifyConfiguration(this.resourcesDataObject, new ConfigurationModifier<TomeeResources>(){

            @Override
            public void modify(TomeeResources configuration) {
                modifier.modify(configuration);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void finished(TomeeResources configuration) {
                TomcatModuleConfiguration tomcatModuleConfiguration = TomcatModuleConfiguration.this;
                synchronized (tomcatModuleConfiguration) {
                    TomcatModuleConfiguration.this.resources = configuration;
                }
            }
        }, new ConfigurationFactory<TomeeResources>(){

            @Override
            public TomeeResources create(byte[] content) {
                return TomeeResources.createGraph(new ByteArrayInputStream(content));
            }
        }, new ConfigurationValue<TomeeResources>(){

            @Override
            public TomeeResources getValue() throws ConfigurationException {
                return TomcatModuleConfiguration.this.getResources(false);
            }
        });
    }

    private static <T extends BaseBean> void modifyConfiguration(DataObject dataObject, ConfigurationModifier<T> modifier, ConfigurationFactory<T> factory, ConfigurationValue<T> value) throws ConfigurationException {
        assert (dataObject != null) : "DataObject has not been initialized yet";
        try {
            SaveCookie cookie;
            EditorCookie editor = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            StyledDocument doc = editor.getDocument();
            if (doc == null) {
                doc = editor.openDocument();
            }
            BaseBean newConfig = null;
            try {
                byte[] docString = doc.getText(0, doc.getLength()).getBytes();
                newConfig = (BaseBean)factory.create(docString);
            }
            catch (RuntimeException e) {
                BaseBean oldConfig = (BaseBean)value.getValue();
                NotifyDescriptor.Confirmation notDesc = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(TomcatModuleConfiguration.class, (String)"MSG_ConfigurationXmlNotValid", (Object)dataObject.getPrimaryFile().getNameExt()), 2);
                Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)notDesc);
                if (result == NotifyDescriptor.CANCEL_OPTION) {
                    return;
                }
                newConfig = oldConfig;
            }
            modifier.modify(newConfig);
            boolean modified = dataObject.isModified();
            TomcatModuleConfiguration.replaceDocument(doc, newConfig);
            if (!modified && (cookie = (SaveCookie)dataObject.getCookie(SaveCookie.class)) != null) {
                cookie.save();
            }
            modifier.finished(newConfig);
        }
        catch (IOException | BadLocationException e) {
            String msg = NbBundle.getMessage(TomcatModuleConfiguration.class, (String)"MSG_ConfigurationXmlWriteFail", (Object)dataObject.getPrimaryFile().getPath());
            throw new ConfigurationException(msg, (Throwable)e);
        }
    }

    private static Set<Datasource> getTomeeDatasources(TomeeResources actualResources) {
        HashSet<Datasource> result = new HashSet<Datasource>();
        int resourcesLength = actualResources.getTomeeResource().length;
        for (int i = 0; i < resourcesLength; ++i) {
            Datasource ds;
            String type = actualResources.getTomeeResourceType(i);
            if (!"javax.sql.DataSource".equals(type) || (ds = TomcatDatasourceManager.createDatasource(actualResources.getTomeeResourceId(i), actualResources.getTomeeResource(i))) == null) continue;
            result.add(ds);
        }
        return result;
    }

    private static Parameter createParameter(String name, String value) {
        Parameter parameter = new Parameter();
        parameter.setName(name);
        parameter.setValue(value);
        return parameter;
    }

    private static ResourceParams createResourceParams(String name, Parameter[] parameters) {
        ResourceParams resourceParams = new ResourceParams();
        resourceParams.setName(name);
        for (int i = 0; i < parameters.length; ++i) {
            resourceParams.addParameter(parameters[i]);
        }
        return resourceParams;
    }

    private static String computeLoggerPrefix(String contextPath) {
        return contextPath.length() > 0 ? contextPath.substring(1).replace('/', '_').concat(".") : "ROOT.";
    }

    private static <T extends BaseBean> void writeToFile(File file, ConfigurationValue<T> store) throws ConfigurationException {
        assert (file != null) : "File to write can't be null";
        assert (file.getParentFile() != null) : "File parent folder can't be null";
        try {
            FileObject cfolder = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file.getParentFile()));
            if (cfolder == null) {
                try {
                    cfolder = FileUtil.createFolder((File)FileUtil.normalizeFile((File)file.getParentFile()));
                }
                catch (IOException ex) {
                    throw new ConfigurationException(NbBundle.getMessage(TomcatModuleConfiguration.class, (String)"MSG_FailedToCreateConfigFolder", (Object)file.getParentFile().getAbsolutePath()));
                }
            }
            FileObject folder = cfolder;
            ConfigurationException[] anonClassException = new ConfigurationException[]{null};
            FileSystem fs = folder.getFileSystem();
            fs.runAtomicAction(() -> {
                String name = file.getName();
                FileObject configFO = folder.getFileObject(name);
                if (configFO == null) {
                    configFO = folder.createData(name);
                }
                BaseBean ctx = null;
                try {
                    ctx = (BaseBean)store.getValue();
                }
                catch (ConfigurationException e) {
                    anonClassException[0] = e;
                    return;
                }
                try (FileLock lock = configFO.lock();
                     BufferedOutputStream os = new BufferedOutputStream(configFO.getOutputStream(lock), 4096);){
                    if (ctx != null) {
                        ctx.write((OutputStream)os);
                    }
                }
            });
            if (anonClassException[0] != null) {
                throw anonClassException[0];
            }
        }
        catch (IOException e) {
            String msg = NbBundle.getMessage(TomcatModuleConfiguration.class, (String)"MSG_ConfigurationXmlWriteFail", (Object)file.getPath());
            throw new ConfigurationException(msg, (Throwable)e);
        }
    }

    private static void replaceDocument(StyledDocument doc, BaseBean graph) {
        StringWriter out = new StringWriter();
        try {
            graph.write((Writer)out);
        }
        catch (IOException | Schema2BeansException ex) {
            Logger.getLogger(TomcatModuleConfiguration.class.getName()).log(Level.INFO, null, ex);
        }
        NbDocument.runAtomic((StyledDocument)doc, () -> {
            try {
                doc.remove(0, doc.getLength());
                doc.insertString(0, out.toString(), null);
            }
            catch (BadLocationException ble) {
                Exceptions.printStackTrace((Throwable)ble);
            }
        });
    }

    private boolean isCorrectCP(String contextPath) {
        boolean correct = true;
        if (!contextPath.equals("") && !contextPath.startsWith("/")) {
            correct = false;
        } else if (contextPath.endsWith("/")) {
            correct = false;
        } else if (contextPath.indexOf("//") >= 0) {
            correct = false;
        }
        return correct;
    }

    public void bindDatasourceReference(String referenceName, String jndiName) throws ConfigurationException {
        Set<Datasource> datasources = this.getDatasources();
        for (Datasource ds : datasources) {
            if (!referenceName.equals(ds.getJndiName())) continue;
            return;
        }
        Context context = this.getContext();
        int lengthResourceLink = context.getResourceLink().length;
        for (int i = 0; i < lengthResourceLink; ++i) {
            if (!referenceName.equals(context.getResourceLinkName(i))) continue;
            return;
        }
        for (Datasource ds : datasources) {
            if (!referenceName.equals(ds.getJndiName())) continue;
            try {
                this.createDatasource(referenceName, ds.getUrl(), ds.getUsername(), ds.getPassword(), ds.getDriverClassName());
            }
            catch (DatasourceAlreadyExistsException ex) {
                LOGGER.log(Level.INFO, "Datasource with the ''{0}'' reference name already exists.", referenceName);
            }
            return;
        }
        this.modifyContext(ctx -> {
            int idx = ctx.addResourceLink(true);
            ctx.setResourceLinkName(idx, referenceName);
            ctx.setResourceLinkGlobal(idx, jndiName);
            ctx.setResourceLinkType(idx, "javax.sql.DataSource");
        });
    }

    public void bindDatasourceReferenceForEjb(String ejbName, String ejbType, String referenceName, String jndiName) throws ConfigurationException {
    }

    public String findDatasourceJndiName(String referenceName) throws ConfigurationException {
        TomeeResources actualResources;
        int i;
        Context context = this.getContext();
        if (context != null) {
            int lengthResource = context.getResource().length;
            for (int i2 = 0; i2 < lengthResource; ++i2) {
                if (!referenceName.equals(context.getResourceName(i2))) continue;
                return referenceName;
            }
            int lengthResourceLink = context.getResourceLink().length;
            for (i = 0; i < lengthResourceLink; ++i) {
                if (!referenceName.equals(context.getResourceLinkName(i))) continue;
                return context.getResourceLinkGlobal(i);
            }
        }
        if (this.tomeeVersion != null && (actualResources = this.getResources(false)) != null) {
            int lengthResource = actualResources.getTomeeResource().length;
            for (i = 0; i < lengthResource; ++i) {
                if (!referenceName.equals(actualResources.getTomeeResourceId(i))) continue;
                return referenceName;
            }
        }
        return null;
    }

    public String findDatasourceJndiNameForEjb(String ejbName, String referenceName) throws ConfigurationException {
        return null;
    }

    private static interface ConfigurationFactory<T> {
        public T create(byte[] var1);
    }

    private static interface ConfigurationValue<T> {
        public T getValue() throws ConfigurationException;
    }

    private static interface ConfigurationModifier<T> {
        public void modify(T var1);

        public void finished(T var1);
    }

    private static interface ResourcesModifier {
        public void modify(TomeeResources var1);
    }

    private static interface ContextModifier {
        public void modify(Context var1);
    }
}

