/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbverification;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;

public class JavaUtils {
    public static String extractClassNameFromType(TypeMirror type) {
        Element elem;
        if (type instanceof DeclaredType && ((elem = ((DeclaredType)type).asElement()).getKind() == ElementKind.CLASS || elem.getKind() == ElementKind.INTERFACE)) {
            return ((TypeElement)elem).getQualifiedName().toString();
        }
        return null;
    }

    public static boolean hasAnnotation(Element element, String annClass) {
        AnnotationMirror annEntity = JavaUtils.findAnnotation(element, annClass);
        return annEntity != null;
    }

    public static AnnotationMirror findAnnotation(Element element, String annotationClass) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationClass.equals(annotationMirror.getAnnotationType().toString())) continue;
            return annotationMirror;
        }
        return null;
    }

    public static AnnotationValue getAnnotationAttrValue(AnnotationMirror ann, String attrName) {
        if (ann != null) {
            for (ExecutableElement executableElement : ann.getElementValues().keySet()) {
                if (!attrName.equals(executableElement.getSimpleName().toString())) continue;
                return ann.getElementValues().get(executableElement);
            }
        }
        return null;
    }

    public static String getShortClassName(String qualifiedClassName) {
        return qualifiedClassName.substring(qualifiedClassName.lastIndexOf(".") + 1);
    }

    public static boolean isMethodSignatureSame(CompilationInfo cinfo, ExecutableElement method1, ExecutableElement method2) {
        int paramCount = method1.getParameters().size();
        if (paramCount != method2.getParameters().size()) {
            return false;
        }
        for (int i = 0; i < paramCount; ++i) {
            TypeMirror param1 = method1.getParameters().get(i).asType();
            TypeMirror param2 = method2.getParameters().get(i).asType();
            if (cinfo.getTypes().isSameType(param1, param2) || JavaUtils.isSameDeclaredType(param1, param2) || param2.getKind() == TypeKind.TYPEVAR && JavaUtils.isParamEquivalentOfErasure(cinfo, method1, method2, param1.toString(), param2.toString())) continue;
            return false;
        }
        return true;
    }

    private static boolean isParamEquivalentOfErasure(CompilationInfo cinfo, ExecutableElement sourceMethod, ExecutableElement targetMethod, String sourceParam, String targetParam) {
        TypeMirror classTypeMirror = sourceMethod.getEnclosingElement().asType();
        for (TypeMirror typeMirror : cinfo.getTypes().directSupertypes(classTypeMirror)) {
            HashMap<String, String> argumentNamesMap;
            DeclaredType declaredType;
            if (!(typeMirror instanceof DeclaredType) || !(declaredType = (DeclaredType)typeMirror).asElement().getEnclosedElements().contains(targetMethod) || !sourceParam.equals((argumentNamesMap = JavaUtils.getErasureTypesMap(cinfo.getElementUtilities().enclosingTypeElement((Element)targetMethod).getTypeParameters(), declaredType.getTypeArguments())).get(targetParam))) continue;
            return true;
        }
        return false;
    }

    private static HashMap<String, String> getErasureTypesMap(List<? extends TypeParameterElement> erasureArguments, List<? extends TypeMirror> typeArguments) {
        HashMap<String, String> result = new HashMap<String, String>(erasureArguments.size());
        for (int i = 0; i < erasureArguments.size(); ++i) {
            if (erasureArguments.size() == i || typeArguments.size() == i) {
                return result;
            }
            result.put(erasureArguments.get(i).toString(), typeArguments.get(i).toString());
        }
        return result;
    }

    public static boolean isSameDeclaredType(TypeMirror param1, TypeMirror param2) {
        String classNameParam1 = JavaUtils.extractClassNameFromType(param1);
        return classNameParam1 != null && classNameParam1.equals(JavaUtils.extractClassNameFromType(param2));
    }

    public static boolean isTypeOf(CompilationInfo info, Element element, String superType) {
        TypeMirror tm = element.asType();
        ArrayList<Element> types = new ArrayList<Element>();
        ArrayDeque<? extends TypeMirror> deque = new ArrayDeque<TypeMirror>();
        deque.add(tm);
        while (!deque.isEmpty()) {
            TypeElement tel;
            TypeMirror mirror = (TypeMirror)deque.pop();
            if (mirror.getKind() != TypeKind.DECLARED) continue;
            Element el = info.getTypes().asElement(mirror);
            types.add(el);
            if (el.getKind() == ElementKind.CLASS) {
                tel = (TypeElement)el;
                deque.add(tel.getSuperclass());
                deque.addAll(tel.getInterfaces());
                continue;
            }
            if (el.getKind() != ElementKind.INTERFACE) continue;
            tel = (TypeElement)el;
            for (TypeMirror typeMirror : tel.getInterfaces()) {
                deque.add(typeMirror);
            }
        }
        for (Element type : types) {
            if (!superType.equals(type.asType().toString())) continue;
            return true;
        }
        return false;
    }
}

