/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.schematron;

import com.thaiopensource.util.Localizer;
import com.thaiopensource.util.PropertyId;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.AbstractSchemaReader;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.Option;
import com.thaiopensource.validate.ResolverFactory;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.Validator;
import com.thaiopensource.validate.prop.rng.RngProperty;
import com.thaiopensource.validate.prop.schematron.SchematronProperty;
import com.thaiopensource.validate.rng.CompactSchemaReader;
import com.thaiopensource.validate.schematron.DraconianErrorListener;
import com.thaiopensource.validate.schematron.SchemaImpl;
import com.thaiopensource.validate.schematron.TransformerFactoryInitializer;
import com.thaiopensource.validate.schematron.XMLReaderImpl;
import com.thaiopensource.xml.sax.CountingErrorHandler;
import com.thaiopensource.xml.sax.DelegatingContentHandler;
import com.thaiopensource.xml.sax.DraconianErrorHandler;
import com.thaiopensource.xml.sax.ForkContentHandler;
import com.thaiopensource.xml.sax.Resolver;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

class SchemaReaderImpl
extends AbstractSchemaReader {
    static final String SCHEMATRON_URI = "http://www.ascc.net/xml/schematron";
    private static final String LOCATION_URI = "http://www.thaiopensource.com/ns/location";
    private static final String ERROR_URI = "http://www.thaiopensource.com/ns/error";
    private final Localizer localizer = new Localizer(class$com$thaiopensource$validate$schematron$SchemaReaderImpl == null ? (class$com$thaiopensource$validate$schematron$SchemaReaderImpl = SchemaReaderImpl.class$("com.thaiopensource.validate.schematron.SchemaReaderImpl")) : class$com$thaiopensource$validate$schematron$SchemaReaderImpl);
    private final Class transformerFactoryClass;
    private final TransformerFactoryInitializer transformerFactoryInitializer;
    private final Templates schematron;
    private final Schema schematronSchema;
    private static final String SCHEMATRON_SCHEMA = "schematron.rnc";
    private static final String SCHEMATRON_STYLESHEET = "schematron.xsl";
    private static final String SCHEMATRON_XSLTC_STYLESHEET = "schematron-xsltc.xsl";
    private static final PropertyId[] supportedPropertyIds = new PropertyId[]{ValidateProperty.ERROR_HANDLER, ValidateProperty.XML_READER_CREATOR, ValidateProperty.ENTITY_RESOLVER, ValidateProperty.URI_RESOLVER, ValidateProperty.RESOLVER, SchematronProperty.DIAGNOSE, SchematronProperty.PHASE};
    static /* synthetic */ Class class$com$thaiopensource$validate$schematron$SchemaReaderImpl;

    SchemaReaderImpl(SAXTransformerFactory sAXTransformerFactory, TransformerFactoryInitializer transformerFactoryInitializer) throws TransformerConfigurationException, IncorrectSchemaException {
        this.transformerFactoryClass = sAXTransformerFactory.getClass();
        this.transformerFactoryInitializer = transformerFactoryInitializer;
        boolean bl = this.transformerFactoryClass.getName().indexOf(".xsltc.") >= 0;
        String string = bl ? SCHEMATRON_XSLTC_STYLESHEET : SCHEMATRON_STYLESHEET;
        String string2 = SchemaReaderImpl.fullResourceName(string);
        StreamSource streamSource = new StreamSource(SchemaReaderImpl.getResourceAsStream(string2));
        this.initTransformerFactory(sAXTransformerFactory);
        this.schematron = sAXTransformerFactory.newTemplates(streamSource);
        InputSource inputSource = new InputSource(SchemaReaderImpl.getResourceAsStream(SchemaReaderImpl.fullResourceName(SCHEMATRON_SCHEMA)));
        PropertyMapBuilder propertyMapBuilder = new PropertyMapBuilder();
        ValidateProperty.ERROR_HANDLER.put(propertyMapBuilder, new DraconianErrorHandler());
        RngProperty.CHECK_ID_IDREF.add(propertyMapBuilder);
        try {
            this.schematronSchema = CompactSchemaReader.getInstance().createSchema(inputSource, propertyMapBuilder.toPropertyMap());
        }
        catch (SAXException sAXException) {
            throw new IncorrectSchemaException();
        }
        catch (IOException iOException) {
            throw new IncorrectSchemaException();
        }
    }

    public Option getOption(String string) {
        return SchematronProperty.getOption(string);
    }

    private void initTransformerFactory(TransformerFactory transformerFactory) {
        this.transformerFactoryInitializer.initTransformerFactory(transformerFactory);
    }

    private Schema createSchema2(InputSource inputSource, PropertyMap propertyMap) throws IOException, SAXException, IncorrectSchemaException {
        ErrorHandler errorHandler = ValidateProperty.ERROR_HANDLER.get(propertyMap);
        CountingErrorHandler countingErrorHandler = new CountingErrorHandler(errorHandler);
        String string = inputSource.getSystemId();
        try {
            SAXTransformerFactory sAXTransformerFactory = (SAXTransformerFactory)this.transformerFactoryClass.newInstance();
            this.initTransformerFactory(sAXTransformerFactory);
            TransformerHandler transformerHandler = sAXTransformerFactory.newTransformerHandler(this.schematron);
            PropertyMapBuilder propertyMapBuilder = new PropertyMapBuilder(propertyMap);
            ValidateProperty.ERROR_HANDLER.put(propertyMapBuilder, countingErrorHandler);
            Validator validator = this.schematronSchema.createValidator(propertyMapBuilder.toPropertyMap());
            Resolver resolver = ResolverFactory.createResolver(propertyMap);
            XMLReader xMLReader = resolver.createXMLReader();
            xMLReader.setContentHandler(new ForkContentHandler(validator.getContentHandler(), transformerHandler));
            sAXTransformerFactory.setErrorListener(new SAXErrorListener(countingErrorHandler, string));
            TemplatesHandler templatesHandler = sAXTransformerFactory.newTemplatesHandler();
            LocationFilter locationFilter = new LocationFilter(new ErrorFilter(templatesHandler, countingErrorHandler, this.localizer), string);
            transformerHandler.setResult(new SAXResult(locationFilter));
            xMLReader.setErrorHandler(countingErrorHandler);
            xMLReader.parse(inputSource);
            SAXException sAXException = locationFilter.getException();
            if (sAXException != null) {
                throw sAXException;
            }
            if (countingErrorHandler.getHadErrorOrFatalError()) {
                throw new IncorrectSchemaException();
            }
            return new SchemaImpl(templatesHandler.getTemplates(), this.transformerFactoryClass, propertyMap, supportedPropertyIds);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new SAXException(this.localizer.message("unexpected_schema_creation_error"));
        }
        catch (InstantiationException instantiationException) {
            throw new SAXException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SAXException(illegalAccessException);
        }
    }

    public Schema createSchema(SAXSource sAXSource, PropertyMap propertyMap) throws IOException, SAXException, IncorrectSchemaException {
        ErrorHandler errorHandler = ValidateProperty.ERROR_HANDLER.get(propertyMap);
        SAXErrorListener sAXErrorListener = new SAXErrorListener(errorHandler, sAXSource.getSystemId());
        UserWrapErrorHandler userWrapErrorHandler = new UserWrapErrorHandler(errorHandler);
        UserWrapErrorHandler userWrapErrorHandler2 = new UserWrapErrorHandler(errorHandler);
        try {
            PropertyMapBuilder propertyMapBuilder = new PropertyMapBuilder(propertyMap);
            ValidateProperty.ERROR_HANDLER.put(propertyMapBuilder, userWrapErrorHandler);
            sAXSource = this.createValidatingSource(sAXSource, propertyMapBuilder.toPropertyMap(), userWrapErrorHandler);
            sAXSource = this.createTransformingSource(sAXSource, SchematronProperty.PHASE.get(propertyMap), propertyMap.contains(SchematronProperty.DIAGNOSE), sAXSource.getSystemId(), userWrapErrorHandler2);
            TransformerFactory transformerFactory = (TransformerFactory)this.transformerFactoryClass.newInstance();
            this.initTransformerFactory(transformerFactory);
            transformerFactory.setErrorListener(sAXErrorListener);
            transformerFactory.setURIResolver(ResolverFactory.createResolver(propertyMap).getURIResolver());
            Templates templates = transformerFactory.newTemplates(sAXSource);
            return new SchemaImpl(templates, this.transformerFactoryClass, propertyMap, supportedPropertyIds);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw this.toSAXException(transformerConfigurationException, sAXErrorListener.getHadError() || userWrapErrorHandler.getHadErrorOrFatalError() || userWrapErrorHandler2.getHadErrorOrFatalError());
        }
        catch (InstantiationException instantiationException) {
            throw new SAXException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SAXException(illegalAccessException);
        }
    }

    private SAXSource createValidatingSource(SAXSource sAXSource, PropertyMap propertyMap, CountingErrorHandler countingErrorHandler) throws SAXException {
        Validator validator = this.schematronSchema.createValidator(propertyMap);
        XMLReader xMLReader = sAXSource.getXMLReader();
        if (xMLReader == null) {
            xMLReader = ResolverFactory.createResolver(propertyMap).createXMLReader();
        }
        xMLReader.setErrorHandler(countingErrorHandler);
        return new SAXSource(new ValidateStage(xMLReader, validator, countingErrorHandler), sAXSource.getInputSource());
    }

    private SAXSource createTransformingSource(SAXSource sAXSource, String string, boolean bl, String string2, CountingErrorHandler countingErrorHandler) throws SAXException {
        try {
            Transformer transformer = this.schematron.newTransformer();
            transformer.setErrorListener(new DraconianErrorListener());
            if (string != null) {
                transformer.setParameter("phase", string);
            }
            if (bl) {
                transformer.setParameter("diagnose", Boolean.TRUE);
            }
            return new SAXSource(new TransformStage(transformer, sAXSource, string2, countingErrorHandler, this.localizer), new InputSource(string2));
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new SAXException(transformerConfigurationException);
        }
    }

    private SAXException toSAXException(TransformerException transformerException, boolean bl) throws IOException, IncorrectSchemaException {
        return this.causeToSAXException(transformerException.getException(), bl);
    }

    private SAXException causeToSAXException(Throwable throwable, boolean bl) throws IOException, IncorrectSchemaException {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof IOException) {
            throw (IOException)throwable;
        }
        if (throwable instanceof IncorrectSchemaException) {
            throw (IncorrectSchemaException)throwable;
        }
        if (throwable instanceof SAXException) {
            return this.causeToSAXException(((SAXException)throwable).getException(), bl);
        }
        if (throwable instanceof TransformerException) {
            return this.toSAXException((TransformerException)throwable, bl);
        }
        if (throwable instanceof UserException) {
            return SchemaReaderImpl.toSAXException((UserException)throwable);
        }
        if (bl) {
            throw new IncorrectSchemaException();
        }
        return new SAXException(this.localizer.message("unexpected_schema_creation_error"), throwable instanceof Exception ? (Exception)throwable : null);
    }

    private static SAXException toSAXException(UserException userException) throws IOException, IncorrectSchemaException {
        SAXException sAXException = userException.getException();
        Exception exception = sAXException.getException();
        if (exception instanceof IncorrectSchemaException) {
            throw (IncorrectSchemaException)exception;
        }
        if (exception instanceof IOException) {
            throw (IOException)exception;
        }
        return sAXException;
    }

    private static String fullResourceName(String string) {
        String string2 = (class$com$thaiopensource$validate$schematron$SchemaReaderImpl == null ? (class$com$thaiopensource$validate$schematron$SchemaReaderImpl = SchemaReaderImpl.class$("com.thaiopensource.validate.schematron.SchemaReaderImpl")) : class$com$thaiopensource$validate$schematron$SchemaReaderImpl).getName();
        return string2.substring(0, string2.lastIndexOf(46)).replace('.', '/') + "/resources/" + string;
    }

    private static InputStream getResourceAsStream(String string) {
        ClassLoader classLoader = (class$com$thaiopensource$validate$schematron$SchemaReaderImpl == null ? (class$com$thaiopensource$validate$schematron$SchemaReaderImpl = SchemaReaderImpl.class$("com.thaiopensource.validate.schematron.SchemaReaderImpl")) : class$com$thaiopensource$validate$schematron$SchemaReaderImpl).getClassLoader();
        if (classLoader == null) {
            return ClassLoader.getSystemResourceAsStream(string);
        }
        return classLoader.getResourceAsStream(string);
    }

    static SAXException toSAXException(TransformerException transformerException) {
        Throwable throwable = transformerException.getException();
        if (throwable instanceof SAXException) {
            return (SAXException)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Exception) {
            return new SAXException((Exception)throwable);
        }
        return new SAXException(transformerException);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class SAXErrorListener
    implements ErrorListener {
        private final ErrorHandler eh;
        private final String systemId;
        private boolean hadError = false;

        SAXErrorListener(ErrorHandler errorHandler, String string) {
            this.eh = errorHandler;
            this.systemId = string;
        }

        boolean getHadError() {
            return this.hadError;
        }

        public void warning(TransformerException transformerException) throws TransformerException {
            SAXParseException sAXParseException = this.transform(transformerException);
            try {
                this.eh.warning(sAXParseException);
            }
            catch (SAXException sAXException) {
                throw new TransformerException(new UserException(sAXException));
            }
        }

        public void error(TransformerException transformerException) throws TransformerException {
            this.hadError = true;
            SAXParseException sAXParseException = this.transform(transformerException);
            try {
                this.eh.error(sAXParseException);
            }
            catch (SAXException sAXException) {
                throw new TransformerException(new UserException(sAXException));
            }
        }

        public void fatalError(TransformerException transformerException) throws TransformerException {
            this.hadError = true;
            SAXParseException sAXParseException = this.transform(transformerException);
            try {
                this.eh.fatalError(sAXParseException);
            }
            catch (SAXException sAXException) {
                throw new TransformerException(new UserException(sAXException));
            }
        }

        SAXParseException transform(TransformerException transformerException) throws TransformerException {
            Throwable throwable = transformerException.getException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof SAXException || throwable instanceof IncorrectSchemaException || throwable instanceof IOException) {
                throw transformerException;
            }
            SourceLocator sourceLocator = transformerException.getLocator();
            if (sourceLocator == null) {
                return new SAXParseException(transformerException.getMessage(), null);
            }
            String string = sourceLocator.getSystemId();
            if (string == null) {
                string = this.systemId;
            }
            return new SAXParseException(transformerException.getMessage(), sourceLocator.getPublicId(), string, sourceLocator.getLineNumber(), sourceLocator.getColumnNumber());
        }
    }

    static class TransformStage
    extends XMLReaderImpl {
        private ContentHandler contentHandler;
        private final Transformer transformer;
        private final SAXSource transformSource;
        private final String systemId;
        private final CountingErrorHandler ceh;
        private final Localizer localizer;

        TransformStage(Transformer transformer, SAXSource sAXSource, String string, CountingErrorHandler countingErrorHandler, Localizer localizer) {
            this.transformer = transformer;
            this.transformSource = sAXSource;
            this.systemId = string;
            this.ceh = countingErrorHandler;
            this.localizer = localizer;
        }

        public void parse(InputSource inputSource) throws IOException, SAXException {
            try {
                LocationFilter locationFilter = new LocationFilter(new ErrorFilter(this.contentHandler, this.ceh, this.localizer), this.systemId);
                this.transformer.transform(this.transformSource, new SAXResult(locationFilter));
                SAXException sAXException = locationFilter.getException();
                if (sAXException != null) {
                    throw sAXException;
                }
            }
            catch (TransformerException transformerException) {
                if (transformerException.getException() instanceof IOException) {
                    throw (IOException)transformerException.getException();
                }
                throw SchemaReaderImpl.toSAXException(transformerException);
            }
            if (this.ceh.getHadErrorOrFatalError()) {
                throw new SAXException(new IncorrectSchemaException());
            }
        }

        public ContentHandler getContentHandler() {
            return this.contentHandler;
        }

        public void setContentHandler(ContentHandler contentHandler) {
            this.contentHandler = contentHandler;
        }
    }

    static class LocationFilter
    extends DelegatingContentHandler
    implements Locator {
        private final String mainSystemId;
        private String systemId = null;
        private int lineNumber = -1;
        private int columnNumber = -1;
        private SAXException exception = null;

        LocationFilter(ContentHandler contentHandler, String string) {
            super(contentHandler);
            this.mainSystemId = string;
        }

        SAXException getException() {
            return this.exception;
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void startDocument() throws SAXException {
            this.getDelegate().setDocumentLocator(this);
            super.startDocument();
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.systemId = LocationFilter.getLocationAttribute(attributes, "system-id");
            this.lineNumber = LocationFilter.toInteger(LocationFilter.getLocationAttribute(attributes, "line-number"));
            this.columnNumber = LocationFilter.toInteger(LocationFilter.getLocationAttribute(attributes, "column-number"));
            try {
                super.startElement(string, string2, string3, attributes);
            }
            catch (SAXException sAXException) {
                this.exception = sAXException;
                this.setDelegate(null);
            }
            this.systemId = null;
            this.lineNumber = -1;
            this.columnNumber = -1;
        }

        private static String getLocationAttribute(Attributes attributes, String string) {
            return attributes.getValue(SchemaReaderImpl.LOCATION_URI, string);
        }

        private static int toInteger(String string) {
            if (string == null) {
                return -1;
            }
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }

        public String getPublicId() {
            return null;
        }

        public String getSystemId() {
            if (this.systemId != null && !this.systemId.equals("")) {
                return this.systemId;
            }
            return this.mainSystemId;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public int getColumnNumber() {
            return this.columnNumber;
        }
    }

    static class ErrorFilter
    extends DelegatingContentHandler {
        private final ErrorHandler eh;
        private final Localizer localizer;
        private Locator locator;

        ErrorFilter(ContentHandler contentHandler, ErrorHandler errorHandler, Localizer localizer) {
            super(contentHandler);
            this.eh = errorHandler;
            this.localizer = localizer;
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
            super.setDocumentLocator(locator);
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string.equals(SchemaReaderImpl.ERROR_URI) && string2.equals("error")) {
                this.eh.error(new SAXParseException(this.localizer.message(attributes.getValue("", "message"), attributes.getValue("", "arg")), this.locator));
            }
            super.startElement(string, string2, string3, attributes);
        }
    }

    static class UserWrapErrorHandler
    extends CountingErrorHandler {
        UserWrapErrorHandler(ErrorHandler errorHandler) {
            super(errorHandler);
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            try {
                super.warning(sAXParseException);
            }
            catch (SAXException sAXException) {
                throw new SAXException(new UserException(sAXException));
            }
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            try {
                super.error(sAXParseException);
            }
            catch (SAXException sAXException) {
                throw new SAXException(new UserException(sAXException));
            }
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            try {
                super.fatalError(sAXParseException);
            }
            catch (SAXException sAXException) {
                throw new SAXException(new UserException(sAXException));
            }
        }
    }

    static class UserException
    extends Exception {
        private final SAXException exception;

        UserException(SAXException sAXException) {
            this.exception = sAXException;
        }

        SAXException getException() {
            return this.exception;
        }
    }

    static class ValidateStage
    extends XMLReaderImpl {
        private final ContentHandler validator;
        private ContentHandler contentHandler;
        private final XMLReader reader;
        private final CountingErrorHandler ceh;

        ValidateStage(XMLReader xMLReader, Validator validator, CountingErrorHandler countingErrorHandler) {
            this.reader = xMLReader;
            this.validator = validator.getContentHandler();
            this.ceh = countingErrorHandler;
        }

        public void parse(InputSource inputSource) throws SAXException, IOException {
            this.reader.parse(inputSource);
            if (this.ceh.getHadErrorOrFatalError()) {
                throw new SAXException(new IncorrectSchemaException());
            }
        }

        public void setContentHandler(ContentHandler contentHandler) {
            this.contentHandler = contentHandler;
            this.reader.setContentHandler(new ForkContentHandler(this.validator, this.contentHandler));
        }

        public ContentHandler getContentHandler() {
            return this.contentHandler;
        }
    }
}

