/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.options;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.project.classpath.BasePathSupport;
import org.netbeans.modules.php.project.classpath.GlobalIncludePathSupport;
import org.netbeans.modules.php.project.environment.PhpEnvironment;
import org.netbeans.modules.php.project.ui.PathUiSupport;
import org.netbeans.modules.php.project.ui.Utils;
import org.netbeans.modules.php.project.ui.options.Bundle;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public final class PhpOptionsPanel
extends JPanel {
    private static final long serialVersionUID = 10985641247986428L;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JButton addFolderButton;
    private JLabel commandLineLabel;
    private JSeparator commandLineSeparator;
    private JCheckBox editorCheckBox;
    private JLabel errorLabel;
    private JLabel globalIncludePathInfoLabel;
    private JLabel globalIncludePathLabel;
    private JSeparator globalIncludePathSeparator;
    private JList<BasePathSupport.Item> includePathList;
    private JScrollPane includePathScrollPane;
    private JButton moveDownButton;
    private JButton moveUpButton;
    private JLabel openResultInLabel;
    private JCheckBox outputWindowCheckBox;
    private JButton phpInterpreterBrowseButton;
    private JLabel phpInterpreterLabel;
    private JButton phpInterpreterSearchButton;
    private JTextField phpInterpreterTextField;
    private JButton removeButton;
    private JLabel useTheFollowingPathByDefaultLabel;
    private JCheckBox webBrowserCheckBox;

    public PhpOptionsPanel() {
        this.initComponents();
        this.errorLabel.setText(" ");
        this.initPhpGlobalIncludePath();
        DefaultDocumentListener documentListener = new DefaultDocumentListener();
        this.phpInterpreterTextField.getDocument().addDocumentListener(documentListener);
    }

    private void initPhpGlobalIncludePath() {
        DefaultListModel<BasePathSupport.Item> listModel = PathUiSupport.createListModel(GlobalIncludePathSupport.getInstance().itemsIterator());
        PathUiSupport.EditMediator.FileChooserDirectoryHandler directoryHandler = new PathUiSupport.EditMediator.FileChooserDirectoryHandler(){

            @Override
            public String getDirKey() {
                return "nb.php.global.includePath";
            }

            @Override
            public File getCurrentDirectory() {
                return null;
            }
        };
        this.includePathList.setModel(listModel);
        this.includePathList.setCellRenderer(new PathUiSupport.ClassPathListCellRenderer());
        PathUiSupport.EditMediator.register(this.includePathList, this.addFolderButton.getModel(), this.removeButton.getModel(), this.moveUpButton.getModel(), this.moveDownButton.getModel(), directoryHandler);
    }

    public String getPhpInterpreter() {
        return this.phpInterpreterTextField.getText();
    }

    public void setPhpInterpreter(String phpInterpreter) {
        this.phpInterpreterTextField.setText(phpInterpreter);
    }

    public boolean isOpenResultInOutputWindow() {
        return this.outputWindowCheckBox.isSelected();
    }

    public void setOpenResultInOutputWindow(boolean openResultInOutputWindow) {
        this.outputWindowCheckBox.setSelected(openResultInOutputWindow);
    }

    public boolean isOpenResultInBrowser() {
        return this.webBrowserCheckBox.isSelected();
    }

    public void setOpenResultInBrowser(boolean openResultInBrowser) {
        this.webBrowserCheckBox.setSelected(openResultInBrowser);
    }

    public boolean isOpenResultInEditor() {
        return this.editorCheckBox.isSelected();
    }

    public void setOpenResultInEditor(boolean openResultInEditor) {
        this.editorCheckBox.setSelected(openResultInEditor);
    }

    public String getPhpGlobalIncludePath() {
        String[] paths = GlobalIncludePathSupport.getInstance().encodeToStrings(PathUiSupport.getIterator((DefaultListModel)this.includePathList.getModel()));
        StringBuilder path = new StringBuilder(200);
        for (String s : paths) {
            path.append(s);
        }
        return path.toString();
    }

    public void setError(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.errorForeground"));
        this.errorLabel.setText(message);
    }

    public void setWarning(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.warningForeground"));
        this.errorLabel.setText(message);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    private Integer parseInteger(String input) {
        Integer number = null;
        try {
            number = Integer.parseInt(input);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return number;
    }

    private void initComponents() {
        this.commandLineSeparator = new JSeparator();
        this.commandLineLabel = new JLabel();
        this.phpInterpreterLabel = new JLabel();
        this.phpInterpreterTextField = new JTextField();
        this.phpInterpreterBrowseButton = new JButton();
        this.phpInterpreterSearchButton = new JButton();
        this.openResultInLabel = new JLabel();
        this.outputWindowCheckBox = new JCheckBox();
        this.webBrowserCheckBox = new JCheckBox();
        this.editorCheckBox = new JCheckBox();
        this.globalIncludePathSeparator = new JSeparator();
        this.globalIncludePathLabel = new JLabel();
        this.useTheFollowingPathByDefaultLabel = new JLabel();
        this.includePathScrollPane = new JScrollPane();
        this.includePathList = new JList();
        this.addFolderButton = new JButton();
        this.removeButton = new JButton();
        this.moveUpButton = new JButton();
        this.moveDownButton = new JButton();
        this.globalIncludePathInfoLabel = new JLabel();
        this.errorLabel = new JLabel();
        this.commandLineLabel.setLabelFor(this);
        Mnemonics.setLocalizedText((JLabel)this.commandLineLabel, (String)NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_CommandLine"));
        this.phpInterpreterLabel.setLabelFor(this.phpInterpreterTextField);
        Mnemonics.setLocalizedText((JLabel)this.phpInterpreterLabel, (String)NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_PhpInterpreter"));
        Mnemonics.setLocalizedText((AbstractButton)this.phpInterpreterBrowseButton, (String)NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_Browse"));
        this.phpInterpreterBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhpOptionsPanel.this.phpInterpreterBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.phpInterpreterSearchButton, (String)NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_Search"));
        this.phpInterpreterSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhpOptionsPanel.this.phpInterpreterSearchButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.openResultInLabel, (String)NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_OpenResultIn"));
        Mnemonics.setLocalizedText((AbstractButton)this.outputWindowCheckBox, (String)NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_OutputWindow"));
        Mnemonics.setLocalizedText((AbstractButton)this.webBrowserCheckBox, (String)NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_WebBrowser"));
        Mnemonics.setLocalizedText((AbstractButton)this.editorCheckBox, (String)NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_Editor"));
        this.globalIncludePathLabel.setLabelFor(this);
        Mnemonics.setLocalizedText((JLabel)this.globalIncludePathLabel, (String)NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_GlobalIncludePath"));
        this.useTheFollowingPathByDefaultLabel.setLabelFor(this.includePathList);
        Mnemonics.setLocalizedText((JLabel)this.useTheFollowingPathByDefaultLabel, (String)NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_UseTheFollowingPathByDefault"));
        this.includePathScrollPane.setViewportView(this.includePathList);
        this.includePathList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.includePathList.AccessibleContext.accessibleName"));
        this.includePathList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.includePathList.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.addFolderButton, (String)NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_AddFolder"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_Remove"));
        Mnemonics.setLocalizedText((AbstractButton)this.moveUpButton, (String)NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_MoveUp"));
        Mnemonics.setLocalizedText((AbstractButton)this.moveDownButton, (String)NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_MoveDown"));
        Mnemonics.setLocalizedText((JLabel)this.globalIncludePathInfoLabel, (String)NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.globalIncludePathInfoLabel.text"));
        this.errorLabel.setLabelFor(this);
        Mnemonics.setLocalizedText((JLabel)this.errorLabel, (String)"ERROR");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.commandLineLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.commandLineSeparator)).addGroup(layout.createSequentialGroup().addComponent(this.globalIncludePathLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.globalIncludePathSeparator)).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.phpInterpreterLabel).addComponent(this.openResultInLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.phpInterpreterTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.phpInterpreterBrowseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.phpInterpreterSearchButton)).addGroup(layout.createSequentialGroup().addComponent(this.outputWindowCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.webBrowserCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editorCheckBox)))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.includePathScrollPane).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.addFolderButton).addComponent(this.removeButton).addComponent(this.moveUpButton).addComponent(this.moveDownButton))).addComponent(this.useTheFollowingPathByDefaultLabel))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.errorLabel).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.globalIncludePathInfoLabel, -2, -1, -2))).addGap(0, 0, Short.MAX_VALUE)));
        layout.linkSize(0, this.addFolderButton, this.moveDownButton, this.moveUpButton, this.removeButton);
        layout.linkSize(0, this.phpInterpreterBrowseButton, this.phpInterpreterSearchButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.commandLineLabel).addComponent(this.commandLineSeparator, -2, 10, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.phpInterpreterBrowseButton).addComponent(this.phpInterpreterTextField, -2, -1, -2).addComponent(this.phpInterpreterSearchButton).addComponent(this.phpInterpreterLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.outputWindowCheckBox).addComponent(this.webBrowserCheckBox).addComponent(this.editorCheckBox).addComponent(this.openResultInLabel)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.globalIncludePathLabel).addComponent(this.globalIncludePathSeparator, -2, 10, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.useTheFollowingPathByDefaultLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.addFolderButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.moveUpButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.moveDownButton)).addComponent(this.includePathScrollPane)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.globalIncludePathInfoLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.errorLabel)));
        this.commandLineSeparator.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.commandLineSeparator.AccessibleContext.accessibleName_1"));
        this.commandLineSeparator.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.commandLineSeparator.AccessibleContext.accessibleDescription_1"));
        this.commandLineLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.commandLineLabel.AccessibleContext.accessibleName"));
        this.commandLineLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.commandLineLabel.AccessibleContext.accessibleDescription"));
        this.phpInterpreterLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.phpInterpreterLabel.AccessibleContext.accessibleName"));
        this.phpInterpreterLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.phpInterpreterLabel.AccessibleContext.accessibleDescription"));
        this.phpInterpreterTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.phpInterpreterTextField.AccessibleContext.accessibleName"));
        this.phpInterpreterTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.phpInterpreterTextField.AccessibleContext.accessibleDescription"));
        this.phpInterpreterBrowseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.browseButton.AccessibleContext.accessibleName"));
        this.phpInterpreterBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.browseButton.AccessibleContext.accessibleDescription"));
        this.phpInterpreterSearchButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.searchButton.AccessibleContext.accessibleName"));
        this.phpInterpreterSearchButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.searchButton.AccessibleContext.accessibleDescription"));
        this.openResultInLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.openResultInLabel.AccessibleContext.accessibleName"));
        this.openResultInLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.openResultInLabel.AccessibleContext.accessibleDescription"));
        this.outputWindowCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.outputWindowCheckBox.AccessibleContext.accessibleName"));
        this.outputWindowCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.outputWindowCheckBox.AccessibleContext.accessibleDescription"));
        this.webBrowserCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.webBrowserCheckBox.AccessibleContext.accessibleName"));
        this.webBrowserCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.webBrowserCheckBox.AccessibleContext.accessibleDescription"));
        this.editorCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.editorCheckBox.AccessibleContext.accessibleName"));
        this.editorCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.editorCheckBox.AccessibleContext.accessibleDescription"));
        this.globalIncludePathSeparator.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.globalIncludePathSeparator.AccessibleContext.accessibleName_1"));
        this.globalIncludePathSeparator.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.globalIncludePathSeparator.AccessibleContext.accessibleDescription_1"));
        this.globalIncludePathLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.globalIncludePathLabel.AccessibleContext.accessibleName"));
        this.globalIncludePathLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.globalIncludePathLabel.AccessibleContext.accessibleDescription"));
        this.useTheFollowingPathByDefaultLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.useTheFollowingPathByDefaultLabel.AccessibleContext.accessibleName"));
        this.useTheFollowingPathByDefaultLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.useTheFollowingPathByDefaultLabel.AccessibleContext.accessibleDescription"));
        this.includePathScrollPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.includePathScrollPane.AccessibleContext.accessibleName"));
        this.includePathScrollPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.includePathScrollPane.AccessibleContext.accessibleDescription"));
        this.addFolderButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.addFolderButton.AccessibleContext.accessibleName"));
        this.addFolderButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.addFolderButton.AccessibleContext.accessibleDescription"));
        this.removeButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.removeButton.AccessibleContext.accessibleName"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.removeButton.AccessibleContext.accessibleDescription"));
        this.moveUpButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.moveUpButton.AccessibleContext.accessibleName"));
        this.moveUpButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.moveUpButton.AccessibleContext.accessibleDescription"));
        this.moveDownButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.moveDownButton.AccessibleContext.accessibleName"));
        this.moveDownButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.moveDownButton.AccessibleContext.accessibleDescription"));
        this.errorLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.errorLabel.AccessibleContext.accessibleName"));
        this.errorLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.errorLabel.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpOptionsPanel.class, (String)"PhpOptionsPanel.AccessibleContext.accessibleDescription"));
    }

    private void phpInterpreterBrowseButtonActionPerformed(ActionEvent evt) {
        File file = Utils.browseFileAction("nb.php.interpreter", Bundle.PhpOptionsPanel_interpreter_browse_title());
        if (file != null) {
            this.phpInterpreterTextField.setText(file.getAbsolutePath());
        }
    }

    private void phpInterpreterSearchButtonActionPerformed(ActionEvent evt) {
        String phpInterpreter = UiUtils.SearchWindow.search((UiUtils.SearchWindow.SearchWindowSupport)new UiUtils.SearchWindow.SearchWindowSupport(){

            public List<String> detect() {
                return PhpEnvironment.get().getAllPhpInterpreters();
            }

            public String getWindowTitle() {
                return NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_PhpInterpretersTitle");
            }

            public String getListTitle() {
                return NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_PhpInterpreters");
            }

            public String getPleaseWaitPart() {
                return NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_PhpInterpretersPleaseWaitPart");
            }

            public String getNoItemsFound() {
                return NbBundle.getMessage(PhpOptionsPanel.class, (String)"LBL_NoPhpInterpretersFound");
            }
        });
        if (phpInterpreter != null) {
            this.phpInterpreterTextField.setText(phpInterpreter);
        }
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        private void processUpdate() {
            PhpOptionsPanel.this.fireChange();
        }
    }
}

