/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.customizer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.PhpVisibilityQuery;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.connections.ConfigManager;
import org.netbeans.modules.php.project.runconfigs.RunConfigLocal;
import org.netbeans.modules.php.project.runconfigs.validation.RunConfigLocalValidator;
import org.netbeans.modules.php.project.ui.Utils;
import org.netbeans.modules.php.project.ui.customizer.Bundle;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.modules.php.project.ui.customizer.RunAsPanel;
import org.netbeans.modules.php.project.ui.customizer.RunAsWebAdvanced;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.Pair;

public class RunAsLocalWeb
extends RunAsPanel.InsidePanel {
    private static final long serialVersionUID = 7891231321100L;
    private final PhpProjectProperties properties;
    private final PhpProject project;
    private final JLabel[] labels;
    private final JTextField[] textFields;
    private final String[] propertyNames;
    final ProjectCustomizer.Category category;
    private JButton advancedButton;
    private JLabel argsLabel;
    private JTextField argsTextField;
    private JTextPane hintLabel;
    private JButton indexFileBrowseButton;
    private JLabel indexFileLabel;
    private JTextField indexFileTextField;
    private JComboBox<String> runAsCombo;
    private JLabel runAsLabel;
    private JLabel urlLabel;
    private JTextField urlTextField;

    public RunAsLocalWeb(PhpProjectProperties properties, ConfigManager manager, ProjectCustomizer.Category category) {
        super(manager);
        this.properties = properties;
        this.category = category;
        this.project = properties.getProject();
        this.initComponents();
        this.labels = new JLabel[]{this.urlLabel, this.indexFileLabel, this.argsLabel};
        this.textFields = new JTextField[]{this.urlTextField, this.indexFileTextField, this.argsTextField};
        this.propertyNames = new String[]{"url", "index.file", "script.arguments"};
        assert (this.labels.length == this.textFields.length && this.labels.length == this.propertyNames.length);
        for (int i = 0; i < this.textFields.length; ++i) {
            FieldUpdater dl = new FieldUpdater(this.propertyNames[i], this.labels[i], this.textFields[i]);
            this.textFields[i].getDocument().addDocumentListener(dl);
        }
    }

    @Override
    protected boolean isDefault() {
        return true;
    }

    @Override
    protected PhpProjectProperties.RunAsType getRunAsType() {
        return RunConfigLocal.getRunAsType();
    }

    @Override
    public String getDisplayName() {
        return RunConfigLocal.getDisplayName();
    }

    @Override
    protected JLabel getRunAsLabel() {
        return this.runAsLabel;
    }

    @Override
    public JComboBox<String> getRunAsCombo() {
        return this.runAsCombo;
    }

    @Override
    protected void loadFields() {
        for (int i = 0; i < this.textFields.length; ++i) {
            this.textFields[i].setText(this.getValue(this.propertyNames[i]));
        }
    }

    @Override
    protected void validateFields() {
        this.category.setErrorMessage(RunConfigLocalValidator.validateCustomizer(this.createRunConfig()));
        this.category.setValid(true);
    }

    private RunConfigLocal createRunConfig() {
        return (RunConfigLocal)((RunConfigLocal)((RunConfigLocal)((RunConfigLocal)RunConfigLocal.create().setUrl(this.urlTextField.getText())).setIndexParentDir(this.getWebRoot())).setIndexRelativePath(this.indexFileTextField.getText())).setArguments(this.argsTextField.getText());
    }

    private File getWebRoot() {
        return ProjectPropertiesSupport.getSourceSubdirectory(this.project, this.properties.getWebRoot());
    }

    private void initComponents() {
        this.runAsLabel = new JLabel();
        this.runAsCombo = new JComboBox();
        this.urlLabel = new JLabel();
        this.urlTextField = new JTextField();
        this.indexFileLabel = new JLabel();
        this.indexFileTextField = new JTextField();
        this.indexFileBrowseButton = new JButton();
        this.argsLabel = new JLabel();
        this.argsTextField = new JTextField();
        this.hintLabel = new JTextPane();
        this.advancedButton = new JButton();
        this.runAsLabel.setLabelFor(this.runAsCombo);
        Mnemonics.setLocalizedText((JLabel)this.runAsLabel, (String)NbBundle.getMessage(RunAsLocalWeb.class, (String)"LBL_RunAs"));
        this.urlLabel.setLabelFor(this.urlTextField);
        Mnemonics.setLocalizedText((JLabel)this.urlLabel, (String)NbBundle.getMessage(RunAsLocalWeb.class, (String)"LBL_ProjectUrl"));
        this.urlTextField.setColumns(20);
        this.indexFileLabel.setLabelFor(this.indexFileTextField);
        Mnemonics.setLocalizedText((JLabel)this.indexFileLabel, (String)NbBundle.getMessage(RunAsLocalWeb.class, (String)"LBL_IndexFile"));
        Mnemonics.setLocalizedText((AbstractButton)this.indexFileBrowseButton, (String)NbBundle.getMessage(RunAsLocalWeb.class, (String)"LBL_Browse"));
        this.indexFileBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunAsLocalWeb.this.indexFileBrowseButtonActionPerformed(evt);
            }
        });
        this.argsLabel.setLabelFor(this.argsTextField);
        Mnemonics.setLocalizedText((JLabel)this.argsLabel, (String)NbBundle.getMessage(RunAsLocalWeb.class, (String)"LBL_Arguments"));
        this.argsTextField.setColumns(20);
        this.hintLabel.setEditable(false);
        this.hintLabel.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.hintLabel.setBorder(null);
        this.hintLabel.setFocusable(false);
        Mnemonics.setLocalizedText((AbstractButton)this.advancedButton, (String)NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.advancedButton.text"));
        this.advancedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunAsLocalWeb.this.advancedButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.advancedButton)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.argsLabel).addComponent(this.urlLabel).addComponent(this.indexFileLabel).addComponent(this.runAsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.hintLabel).addComponent(this.argsTextField, GroupLayout.Alignment.TRAILING, -2, 0, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.indexFileTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.indexFileBrowseButton)).addComponent(this.runAsCombo, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addComponent(this.urlTextField, GroupLayout.Alignment.TRAILING, -2, 0, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.runAsCombo, -2, -1, -2).addComponent(this.runAsLabel)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.urlLabel).addComponent(this.urlTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.indexFileBrowseButton).addComponent(this.indexFileTextField, -2, -1, -2).addComponent(this.indexFileLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.argsLabel).addComponent(this.argsTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hintLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.advancedButton)));
        this.runAsLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.runAsLabel.AccessibleContext.accessibleName"));
        this.runAsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.runAsLabel.AccessibleContext.accessibleDescription"));
        this.runAsCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.runAsCombo.AccessibleContext.accessibleName"));
        this.runAsCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.runAsCombo.AccessibleContext.accessibleDescription"));
        this.urlLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.urlLabel.AccessibleContext.accessibleName"));
        this.urlLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.urlLabel.AccessibleContext.accessibleDescription"));
        this.urlTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.urlTextField.AccessibleContext.accessibleName"));
        this.urlTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.urlTextField.AccessibleContext.accessibleDescription"));
        this.indexFileLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.indexFileLabel.AccessibleContext.accessibleName"));
        this.indexFileLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.indexFileLabel.AccessibleContext.accessibleDescription"));
        this.indexFileTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.indexFileTextField.AccessibleContext.accessibleName"));
        this.indexFileTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.indexFileTextField.AccessibleContext.accessibleDescription"));
        this.indexFileBrowseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.indexFileBrowseButton.AccessibleContext.accessibleName"));
        this.indexFileBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.indexFileBrowseButton.AccessibleContext.accessibleDescription"));
        this.argsLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.argsLabel.AccessibleContext.accessibleName"));
        this.argsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.argsLabel.AccessibleContext.accessibleDescription"));
        this.argsTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.argsTextField.AccessibleContext.accessibleName"));
        this.argsTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.argsTextField.AccessibleContext.accessibleDescription"));
        this.hintLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.jTextPane1.AccessibleContext.accessibleName"));
        this.hintLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.jTextPane1.AccessibleContext.accessibleDescription"));
        this.advancedButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.advancedButton.AccessibleContext.accessibleName"));
        this.advancedButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.advancedButton.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.AccessibleContext.accessibleDescription"));
    }

    private void indexFileBrowseButtonActionPerformed(ActionEvent evt) {
        try {
            Utils.browseFolderFile(PhpVisibilityQuery.forProject(this.project), this.getWebRoot(), this.indexFileTextField);
        }
        catch (FileNotFoundException ex) {
            this.category.setErrorMessage(Bundle.RunAsLocalWeb_webRoot_notFound());
            this.category.setValid(true);
        }
    }

    private void advancedButtonActionPerformed(ActionEvent evt) {
        RunAsWebAdvanced.Properties props = new RunAsWebAdvanced.Properties(this.getValue("debug.url"), this.hintLabel.getText(), this.getValue("debug.path.mapping.remote"), this.getValue("debug.path.mapping.local"), this.getValue("debug.proxy.host"), this.getValue("debug.proxy.port"));
        RunAsWebAdvanced advanced = new RunAsWebAdvanced(this.project, props);
        if (advanced.open()) {
            Pair<String, String> pathMapping = advanced.getPathMapping();
            Pair<String, String> debugProxy = advanced.getDebugProxy();
            this.putValue("debug.url", advanced.getDebugUrl().name());
            this.putValue("debug.path.mapping.remote", (String)pathMapping.first());
            this.putValue("debug.path.mapping.local", (String)pathMapping.second());
            this.putValue("debug.proxy.host", (String)debugProxy.first());
            this.putValue("debug.proxy.port", (String)debugProxy.second());
        }
    }

    private class FieldUpdater
    extends RunAsPanel.InsidePanel.TextFieldUpdater {
        public FieldUpdater(String propName, JLabel label, JTextField field) {
            super(RunAsLocalWeb.this, propName, label, field);
        }

        @Override
        protected final String getDefaultValue() {
            return RunAsLocalWeb.this.getDefaultValue(this.getPropName());
        }

        @Override
        protected void processUpdate() {
            super.processUpdate();
            RunAsLocalWeb.this.hintLabel.setText(RunAsLocalWeb.this.createRunConfig().getUrlHint());
        }
    }
}

