/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions;

import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ui.actions.Command;
import org.netbeans.modules.php.project.ui.actions.RunProjectCommand;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.ui.actions.support.ConfigAction;
import org.netbeans.modules.php.project.ui.actions.support.Displayable;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class RunFileCommand
extends Command
implements Displayable {
    public static final String ID = "run.single";
    public static final String DISPLAY_NAME = RunProjectCommand.DISPLAY_NAME;

    public RunFileCommand(PhpProject project) {
        super(project);
    }

    @Override
    public void invokeActionInternal(Lookup context) {
        FileObject fileObj = CommandUtils.fileForContextOrSelectedNodes(context);
        if (this.isSeleniumFile(fileObj)) {
            ConfigAction.get(ConfigAction.Type.SELENIUM, this.getProject()).runFile(context);
        } else if (this.isTestFile(fileObj)) {
            ConfigAction.get(ConfigAction.Type.TEST, this.getProject()).runFile(context);
        } else {
            ConfigAction configAction = this.getConfigAction();
            if (!configAction.isFileValid()) {
                return;
            }
            configAction.runFile(context);
        }
    }

    @Override
    public boolean isActionEnabledInternal(Lookup context) {
        FileObject fileObj = CommandUtils.fileForContextOrSelectedNodes(context);
        if (this.isSeleniumFile(fileObj)) {
            return ConfigAction.get(ConfigAction.Type.SELENIUM, this.getProject()).isRunFileEnabled(context);
        }
        if (this.isTestFile(fileObj)) {
            return ConfigAction.get(ConfigAction.Type.TEST, this.getProject()).isRunFileEnabled(context);
        }
        return this.getConfigAction().isRunFileEnabled(context);
    }

    @Override
    public String getCommandId() {
        return ID;
    }

    @Override
    public String getDisplayName() {
        return DISPLAY_NAME;
    }
}

