/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.internalserver;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.php.api.executable.InvalidPhpExecutableException;
import org.netbeans.modules.php.api.executable.PhpExecutable;
import org.netbeans.modules.php.api.executable.PhpInterpreter;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.internalserver.Bundle;
import org.netbeans.modules.php.project.runconfigs.RunConfigInternal;
import org.netbeans.modules.php.project.runconfigs.validation.RunConfigInternalValidator;
import org.netbeans.modules.php.project.ui.actions.support.FileRunner;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public final class InternalWebServer
implements PropertyChangeListener {
    private static final Logger LOGGER = Logger.getLogger(InternalWebServer.class.getName());
    private static InternalWebServer runningInstance;
    private static final String WEB_SERVER_PARAM = "-S";
    private static final String DOCUMENT_ROOT_PARAM = "-t";
    private static final Set<String> RELATED_EVENT_NAMES;
    private final PhpProject project;
    private Future<Integer> process = null;

    private InternalWebServer(PhpProject project) {
        this.project = project;
    }

    public static InternalWebServer createForProject(PhpProject project) {
        InternalWebServer server = new InternalWebServer(project);
        ProjectPropertiesSupport.getPropertyEvaluator(project).addPropertyChangeListener((PropertyChangeListener)server);
        ProjectPropertiesSupport.addProjectPropertyChangeListener(project, server);
        return server;
    }

    static synchronized void startingInstance(InternalWebServer serverToBeStarted) {
        InternalWebServer instanceRef;
        if (runningInstance != null && runningInstance != serverToBeStarted && !InternalWebServer.ensureServerStopped(instanceRef = runningInstance)) {
            InternalWebServer.warnUser(instanceRef.project.getName(), Bundle.InternalWebServer_error_stop());
        }
        runningInstance = serverToBeStarted;
    }

    static synchronized void stoppingInstance(InternalWebServer serverToBeStopped) {
        if (serverToBeStopped == runningInstance) {
            runningInstance = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static boolean ensureServerStopped(InternalWebServer instance) {
        assert (!EventQueue.isDispatchThread());
        ProgressHandle progressHandle = ProgressHandle.createHandle((String)Bundle.InternalWebServer_stopping(instance.project.getName()));
        try {
            progressHandle.start();
            instance.stop();
            RunConfigInternal runConfig = RunConfigInternal.forProject(instance.project);
            String host = runConfig.getHostname();
            int port = Integer.parseInt(runConfig.getPort());
            for (int i = 0; i < 20; ++i) {
                try {
                    Socket socket = new Socket(host, port);
                    socket.close();
                    Thread.sleep(200L);
                    continue;
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                catch (UnknownHostException ex) {
                    boolean bl = true;
                    progressHandle.finish();
                    return bl;
                }
                catch (IOException ex) {
                    boolean bl = true;
                    progressHandle.finish();
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            progressHandle.finish();
        }
    }

    private static void warnUser(String title, String message) {
        DialogDisplayer.getDefault().notifyLater(new NotifyDescriptor((Object)message, title, -1, 2, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION));
    }

    public synchronized boolean isRunning() {
        return this.process != null && !this.process.isDone();
    }

    public synchronized boolean start() {
        if (this.isRunning()) {
            LOGGER.log(Level.FINE, "Internal web server already running for project {0}", this.project.getName());
            return true;
        }
        this.process = this.createProcess();
        return this.isRunning();
    }

    public synchronized void stop() {
        if (this.isRunning() && !this.process.cancel(true)) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.InternalWebServer_error_cancelProcess(this.project.getName()), 2));
        }
        InternalWebServer.stoppingInstance(this);
        this.reset();
    }

    public synchronized void restart() {
        this.stop();
        this.start();
    }

    void reset() {
        assert (Thread.holdsLock(this));
        this.process = null;
    }

    private Future<Integer> createProcess() {
        PhpInterpreter phpInterpreter;
        try {
            phpInterpreter = PhpInterpreter.getDefault();
        }
        catch (InvalidPhpExecutableException ex) {
            UiUtils.invalidScriptProvided((String)ex.getLocalizedMessage());
            return null;
        }
        RunConfigInternal runConfig = RunConfigInternal.forProject(this.project);
        if (RunConfigInternalValidator.validateCustomizer(runConfig) != null) {
            PhpProjectUtils.openCustomizerRun(this.project);
            return null;
        }
        return new PhpExecutable(phpInterpreter.getInterpreter()).viaAutodetection(false).viaPhpInterpreter(false).workDir(runConfig.getWorkDir()).additionalParameters(this.getParameters(runConfig)).displayName(Bundle.InternalWebServer_output_title(this.project.getName())).run(this.getDescriptor());
    }

    @Override
    public synchronized void propertyChange(PropertyChangeEvent evt) {
        if (!this.isRunning()) {
            return;
        }
        if (RELATED_EVENT_NAMES.contains(evt.getPropertyName())) {
            this.restart();
        }
    }

    public String toString() {
        return "InternalWebServer[" + this.project.getName() + "]";
    }

    private List<String> getParameters(RunConfigInternal runConfig) {
        String routerRelativePath;
        ArrayList<String> params = new ArrayList<String>(3);
        params.add(WEB_SERVER_PARAM);
        params.add(runConfig.getServer());
        String relativeDocumentRoot = runConfig.getRelativeDocumentRoot();
        if (relativeDocumentRoot != null) {
            params.add(DOCUMENT_ROOT_PARAM);
            params.add(relativeDocumentRoot);
        }
        if (StringUtils.hasText((String)(routerRelativePath = runConfig.getRouterRelativePath()))) {
            params.add(routerRelativePath);
        }
        return params;
    }

    private ExecutionDescriptor getDescriptor() {
        return PhpExecutable.DEFAULT_EXECUTION_DESCRIPTOR.showSuspended(true).optionsPath("org-netbeans-modules-php-project-ui-options-PHPOptionsCategory/General").outConvertorFactory(FileRunner.PHP_LINE_CONVERTOR_FACTORY).preExecution(new Runnable(){

            @Override
            public void run() {
                InternalWebServer.startingInstance(InternalWebServer.this);
            }
        });
    }

    static {
        RELATED_EVENT_NAMES = new HashSet<String>(Arrays.asList("webRoot", "hostname", "port", "router"));
    }
}

