/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.ui.transfer.tree;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.netbeans.modules.php.project.connections.ui.transfer.tree.TransferSelectorModel;
import org.openide.explorer.view.NodeRenderer;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Node;

final class CheckRenderer
extends JPanel
implements TreeCellRenderer {
    private static final long serialVersionUID = 945937593475L;
    private static final Dimension CHECK_DIM;
    private final NodeRenderer nodeRenderer;
    private final TransferSelectorModel model;
    private final JCheckBox check = new JCheckBox();
    private static Rectangle checkBounds;
    private Component stringDisplayer = new JLabel(" ");

    public CheckRenderer(TransferSelectorModel model) {
        assert (model != null);
        this.model = model;
        this.nodeRenderer = new NodeRenderer();
        this.setLayout(null);
        this.add(this.check);
        this.check.setOpaque(false);
        this.check.setPreferredSize(CHECK_DIM);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.stringDisplayer = this.nodeRenderer.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, hasFocus);
        TreePath path = tree.getPathForRow(row);
        if (path != null && path.getPathCount() == 1) {
            return this.stringDisplayer;
        }
        if (this.stringDisplayer instanceof JComponent) {
            this.setToolTipText(((JComponent)this.stringDisplayer).getToolTipText());
        }
        if (this.stringDisplayer.getBackground() == null) {
            this.stringDisplayer.setBackground(tree.getBackground());
        }
        if (this.stringDisplayer.getForeground() == null) {
            this.stringDisplayer.setForeground(tree.getForeground());
        }
        Node node = value instanceof Node ? (Node)value : Visualizer.findNode((Object)value);
        this.check.setSelected(node == null || this.model.isNodeSelected(node));
        boolean partiallySelected = node != null && this.model.isNodePartiallySelected(node);
        this.check.getModel().setPressed(partiallySelected);
        this.check.getModel().setArmed(partiallySelected);
        this.check.setEnabled(true);
        return this;
    }

    @Override
    public void paintComponent(Graphics g) {
        Dimension dCheck = this.check.getSize();
        Dimension dLabel = this.stringDisplayer.getPreferredSize();
        int yLabel = 0;
        if (dCheck.height >= dLabel.height) {
            yLabel = (dCheck.height - dLabel.height) / 2;
        }
        this.check.setBounds(0, 0, dCheck.width, dCheck.height);
        this.check.paint(g);
        int y = yLabel - 2;
        this.stringDisplayer.setBounds(dCheck.width, y, dLabel.width, this.getHeight() - 1);
        g.translate(dCheck.width, yLabel);
        this.stringDisplayer.paint(g);
        g.translate(-dCheck.width, -yLabel);
    }

    @Override
    public Dimension getPreferredSize() {
        this.stringDisplayer.setFont(this.getFont());
        Dimension dCheck = this.check.getPreferredSize();
        Dimension dLabel = this.stringDisplayer.getPreferredSize();
        return new Dimension(dCheck.width + dLabel.width, dCheck.height < dLabel.height ? dLabel.height : dCheck.height);
    }

    @Override
    public void doLayout() {
        Dimension dCheck = this.check.getPreferredSize();
        Dimension dLabel = this.stringDisplayer.getPreferredSize();
        int yCheck = 0;
        if (dCheck.height < dLabel.height) {
            yCheck = (dLabel.height - dCheck.height) / 2;
        }
        this.check.setLocation(0, yCheck);
        this.check.setBounds(0, yCheck, dCheck.width, dCheck.height);
        if (checkBounds == null) {
            checkBounds = this.check.getBounds();
        }
    }

    public static Rectangle getCheckBoxRectangle() {
        if (checkBounds == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        return (Rectangle)checkBounds.clone();
    }

    static {
        Dimension old = new JCheckBox().getPreferredSize();
        CHECK_DIM = new Dimension(old.width, old.height - 5);
    }
}

