/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.common;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.connections.common.Bundle;
import org.openide.util.NbBundle;

public final class RemoteValidator {
    public static final int MINIMUM_PORT = 0;
    public static final int MAXIMUM_PORT = 65535;
    public static final String INVALID_SEPARATOR = "\\";

    private RemoteValidator() {
    }

    public static String validateIp(String externalIp) {
        try {
            InetAddress.getAllByName(externalIp);
        }
        catch (UnknownHostException ex) {
            return NbBundle.getMessage(RemoteValidator.class, (String)"MSG_NoIpAddress");
        }
        return null;
    }

    public static String validateHost(String host) {
        if (!StringUtils.hasText((String)host)) {
            return NbBundle.getMessage(RemoteValidator.class, (String)"MSG_NoHostName");
        }
        if (host.contains(" ")) {
            return NbBundle.getMessage(RemoteValidator.class, (String)"MSG_HostNameSpaces");
        }
        return null;
    }

    public static String validateUser(String username) {
        if (!StringUtils.hasText((String)username)) {
            return NbBundle.getMessage(RemoteValidator.class, (String)"MSG_NoUserName");
        }
        return null;
    }

    public static String validatePort(String port) {
        String err = null;
        try {
            int p = Integer.parseInt(port);
            if (p < 0 || p > 65535) {
                err = NbBundle.getMessage(RemoteValidator.class, (String)"MSG_PortInvalid", (Object)String.valueOf(0), (Object)String.valueOf(65535));
            }
        }
        catch (NumberFormatException nfe) {
            err = NbBundle.getMessage(RemoteValidator.class, (String)"MSG_PortNotNumeric");
        }
        return err;
    }

    public static String validateTimeout(String timeout) {
        return RemoteValidator.validatePositiveNumber(timeout, Bundle.MSG_TimeoutNotPositive(), Bundle.MSG_TimeoutNotNumeric());
    }

    public static String validateKeepAliveInterval(String keepAliveInterval) {
        return RemoteValidator.validatePositiveNumber(keepAliveInterval, Bundle.MSG_KeepAliveNotPositive(), Bundle.MSG_KeepAliveNotNumeric());
    }

    public static String validateUploadDirectory(String uploadDirectory) {
        if (!StringUtils.hasText((String)uploadDirectory)) {
            return Bundle.RemoteValidator_error_uploadDirectory_missing();
        }
        if (!uploadDirectory.startsWith("/")) {
            return Bundle.RemoteValidator_error_uploadDirectory_start("/");
        }
        if (uploadDirectory.contains(INVALID_SEPARATOR)) {
            return Bundle.RemoteValidator_error_uploadDirectory_content(INVALID_SEPARATOR);
        }
        return null;
    }

    static String validatePositiveNumber(String number, String errorNotPositive, String errorNotNumeric) {
        String err = null;
        try {
            int t = Integer.parseInt(number);
            if (t < 0) {
                err = errorNotPositive;
            }
        }
        catch (NumberFormatException nfe) {
            err = errorNotNumeric;
        }
        return err;
    }
}

