/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.support;

import com.sun.source.util.TreePath;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.tools.Diagnostic;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.friendapi.OverrideErrorMessage;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.modules.jshell.support.Bundle;
import org.netbeans.spi.editor.hints.Fix;

public class LocationSuppressRule
implements OverrideErrorMessage {
    private static final Set ALL_CODES = new HashSet<String>(Arrays.asList("*"));
    private static final Pattern LOCATION_LINE = Pattern.compile("^\\p{Space}*location:\\p{Space}*(.+)", 8);

    public String createMessage(CompilationInfo info, Diagnostic d, int offset, TreePath treePath, ErrorRule.Data data) {
        String msg = d.getMessage(null);
        Matcher m = LOCATION_LINE.matcher(msg);
        if (!m.find()) {
            return null;
        }
        String location = m.group(1);
        int idx = location.indexOf("$JShell$");
        if (idx == -1 && (idx = location.indexOf("$JSHELL$")) == -1) {
            return null;
        }
        String[] components = location.substring(idx).split("\\.");
        String last = components[components.length - 1];
        if (last.startsWith("$JShell$") || last.startsWith("$JSHELL$")) {
            return msg.substring(0, m.start(0));
        }
        return msg.substring(0, m.start(0)) + Bundle.Format_Location(last) + msg.substring(m.end(0));
    }

    public Set getCodes() {
        return ALL_CODES;
    }

    public List<Fix> run(CompilationInfo compilationInfo, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data data) {
        return null;
    }

    public String getId() {
        return this.getClass().getName();
    }

    public String getDisplayName() {
        return null;
    }

    public void cancel() {
    }
}

