/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.model;

import java.util.Collection;
import java.util.EnumSet;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.jshell.parsing.JShellLexer;
import org.netbeans.spi.lexer.EmbeddingPresence;
import org.netbeans.spi.lexer.LanguageEmbedding;
import org.netbeans.spi.lexer.LanguageHierarchy;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerRestartInfo;

public enum JShellToken implements TokenId
{
    PROMPT("prompt", "-> "),
    CONTINUATION_PROMPT("prompt", "->> "),
    MESSAGE_MARK("delimiter", "|  "),
    MESSAGE_TEXT("message"),
    ERROR_MARKER("mark-error"),
    JAVA("java"),
    COMMAND("command"),
    COMMAND_WHITESPACE("command-whitespace"),
    COMMAND_PARAM("command-text"),
    COMMAND_STRING("command-string"),
    COMMAND_OPTION("command-option"),
    ERR_COMMAND("error"),
    OUTPUT("output"),
    WHITESPACE("whitespace");

    private static final Language<JShellToken> lang;
    private final String prim;
    private final String text;

    public String primaryCategory() {
        return this.prim;
    }

    public static Language<JShellToken> language() {
        return lang;
    }

    private JShellToken(String prim) {
        this.prim = prim;
        this.text = null;
    }

    private JShellToken(String prim, String text) {
        this.prim = prim;
        this.text = text;
    }

    public String fixedText() {
        return this.text;
    }

    static {
        lang = new LanguageHierarchy<JShellToken>(){

            protected Collection<JShellToken> createTokenIds() {
                return EnumSet.allOf(JShellToken.class);
            }

            protected Lexer<JShellToken> createLexer(LexerRestartInfo<JShellToken> info) {
                return new JShellLexer(info);
            }

            protected String mimeType() {
                return "text/x-repl";
            }

            protected LanguageEmbedding<?> embedding(Token<JShellToken> token, LanguagePath languagePath, InputAttributes inputAttributes) {
                if (token.id() != JAVA) {
                    return null;
                }
                return LanguageEmbedding.create((Language)JavaTokenId.language(), (int)0, (int)0, (boolean)true);
            }

            protected EmbeddingPresence embeddingPresence(JShellToken id) {
                return id == JAVA ? EmbeddingPresence.CACHED_FIRST_QUERY : EmbeddingPresence.NONE;
            }
        }.language();
    }
}

