/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.logging;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.startup.logging.NbLogging;
import org.openide.util.RequestProcessor;

public final class PrintStreamLogger
extends PrintStream
implements Runnable {
    static final int BUFFER_THRESHOLD = 0x200000;
    private static final int BUFFER_MIN_CAPACITY = 0x100000;
    static final int BUFFER_SHRINK_TIME = 10000;
    private static final int BUFFER_CAPACITY_DIV = 5;
    private Logger log;
    private final Object lock = new String("lock");
    private StringBuilder sb = new StringBuilder();
    private int bufferTop = 0;
    private int maxBufferSize;
    private long lastCleanupTime;
    private static RequestProcessor RP = new RequestProcessor("StdErr Flush");
    private RequestProcessor.Task flush = RP.create((Runnable)this, true);
    private final RequestProcessor.Task cleanupTask = RP.create(new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = PrintStreamLogger.this.lock;
            synchronized (object) {
                PrintStreamLogger.this.maybeFreeBuffer();
            }
        }
    });

    private PrintStreamLogger(Logger log) {
        super(new ByteArrayOutputStream());
        this.log = log;
    }

    public static boolean isLogger(PrintStream ps) {
        return ps.getClass().getName().equals(PrintStreamLogger.class.getName());
    }

    public static PrintStream create(String loggerName) {
        return new PrintStreamLogger(Logger.getLogger(loggerName));
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        if (RP.isRequestProcessorThread()) {
            return;
        }
        String s = new String(buf, off, len);
        this.print(s);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int b) {
        if (RP.isRequestProcessorThread()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.sb.append((char)b);
            this.checkFlush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(String s) {
        if (NbLogging.DEBUG != null && !NbLogging.wantsMessage(s)) {
            new Exception().printStackTrace(NbLogging.DEBUG);
        }
        Object object = this.lock;
        synchronized (object) {
            this.sb.append(s);
            this.checkFlush();
        }
    }

    @Override
    public void println(String x) {
        this.print(x);
        this.print(System.getProperty("line.separator"));
    }

    @Override
    public void println(Object x) {
        String s = String.valueOf(x);
        this.println(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        boolean empty;
        Object object = this.lock;
        synchronized (object) {
            empty = this.sb.length() == 0;
        }
        if (!empty) {
            try {
                this.flush.schedule(0);
                this.flush.waitFinished(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        super.flush();
    }

    private void checkFlush() {
        boolean immediate = this.sb.length() - this.bufferTop > 0x200000;
        try {
            this.flush.schedule(immediate ? 0 : 100);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void maybeFreeBuffer() {
        int c = this.sb.capacity();
        long t = System.currentTimeMillis();
        if (t - this.lastCleanupTime > 10000L) {
            if (c > 0x100000 && c / 5 > this.maxBufferSize) {
                this.sb = new StringBuilder(this.sb);
            }
            this.maxBufferSize = this.sb.length();
            this.lastCleanupTime = t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block3: while (true) {
            String toLog;
            Object object = this.lock;
            synchronized (object) {
                if (this.sb.length() == 0) {
                    break;
                }
                this.maxBufferSize = Math.max(this.maxBufferSize, this.sb.length());
                int last = -1;
                for (int i = this.sb.length() - 1; i >= this.bufferTop; --i) {
                    if (this.sb.charAt(i) != '\n') continue;
                    last = i;
                    break;
                }
                if (last == -1) {
                    this.bufferTop = this.sb.length();
                    break;
                }
                toLog = this.sb.substring(0, last + 1);
                this.sb.delete(0, last + 1);
                this.bufferTop = this.sb.length();
                this.maybeFreeBuffer();
                this.cleanupTask.schedule(10000);
                this.lock.notifyAll();
            }
            int begLine = 0;
            while (true) {
                if (begLine >= toLog.length()) continue block3;
                int endLine = toLog.indexOf(10, begLine);
                this.log.log(Level.INFO, toLog.substring(begLine, endLine + 1));
                begLine = endLine + 1;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int[] bufferSizes() {
        Object object = this.lock;
        synchronized (object) {
            return new int[]{this.sb.length(), this.sb.capacity()};
        }
    }
}

