/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.RunnableFuture;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.ThreadInterruptedException;

class TaskExecutor {
    private final Executor executor;

    TaskExecutor(Executor executor) {
        this.executor = Objects.requireNonNull(executor, "Executor is null");
    }

    final <T> List<T> invokeAll(Collection<RunnableFuture<T>> tasks) throws IOException {
        for (Runnable runnable : tasks) {
            this.executor.execute(runnable);
        }
        ArrayList results = new ArrayList();
        for (Future future : tasks) {
            try {
                results.add(future.get());
            }
            catch (InterruptedException e) {
                throw new ThreadInterruptedException(e);
            }
            catch (ExecutionException e) {
                throw IOUtils.rethrowAlways(e.getCause());
            }
        }
        return results;
    }
}

