/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.angular.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.html.angular.model.DirectiveConvention;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.lib.api.elements.Attribute;
import org.netbeans.modules.html.editor.lib.api.elements.AttributeFilter;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;

public class AngularModel {
    private static final Map<HtmlParserResult, AngularModel> INSTANCES = new WeakHashMap<HtmlParserResult, AngularModel>();
    private Map<OpenTag, Collection<Attribute>> elements2ngAttributes = new HashMap<OpenTag, Collection<Attribute>>();
    private EnumMap<DirectiveConvention, Integer> directiveConventionOccurrenceCount = new EnumMap(DirectiveConvention.class);
    private DirectiveConvention mostUsedConvention;
    private Collection<Attribute> ngAttributes = new ArrayList<Attribute>();

    @NonNull
    public static synchronized AngularModel getModel(HtmlParserResult result) {
        assert (result != null);
        assert (result.getSyntaxAnalyzerResult() != null);
        AngularModel model = INSTANCES.get(result);
        if (model == null) {
            model = new AngularModel(result);
            INSTANCES.put(result, model);
        }
        return model;
    }

    private AngularModel(HtmlParserResult result) {
        Iterator elementsIterator = result.getSyntaxAnalyzerResult().getElementsIterator();
        while (elementsIterator.hasNext()) {
            Element element = (Element)elementsIterator.next();
            switch (element.type()) {
                case OPEN_TAG: {
                    OpenTag ot = (OpenTag)element;
                    for (Attribute ngAttr : ot.attributes(new AttributeFilter(){

                        public boolean accepts(Attribute attribute) {
                            DirectiveConvention convention = DirectiveConvention.getConvention(attribute.unqualifiedName());
                            if (convention != null) {
                                Integer i = (Integer)AngularModel.this.directiveConventionOccurrenceCount.get((Object)convention);
                                if (i == null) {
                                    AngularModel.this.directiveConventionOccurrenceCount.put(convention, 1);
                                } else {
                                    AngularModel.this.directiveConventionOccurrenceCount.put(convention, i + 1);
                                }
                                return true;
                            }
                            return false;
                        }
                    })) {
                        Collection<Attribute> attrs = this.elements2ngAttributes.get(ot);
                        if (attrs == null) {
                            attrs = new ArrayList<Attribute>();
                            this.elements2ngAttributes.put(ot, attrs);
                        }
                        attrs.add(ngAttr);
                        this.ngAttributes.add(ngAttr);
                    }
                    break;
                }
            }
        }
    }

    public synchronized DirectiveConvention getPrevailingAttributeConvention() {
        if (this.mostUsedConvention == null) {
            DirectiveConvention winner = DirectiveConvention.base_dash;
            int count = 0;
            for (Map.Entry<DirectiveConvention, Integer> entry : this.directiveConventionOccurrenceCount.entrySet()) {
                Integer occurrences = entry.getValue();
                if (count > occurrences) continue;
                winner = entry.getKey();
                count = occurrences;
            }
            this.mostUsedConvention = winner;
        }
        return this.mostUsedConvention;
    }

    @NonNull
    public Collection<Attribute> getNgAttributes() {
        return this.ngAttributes;
    }

    public boolean isAngularPage() {
        return !this.getNgAttributes().isEmpty();
    }
}

