/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.api.gsf;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.csl.spi.DefaultError;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.html.editor.gsf.HtmlParserResultAccessor;
import org.netbeans.modules.html.editor.lib.api.HtmlParsingResult;
import org.netbeans.modules.html.editor.lib.api.HtmlSource;
import org.netbeans.modules.html.editor.lib.api.HtmlVersion;
import org.netbeans.modules.html.editor.lib.api.MaskedAreas;
import org.netbeans.modules.html.editor.lib.api.ParseException;
import org.netbeans.modules.html.editor.lib.api.ParseResult;
import org.netbeans.modules.html.editor.lib.api.ProblemDescription;
import org.netbeans.modules.html.editor.lib.api.SyntaxAnalyzerResult;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.ElementUtils;
import org.netbeans.modules.html.editor.lib.api.elements.Node;
import org.netbeans.modules.html.editor.lib.api.foreign.MaskingChSReader;
import org.netbeans.modules.html.editor.lib.api.validation.ValidationContext;
import org.netbeans.modules.html.editor.lib.api.validation.ValidationException;
import org.netbeans.modules.html.editor.lib.api.validation.ValidationResult;
import org.netbeans.modules.html.editor.lib.api.validation.Validator;
import org.netbeans.modules.html.editor.lib.api.validation.ValidatorService;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class HtmlParserResult
extends ParserResult
implements HtmlParsingResult {
    public static final String FALLBACK_DTD_PROPERTY_NAME = "fallbackDTD";
    private final SyntaxAnalyzerResult result;
    private List<Error> errors;
    private final AtomicBoolean isValid = new AtomicBoolean(true);

    private HtmlParserResult(SyntaxAnalyzerResult result) {
        super(result.getSource().getSnapshot());
        this.result = result;
    }

    public SyntaxAnalyzerResult getSyntaxAnalyzerResult() {
        return this.result;
    }

    public boolean isValid() {
        return this.isValid.get();
    }

    public HtmlVersion getHtmlVersion() {
        return this.result.getHtmlVersion();
    }

    public HtmlVersion getDetectedHtmlVersion() {
        return this.result.getDetectedHtmlVersion();
    }

    public Node root() {
        try {
            return this.result.parseHtml().root();
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public Node rootOfUndeclaredTagsParseTree() {
        try {
            return this.result.parseUndeclaredEmbeddedCode().root();
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public Node root(String namespace) {
        try {
            ParseResult pr = this.result.parseEmbeddedCode(namespace);
            assert (pr != null) : "Cannot get ParseResult for " + namespace;
            return pr.root();
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public Map<String, Node> roots() {
        HashMap<String, Node> roots = new HashMap<String, Node>();
        for (String uri : this.getNamespaces().keySet()) {
            roots.put(uri, this.root(uri));
        }
        if (!roots.containsValue(this.root())) {
            roots.put(null, this.root());
        }
        return roots;
    }

    public Map<String, String> getNamespaces() {
        return this.result.getDeclaredNamespaces();
    }

    private Collection<Node> getAllRoots() {
        ArrayList<Node> allRoots = new ArrayList<Node>();
        allRoots.add(this.root());
        allRoots.addAll(this.roots().values());
        allRoots.add(this.root("filtered_code"));
        allRoots.add(this.rootOfUndeclaredTagsParseTree());
        return allRoots;
    }

    public Node findBySemanticRange(int offset, boolean forward) {
        Node mostLeaf = null;
        for (Node root : this.getAllRoots()) {
            Node leaf = ElementUtils.findBySemanticRange((Node)root, (int)offset, (boolean)forward);
            if (leaf == null) continue;
            if (mostLeaf == null) {
                mostLeaf = leaf;
                continue;
            }
            if (leaf.from() <= mostLeaf.from()) continue;
            mostLeaf = leaf;
        }
        return mostLeaf;
    }

    public Element findByPhysicalRange(int offset, boolean forward) {
        Element mostLeaf = null;
        for (Node root : this.getAllRoots()) {
            Element leaf = ElementUtils.findByPhysicalRange((Node)root, (int)offset, (boolean)forward);
            if (leaf == null) continue;
            if (mostLeaf == null) {
                mostLeaf = leaf;
                continue;
            }
            if (leaf.from() <= mostLeaf.from()) continue;
            mostLeaf = leaf;
        }
        return mostLeaf;
    }

    public List<? extends Error> getDiagnostics() {
        return this.getSnapshot().getMimePath().size() == 1 ? this.getDiagnostics(EnumSet.of(Severity.FATAL)) : Collections.emptyList();
    }

    protected void invalidate() {
        this.isValid.set(false);
    }

    public List<Error> getDiagnostics(Set<Severity> severities) {
        ArrayList<Error> filtered = new ArrayList<Error>();
        for (Error e : this.getValidationResults()) {
            if (!severities.contains(e.getSeverity())) continue;
            filtered.add(e);
        }
        return filtered;
    }

    private synchronized List<Error> getValidationResults() {
        if (this.errors == null) {
            this.errors = new ArrayList<Error>();
            this.errors.addAll(this.getErrorsFromValidatorService());
        }
        return this.errors;
    }

    private List<Error> getErrorsFromValidatorService() {
        FileObject file = this.getSnapshot().getSource().getFileObject();
        try {
            Validator validator = ValidatorService.getValidator((HtmlVersion)this.getHtmlVersion());
            if (validator == null) {
                return Collections.emptyList();
            }
            HtmlSource source = new HtmlSource(this.getSnapshot());
            MaskedAreas maskedAreas = this.result.getMaskedAreas(source, new SyntaxAnalyzerResult.FilteredContent[]{SyntaxAnalyzerResult.FilteredContent.CUSTOM_TAGS});
            String original = this.getSnapshot().getText().toString();
            MaskingChSReader masker = new MaskingChSReader((CharSequence)original, maskedAreas.positions(), maskedAreas.lens());
            ValidationContext context = new ValidationContext((Reader)masker, this.getHtmlVersion(), file, this.result);
            context.enableFeature("filter.foreign.namespaces", true);
            ValidationResult res = validator.validate(context);
            ArrayList<Error> errs = new ArrayList<Error>();
            int[] positions = maskedAreas.positions();
            int[] lens = maskedAreas.lens();
            for (ProblemDescription pd : res.getProblems()) {
                int pos;
                int from = pd.getFrom();
                int to = pd.getTo();
                int idx = Arrays.binarySearch(positions, from);
                if (idx < 0) {
                    idx = -idx - 1;
                }
                if (idx < positions.length && (pos = positions[idx]) + lens[idx] <= to) continue;
                DefaultError error = new DefaultError(pd.getKey(), pd.getText(), pd.getText(), res.getContext().getFile(), pd.getFrom(), pd.getTo(), false, HtmlParserResult.forProblemType(pd.getType()));
                errs.add((Error)error);
            }
            return errs;
        }
        catch (ValidationException ex) {
            Logger.getAnonymousLogger().log(Level.INFO, "An error occured during html code validation", ex);
            DefaultError error = new DefaultError("validator.error", "validator.error", "An internal error occured during validating the code: " + ex.getLocalizedMessage(), file, 0, 0, true, Severity.ERROR);
            return Collections.singletonList(error);
        }
    }

    private static Severity forProblemType(int problemtype) {
        switch (problemtype) {
            case 0: {
                return Severity.INFO;
            }
            case 1: {
                return Severity.WARNING;
            }
            case 2: {
                return Severity.ERROR;
            }
            case 3: {
                return Severity.FATAL;
            }
            case 4: {
                return Severity.INFO;
            }
        }
        throw new IllegalArgumentException("Invalid ProblemDescription type: " + problemtype);
    }

    public static Node getBoundNode(Error e) {
        Object[] parameters;
        if (e instanceof DefaultError && (parameters = e.getParameters()) != null && parameters.length > 0 && parameters[0] instanceof Node) {
            return (Node)e.getParameters()[0];
        }
        return null;
    }

    static {
        HtmlParserResultAccessor.set(new Accessor());
    }

    private static class Accessor
    extends HtmlParserResultAccessor {
        private Accessor() {
        }

        @Override
        public HtmlParserResult createInstance(SyntaxAnalyzerResult result) {
            return new Lkp(result);
        }
    }

    private static final class Lkp
    extends HtmlParserResult
    implements Lookup.Provider {
        private Lookup lkp;

        private Lkp(SyntaxAnalyzerResult result) {
            super(result);
        }

        public Lookup getLookup() {
            if (this.lkp == null) {
                this.lkp = Lookups.fixed((Object[])new Object[]{this.getSyntaxAnalyzerResult()});
            }
            return this.lkp;
        }
    }
}

