/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.repository;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.GitRepositories;
import org.netbeans.modules.git.ui.repository.Bundle;
import org.netbeans.modules.git.ui.repository.GitRepositoryTopComponent;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileChooserBuilder;

public class OpenRepositoryAction
extends AbstractAction {
    public OpenRepositoryAction() {
        super(Bundle.LBL_OpenRepositoryAction_PopupName());
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        final File f = new FileChooserBuilder(OpenRepositoryAction.class).setDirectoriesOnly(true).setApproveText(Bundle.CTL_OpenRepository_okButton()).setAccessibleDescription(Bundle.CTL_OpenRepository_ACSD()).showOpenDialog();
        if (f == null) {
            return;
        }
        Utils.postParallel((Runnable)new Runnable(){

            @Override
            public void run() {
                final File repository = Git.getInstance().getRepositoryRoot(f);
                if (repository != null) {
                    GitRepositories.getInstance().add(repository, true);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GitRepositoryTopComponent rtc = GitRepositoryTopComponent.findInstance();
                            rtc.open();
                            rtc.requestActive();
                            rtc.selectRepository(repository);
                        }
                    });
                }
            }
        }, (int)0);
    }
}

