/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.rebase;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JList;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.modules.git.ui.rebase.Bundle;
import org.netbeans.modules.git.ui.rebase.RebaseKind;
import org.netbeans.modules.git.ui.rebase.RebasePanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;

public class Rebase
implements ActionListener,
PropertyChangeListener {
    private final RebasePanel panel;
    private final JButton okButton;
    private final JButton cancelButton;
    private final RebaseKind[] kinds;
    static final String PROP_VALID = "rebase.propValid";

    public Rebase(File repository, Map<String, GitBranch> branches, GitBranch activeBranch) {
        this.kinds = new RebaseKind[]{new RebaseKind.BasicKind(activeBranch), new RebaseKind.SelectDestinationKind(repository, activeBranch)};
        this.panel = new RebasePanel();
        this.okButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.okButton, (String)Bundle.CTL_RebasePanel_okButton_text());
        this.okButton.getAccessibleContext().setAccessibleDescription(Bundle.CTL_RebasePanel_okButton_ACSD());
        this.cancelButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)Bundle.CTL_RebasePanel_cancelButton_text());
        this.cancelButton.getAccessibleContext().setAccessibleDescription(Bundle.CTL_RebasePanel_cancelButton_ACSD());
        this.okButton.setEnabled(false);
        this.attachListeners();
        this.initializeCombo();
    }

    public boolean showDialog() {
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.panel, Bundle.CTL_RebasePanel_ACSD());
        dialogDescriptor.setOptions(new Object[]{this.okButton, this.cancelButton});
        dialogDescriptor.setModal(true);
        dialogDescriptor.setHelpCtx(new HelpCtx("org.netbeans.modules.git.ui.rebase.RebasePanel"));
        dialogDescriptor.setValid(false);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(Bundle.CTL_RebasePanel_ACSD());
        dialog.setVisible(true);
        dialog.setResizable(false);
        boolean ret = dialogDescriptor.getValue() == this.okButton;
        return ret;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.panel.cmbRebaseType) {
            RebaseKind rebaseKind = (RebaseKind)this.panel.cmbRebaseType.getSelectedItem();
            this.panel.lblDescription.setText(rebaseKind.getDescription());
            ((CardLayout)this.panel.panelKind.getLayout()).show(this.panel.panelKind, rebaseKind.getId());
            this.okButton.setEnabled(rebaseKind.isValid());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.okButton != null && evt.getSource() == this.panel.cmbRebaseType.getSelectedItem() && PROP_VALID.equals(evt.getPropertyName())) {
            boolean valid = (Boolean)evt.getNewValue();
            this.okButton.setEnabled(valid);
        }
    }

    String getRevisionBase() {
        return this.getSelectedKind().getUpstream();
    }

    String getRevisionSource() {
        return this.getSelectedKind().getSource();
    }

    String getRevisionDest() {
        return this.getSelectedKind().getDest();
    }

    private void attachListeners() {
        this.panel.cmbRebaseType.addActionListener(this);
    }

    private void initializeCombo() {
        DefaultComboBoxModel<RebaseKind> model = new DefaultComboBoxModel<RebaseKind>(this.kinds);
        for (RebaseKind kind : this.kinds) {
            this.panel.panelKind.add((Component)kind.getPanel(), kind.getId());
            kind.addPropertyChangeListener(this);
        }
        this.panel.cmbRebaseType.setModel(model);
        this.panel.cmbRebaseType.setRenderer(new RebaseKindRenderer());
        this.panel.cmbRebaseType.setSelectedIndex(0);
    }

    private RebaseKind getSelectedKind() {
        return (RebaseKind)this.panel.cmbRebaseType.getSelectedItem();
    }

    private static class RebaseKindRenderer
    extends DefaultListCellRenderer {
        private RebaseKindRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof RebaseKind) {
                value = ((RebaseKind)value).getDisplayName();
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }
}

