/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.context;

import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.StaticApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.ServletContextAwareProcessor;
import org.springframework.web.portlet.context.ConfigurablePortletApplicationContext;
import org.springframework.web.portlet.context.PortletApplicationContextUtils;
import org.springframework.web.portlet.context.PortletConfigAware;
import org.springframework.web.portlet.context.PortletContextAware;
import org.springframework.web.portlet.context.PortletContextAwareProcessor;
import org.springframework.web.portlet.context.PortletContextResource;
import org.springframework.web.portlet.context.PortletContextResourcePatternResolver;
import org.springframework.web.portlet.context.StandardPortletEnvironment;

public class StaticPortletApplicationContext
extends StaticApplicationContext
implements ConfigurablePortletApplicationContext {
    private ServletContext servletContext;
    private PortletContext portletContext;
    private PortletConfig portletConfig;
    private String namespace;

    public StaticPortletApplicationContext() {
        this.setDisplayName("Root Portlet ApplicationContext");
    }

    protected ConfigurableEnvironment createEnvironment() {
        return new StandardPortletEnvironment();
    }

    protected void initPropertySources() {
        PortletApplicationContextUtils.initPortletPropertySources(this.getEnvironment().getPropertySources(), this.servletContext, this.portletContext, this.portletConfig);
    }

    public void setParent(ApplicationContext parent) {
        super.setParent(parent);
        if (parent instanceof WebApplicationContext) {
            this.servletContext = ((WebApplicationContext)parent).getServletContext();
        }
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setPortletContext(PortletContext portletContext) {
        this.portletContext = portletContext;
    }

    public PortletContext getPortletContext() {
        return this.portletContext;
    }

    public void setPortletConfig(PortletConfig portletConfig) {
        this.portletConfig = portletConfig;
        if (portletConfig != null && this.portletContext == null) {
            this.portletContext = portletConfig.getPortletContext();
        }
    }

    public PortletConfig getPortletConfig() {
        return this.portletConfig;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
        if (namespace != null) {
            this.setDisplayName("Portlet ApplicationContext for namespace '" + namespace + "'");
        }
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setConfigLocation(String configLocation) {
        if (configLocation != null) {
            throw new UnsupportedOperationException("StaticPortletApplicationContext does not support config locations");
        }
    }

    public void setConfigLocations(String[] configLocations) {
        if (configLocations != null) {
            throw new UnsupportedOperationException("StaticPortletApplicationContext does not support config locations");
        }
    }

    public String[] getConfigLocations() {
        return null;
    }

    protected void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        beanFactory.addBeanPostProcessor((BeanPostProcessor)new ServletContextAwareProcessor(this.servletContext));
        beanFactory.addBeanPostProcessor((BeanPostProcessor)new PortletContextAwareProcessor(this.portletContext, this.portletConfig));
        beanFactory.ignoreDependencyInterface(PortletContextAware.class);
        beanFactory.ignoreDependencyInterface(PortletConfigAware.class);
        PortletApplicationContextUtils.registerPortletApplicationScopes(beanFactory, this.portletContext);
        PortletApplicationContextUtils.registerEnvironmentBeans(beanFactory, this.servletContext, this.portletContext, this.portletConfig);
    }

    protected Resource getResourceByPath(String path) {
        return new PortletContextResource(this.portletContext, path);
    }

    protected ResourcePatternResolver getResourcePatternResolver() {
        return new PortletContextResourcePatternResolver((ResourceLoader)this);
    }
}

