/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.keymanagement.model.RestoreKeyFromObjectStoreDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class RestoreKeyFromObjectStoreRequest
extends BmcRequest<RestoreKeyFromObjectStoreDetails> {
    private String ifMatch;
    private String opcRequestId;
    private String opcRetryToken;
    private RestoreKeyFromObjectStoreDetails restoreKeyFromObjectStoreDetails;

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public RestoreKeyFromObjectStoreDetails getRestoreKeyFromObjectStoreDetails() {
        return this.restoreKeyFromObjectStoreDetails;
    }

    @InternalSdk
    public RestoreKeyFromObjectStoreDetails getBody$() {
        return this.restoreKeyFromObjectStoreDetails;
    }

    public Builder toBuilder() {
        return new Builder().ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken).restoreKeyFromObjectStoreDetails(this.restoreKeyFromObjectStoreDetails);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",restoreKeyFromObjectStoreDetails=").append(String.valueOf((Object)this.restoreKeyFromObjectStoreDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RestoreKeyFromObjectStoreRequest)) {
            return false;
        }
        RestoreKeyFromObjectStoreRequest other = (RestoreKeyFromObjectStoreRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals((Object)this.restoreKeyFromObjectStoreDetails, (Object)other.restoreKeyFromObjectStoreDetails);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.restoreKeyFromObjectStoreDetails == null ? 43 : this.restoreKeyFromObjectStoreDetails.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<RestoreKeyFromObjectStoreRequest, RestoreKeyFromObjectStoreDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;
        private RestoreKeyFromObjectStoreDetails restoreKeyFromObjectStoreDetails = null;

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder restoreKeyFromObjectStoreDetails(RestoreKeyFromObjectStoreDetails restoreKeyFromObjectStoreDetails) {
            this.restoreKeyFromObjectStoreDetails = restoreKeyFromObjectStoreDetails;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RestoreKeyFromObjectStoreRequest o) {
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.restoreKeyFromObjectStoreDetails(o.getRestoreKeyFromObjectStoreDetails());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RestoreKeyFromObjectStoreRequest build() {
            RestoreKeyFromObjectStoreRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(RestoreKeyFromObjectStoreDetails body) {
            this.restoreKeyFromObjectStoreDetails(body);
            return this;
        }

        public RestoreKeyFromObjectStoreRequest buildWithoutInvocationCallback() {
            RestoreKeyFromObjectStoreRequest request = new RestoreKeyFromObjectStoreRequest();
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            request.restoreKeyFromObjectStoreDetails = this.restoreKeyFromObjectStoreDetails;
            return request;
        }
    }
}

