/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class VaultReplicaSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="cryptoEndpoint")
    private final String cryptoEndpoint;
    @JsonProperty(value="managementEndpoint")
    private final String managementEndpoint;
    @JsonProperty(value="region")
    private final String region;
    @JsonProperty(value="status")
    private final Status status;

    @Deprecated
    @ConstructorProperties(value={"cryptoEndpoint", "managementEndpoint", "region", "status"})
    public VaultReplicaSummary(String cryptoEndpoint, String managementEndpoint, String region, Status status) {
        this.cryptoEndpoint = cryptoEndpoint;
        this.managementEndpoint = managementEndpoint;
        this.region = region;
        this.status = status;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCryptoEndpoint() {
        return this.cryptoEndpoint;
    }

    public String getManagementEndpoint() {
        return this.managementEndpoint;
    }

    public String getRegion() {
        return this.region;
    }

    public Status getStatus() {
        return this.status;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("VaultReplicaSummary(");
        sb.append("super=").append(super.toString());
        sb.append("cryptoEndpoint=").append(String.valueOf(this.cryptoEndpoint));
        sb.append(", managementEndpoint=").append(String.valueOf(this.managementEndpoint));
        sb.append(", region=").append(String.valueOf(this.region));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VaultReplicaSummary)) {
            return false;
        }
        VaultReplicaSummary other = (VaultReplicaSummary)((Object)o);
        return Objects.equals(this.cryptoEndpoint, other.cryptoEndpoint) && Objects.equals(this.managementEndpoint, other.managementEndpoint) && Objects.equals(this.region, other.region) && Objects.equals((Object)this.status, (Object)other.status) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.cryptoEndpoint == null ? 43 : this.cryptoEndpoint.hashCode());
        result = result * 59 + (this.managementEndpoint == null ? 43 : this.managementEndpoint.hashCode());
        result = result * 59 + (this.region == null ? 43 : this.region.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Status implements BmcEnum
    {
        Creating("CREATING"),
        Created("CREATED"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="cryptoEndpoint")
        private String cryptoEndpoint;
        @JsonProperty(value="managementEndpoint")
        private String managementEndpoint;
        @JsonProperty(value="region")
        private String region;
        @JsonProperty(value="status")
        private Status status;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder cryptoEndpoint(String cryptoEndpoint) {
            this.cryptoEndpoint = cryptoEndpoint;
            this.__explicitlySet__.add("cryptoEndpoint");
            return this;
        }

        public Builder managementEndpoint(String managementEndpoint) {
            this.managementEndpoint = managementEndpoint;
            this.__explicitlySet__.add("managementEndpoint");
            return this;
        }

        public Builder region(String region) {
            this.region = region;
            this.__explicitlySet__.add("region");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public VaultReplicaSummary build() {
            VaultReplicaSummary model = new VaultReplicaSummary(this.cryptoEndpoint, this.managementEndpoint, this.region, this.status);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(VaultReplicaSummary model) {
            if (model.wasPropertyExplicitlySet("cryptoEndpoint")) {
                this.cryptoEndpoint(model.getCryptoEndpoint());
            }
            if (model.wasPropertyExplicitlySet("managementEndpoint")) {
                this.managementEndpoint(model.getManagementEndpoint());
            }
            if (model.wasPropertyExplicitlySet("region")) {
                this.region(model.getRegion());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            return this;
        }
    }
}

