/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement;

import com.oracle.bmc.keymanagement.Ekm;
import com.oracle.bmc.keymanagement.model.EkmsPrivateEndpoint;
import com.oracle.bmc.keymanagement.requests.GetEkmsPrivateEndpointRequest;
import com.oracle.bmc.keymanagement.responses.GetEkmsPrivateEndpointResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class EkmWaiters {
    private final ExecutorService executorService;
    private final Ekm client;

    public EkmWaiters(ExecutorService executorService, Ekm client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetEkmsPrivateEndpointRequest, GetEkmsPrivateEndpointResponse> forEkmsPrivateEndpoint(GetEkmsPrivateEndpointRequest request, EkmsPrivateEndpoint.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forEkmsPrivateEndpoint(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetEkmsPrivateEndpointRequest, GetEkmsPrivateEndpointResponse> forEkmsPrivateEndpoint(GetEkmsPrivateEndpointRequest request, EkmsPrivateEndpoint.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forEkmsPrivateEndpoint(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetEkmsPrivateEndpointRequest, GetEkmsPrivateEndpointResponse> forEkmsPrivateEndpoint(GetEkmsPrivateEndpointRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, EkmsPrivateEndpoint.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forEkmsPrivateEndpoint(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetEkmsPrivateEndpointRequest, GetEkmsPrivateEndpointResponse> forEkmsPrivateEndpoint(BmcGenericWaiter waiter, GetEkmsPrivateEndpointRequest request, EkmsPrivateEndpoint.LifecycleState ... targetStates) {
        final HashSet<EkmsPrivateEndpoint.LifecycleState> targetStatesSet = new HashSet<EkmsPrivateEndpoint.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetEkmsPrivateEndpointRequest, GetEkmsPrivateEndpointResponse>(){

            @Override
            public GetEkmsPrivateEndpointResponse apply(GetEkmsPrivateEndpointRequest request) {
                return EkmWaiters.this.client.getEkmsPrivateEndpoint(request);
            }
        }, (Predicate)new Predicate<GetEkmsPrivateEndpointResponse>(){

            @Override
            public boolean test(GetEkmsPrivateEndpointResponse response) {
                return targetStatesSet.contains((Object)response.getEkmsPrivateEndpoint().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)EkmsPrivateEndpoint.LifecycleState.Deleted)), (Object)request);
    }
}

