/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.dd.impl.webservices.annotation;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.j2ee.dd.api.common.Icon;
import org.netbeans.modules.j2ee.dd.api.webservices.PortComponent;
import org.netbeans.modules.j2ee.dd.api.webservices.WebserviceDescription;
import org.netbeans.modules.j2ee.dd.impl.webservices.annotation.PortComponentImpl;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.JavaContextListener;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.PersistentObject;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.AnnotationParser;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.ParseResult;

public class WebserviceDescriptionImpl
extends PersistentObject
implements WebserviceDescription,
JavaContextListener {
    private String serviceName;
    private String wsdlLocation;
    private boolean isProvider;
    private PortComponent[] portComponents;

    public WebserviceDescriptionImpl(AnnotationModelHelper helper, TypeElement typeElement) {
        super(helper, typeElement);
        helper.addJavaContextListener((JavaContextListener)this);
        boolean valid = this.refresh(typeElement);
        assert (valid);
    }

    boolean refresh(TypeElement typeElement) {
        if (typeElement.getKind() == ElementKind.INTERFACE) {
            return false;
        }
        AnnotationModelHelper helper = this.getHelper();
        Map annByType = helper.getAnnotationsByType(typeElement.getAnnotationMirrors());
        AnnotationMirror webServiceAnn = (AnnotationMirror)annByType.get("javax.jws.WebService");
        if (webServiceAnn == null) {
            webServiceAnn = (AnnotationMirror)annByType.get("javax.xml.ws.WebServiceProvider");
            this.isProvider = true;
        }
        if (webServiceAnn == null) {
            return false;
        }
        AnnotationParser parser = AnnotationParser.create((AnnotationModelHelper)helper);
        parser.expectString("serviceName", AnnotationParser.defaultValue((Object)(typeElement.getSimpleName().toString() + "Service")));
        parser.expectString("wsdlLocation", AnnotationParser.defaultValue((Object)""));
        ParseResult parseResult = parser.parse(webServiceAnn);
        this.serviceName = (String)parseResult.get("serviceName", String.class);
        this.wsdlLocation = (String)parseResult.get("wsdlLocation", String.class);
        return true;
    }

    public void javaContextLeft() {
        this.portComponents = null;
    }

    @Override
    public String getWebserviceDescriptionName() {
        return this.serviceName;
    }

    @Override
    public String getWsdlFile() {
        return this.wsdlLocation;
    }

    @Override
    public String getDisplayName() {
        return this.isProvider ? "javax.xml.ws.WebServiceProvider" : this.serviceName;
    }

    @Override
    public PortComponent[] getPortComponent() {
        this.initPortComonents();
        return this.portComponents;
    }

    @Override
    public int sizePortComponent() {
        this.initPortComonents();
        return this.portComponents.length;
    }

    @Override
    public PortComponent getPortComponent(int index) {
        this.initPortComonents();
        return this.portComponents[index];
    }

    private void initPortComonents() {
        if (this.portComponents != null) {
            return;
        }
        AnnotationModelHelper helper = this.getHelper();
        TypeElement typeElement = this.getTypeElement();
        if (typeElement == null) {
            this.portComponents = new PortComponent[0];
            return;
        }
        Map annByType = helper.getAnnotationsByType(typeElement.getAnnotationMirrors());
        AnnotationParser parser = AnnotationParser.create((AnnotationModelHelper)helper);
        parser.expectString("portName", AnnotationParser.defaultValue((Object)(typeElement.getSimpleName().toString() + "Port")));
        parser.expectString("name", AnnotationParser.defaultValue((Object)typeElement.getSimpleName().toString()));
        parser.expectString("endpointInterface", AnnotationParser.defaultValue((Object)typeElement.getQualifiedName().toString()));
        parser.expectString("targetNamespace", AnnotationParser.defaultValue((Object)("http://" + this.getPackageNameFromTypeElement(typeElement) + "/")));
        ParseResult parseResult = parser.parse((AnnotationMirror)annByType.get("javax.jws.WebService"));
        String portName = (String)parseResult.get("portName", String.class);
        String portTypeName = (String)parseResult.get("name", String.class);
        String endpointInterface = (String)parseResult.get("endpointInterface", String.class);
        String targetNamespace = (String)parseResult.get("targetNamespace", String.class);
        this.portComponents = new PortComponent[]{new PortComponentImpl(helper, typeElement, this.serviceName, portName, portTypeName, endpointInterface, targetNamespace)};
    }

    public Object clone() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setId(String value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getId() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setDescription(String value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getDescription() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setDescriptionId(String value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getDescriptionId() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setDescriptionXmlLang(String value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getDescriptionXmlLang() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setDisplayName(String value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setDisplayNameId(String value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getDisplayNameId() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setDisplayNameXmlLang(String value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getDisplayNameXmlLang() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setIcon(Icon value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Icon getIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Icon newIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setWebserviceDescriptionName(String value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setWebserviceDescriptionNameId(String value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getWebserviceDescriptionNameId() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setWsdlFile(String value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setJaxrpcMappingFile(String value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getJaxrpcMappingFile() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setPortComponent(int index, PortComponent value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setPortComponent(PortComponent[] value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int addPortComponent(PortComponent value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int removePortComponent(PortComponent value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public PortComponent newPortComponent() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object getValue(String propertyName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void write(OutputStream os) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private String getPackageNameFromTypeElement(TypeElement typeElement) {
        Element el = typeElement;
        while (ElementKind.PACKAGE != el.getKind()) {
            el = el.getEnclosingElement();
        }
        return ((PackageElement)el).getQualifiedName().toString();
    }
}

