/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localhistory;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.localhistory.LocalHistory;
import org.netbeans.modules.localhistory.store.LocalHistoryStore;
import org.netbeans.modules.localhistory.utils.FileUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSInterceptor;

class LocalHistoryVCSInterceptor
extends VCSInterceptor {
    static final Logger LOG = Logger.getLogger(LocalHistoryVCSInterceptor.class.getName());
    private Map<String, StorageMoveHandler> moveHandlerMap;
    private Set<VCSFileProxy> toBeDeleted = new HashSet<VCSFileProxy>();
    private Set<VCSFileProxy> toBeCreated = new HashSet<VCSFileProxy>();
    private Set<VCSFileProxy> wasJustCreated = new HashSet<VCSFileProxy>();

    private LocalHistoryStore getStore() {
        return LocalHistory.getInstance().getLocalHistoryStore();
    }

    public boolean beforeDelete(VCSFileProxy file) {
        LOG.log(Level.FINE, "beforeDelete {0}", file);
        if (!this.accept(file)) {
            return false;
        }
        this.toBeDeleted.add(file);
        this.getStore().waitForProcessedStoring(file, "beforeDelete");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterDelete(VCSFileProxy file) {
        LOG.log(Level.FINE, "afterDelete {0}", file);
        if (!this.accept(file)) {
            return;
        }
        if (!this.toBeDeleted.remove(file)) {
            return;
        }
        String key = FileUtils.getPath(file);
        if (this.getMoveHandlerMap().containsKey(key)) {
            StorageMoveHandler handler = this.getMoveHandlerMap().get(key);
            try {
                handler.delete();
            }
            finally {
                this.getMoveHandlerMap().remove(key);
            }
        } else {
            this.getStore().fileDelete(file, System.currentTimeMillis());
        }
    }

    public boolean beforeMove(VCSFileProxy from, VCSFileProxy to) {
        LOG.log(Level.FINE, "beforeMove {0} to {1}", new Object[]{from, to});
        if (!this.accept(from)) {
            return false;
        }
        this.getStore().waitForProcessedStoring(from, "beforeMove");
        StorageMoveHandler handler = new StorageMoveHandler(from, to);
        this.getMoveHandlerMap().put(FileUtils.getPath(to), handler);
        this.getMoveHandlerMap().put(FileUtils.getPath(from), handler);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterMove(VCSFileProxy from, VCSFileProxy to) {
        LOG.log(Level.FINE, "afterMove {0} to {1}", new Object[]{from, to});
        if (!this.accept(from)) {
            return;
        }
        String key = FileUtils.getPath(to);
        if (this.getMoveHandlerMap().containsKey(key)) {
            StorageMoveHandler handler = this.getMoveHandlerMap().get(key);
            try {
                handler.create();
                handler.delete();
            }
            finally {
                this.getMoveHandlerMap().remove(key);
                this.getMoveHandlerMap().remove(FileUtils.getPath(from));
            }
        }
    }

    public boolean beforeCopy(VCSFileProxy from, VCSFileProxy to) {
        this.getStore().waitForProcessedStoring(from, "beforeCopy");
        return super.beforeCopy(from, to);
    }

    public boolean beforeCreate(VCSFileProxy file, boolean isDirectory) {
        LOG.log(Level.FINE, "beforeCreate {0}", file);
        if (!this.accept(file)) {
            return false;
        }
        this.toBeCreated.add(file);
        this.getStore().waitForProcessedStoring(file, "beforeCreate");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCreate(VCSFileProxy file) {
        LOG.log(Level.FINE, "afterCreate {0}", file);
        if (!this.accept(file)) {
            return;
        }
        if (LocalHistory.getInstance().isManagedByParent(file) == null) {
            return;
        }
        LocalHistory.getInstance().fireFileEvent(LocalHistory.EVENT_FILE_CREATED, file);
        this.toBeCreated.remove(file);
        if (file.isFile()) {
            this.wasJustCreated.add(file);
        }
        String key = FileUtils.getPath(file);
        if (this.getMoveHandlerMap().containsKey(key)) {
            StorageMoveHandler handler = this.getMoveHandlerMap().get(key);
            try {
                handler.create();
            }
            finally {
                this.getMoveHandlerMap().remove(key);
            }
        }
    }

    public void beforeChange(VCSFileProxy file) {
        LOG.log(Level.FINE, "beforeChange {0}", file);
        if (this.toBeCreated.contains(file) || this.wasJustCreated.remove(file)) {
            return;
        }
        if (!this.accept(file)) {
            return;
        }
        this.getStore().waitForProcessedStoring(file, "beforeChange");
    }

    public void afterChange(VCSFileProxy file) {
        LOG.log(Level.FINE, "afterChange {0}", file);
        this.wasJustCreated.remove(file);
        if (!this.accept(file)) {
            return;
        }
        LocalHistory.getInstance().touch(file);
    }

    public void beforeEdit(VCSFileProxy file) {
        LOG.log(Level.FINE, "beforeEdit {0}", file);
        if (!this.accept(file)) {
            return;
        }
        this.getStore().fileChange(file);
    }

    private Map<String, StorageMoveHandler> getMoveHandlerMap() {
        if (this.moveHandlerMap == null) {
            this.moveHandlerMap = new HashMap<String, StorageMoveHandler>();
        }
        return this.moveHandlerMap;
    }

    private boolean accept(VCSFileProxy file) {
        return LocalHistory.getInstance().isManaged(file);
    }

    private class StorageMoveHandler {
        private long ts = -1L;
        private final VCSFileProxy from;
        private final VCSFileProxy to;

        StorageMoveHandler(VCSFileProxy from, VCSFileProxy to) {
            this.from = from;
            this.to = to;
        }

        public void delete() {
            LocalHistoryVCSInterceptor.this.getStore().fileDeleteFromMove(this.from, this.to, this.ts);
        }

        public void create() {
            this.ts = this.to.lastModified();
            LocalHistoryVCSInterceptor.this.getStore().fileCreateFromMove(this.from, this.to, this.ts);
        }
    }
}

