/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.ui;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.ui.ValidationListener;
import org.netbeans.validation.api.ui.ValidationUI;

class ButtonsValidationListenerImpl
extends ValidationListener<AbstractButton[]>
implements ItemListener,
ChangeListener {
    private final Validator<ButtonModel[]> validator;
    private final AbstractButton[] buttons;

    public ButtonsValidationListenerImpl(AbstractButton[] buttons, ValidationUI validationUI, Validator<ButtonModel[]> validator) {
        super(AbstractButton[].class, validationUI, buttons);
        this.validator = validator;
        this.buttons = buttons;
        for (int i = 0; i < buttons.length; ++i) {
            buttons[i].getModel().addChangeListener(this);
            buttons[i].getModel().addItemListener(this);
        }
        this.performValidation();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.performValidation();
    }

    @Override
    public void stateChanged(ChangeEvent pce) {
        this.performValidation();
    }

    @Override
    protected void performValidation(Problems ps) {
        boolean theyreAllDisabled = true;
        ArrayList<ButtonModel> selectedButtons = new ArrayList<ButtonModel>();
        for (AbstractButton button : this.buttons) {
            if (!button.getModel().isEnabled()) continue;
            theyreAllDisabled = false;
            if (!button.getModel().isSelected()) continue;
            selectedButtons.add(button.getModel());
        }
        if (!theyreAllDisabled) {
            this.validator.validate(ps, null, (Object)selectedButtons.toArray(new ButtonModel[selectedButtons.size()]));
        }
    }
}

