/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.analyzer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.db.sql.analyzer.SQLStatement;
import org.netbeans.modules.db.sql.analyzer.SQLStatementAnalyzer;
import org.netbeans.modules.db.sql.analyzer.SelectStatement;
import org.netbeans.modules.db.sql.analyzer.TablesClause;
import org.netbeans.modules.db.sql.lexer.SQLTokenId;

class SelectStatementAnalyzer
extends SQLStatementAnalyzer {
    private final List<List<String>> selectValues = new ArrayList<List<String>>();
    private final List<SQLStatementAnalyzer.TableIdent> fromTables = new ArrayList<SQLStatementAnalyzer.TableIdent>();

    public static SelectStatement analyze(TokenSequence<SQLTokenId> seq, SQLIdentifiers.Quoter quoter) {
        seq.moveStart();
        if (!seq.moveNext()) {
            return null;
        }
        SelectStatementAnalyzer sa = new SelectStatementAnalyzer(seq, quoter);
        sa.parse();
        TablesClause fromClause = sa.context.isAfter(SQLStatement.Context.FROM) ? sa.createTablesClause(sa.fromTables) : null;
        return new SelectStatement(sa.startOffset, seq.offset() + seq.token().length(), Collections.unmodifiableList(sa.selectValues), fromClause, Collections.unmodifiableList(sa.subqueries), sa.offset2Context);
    }

    private SelectStatementAnalyzer(TokenSequence<SQLTokenId> seq, SQLIdentifiers.Quoter quoter) {
        super(seq, quoter);
    }

    private void parse() {
        this.startOffset = this.seq.offset();
        boolean afterFromTableKeyword = false;
        block21: do {
            switch (this.context) {
                case START: {
                    if (!SQLStatementAnalyzer.isKeyword("SELECT", (TokenSequence<SQLTokenId>)this.seq)) continue block21;
                    this.moveToContext(SQLStatement.Context.SELECT);
                    break;
                }
                case SELECT: {
                    switch ((SQLTokenId)this.seq.token().id()) {
                        case IDENTIFIER: {
                            List<String> selectValue = this.analyzeSelectValue();
                            if (selectValue.isEmpty()) break;
                            this.selectValues.add(selectValue);
                            break;
                        }
                        case KEYWORD: {
                            if (!SQLStatementAnalyzer.isKeyword("FROM", (TokenSequence<SQLTokenId>)this.seq)) break;
                            this.moveToContext(SQLStatement.Context.FROM);
                            afterFromTableKeyword = true;
                        }
                    }
                    continue block21;
                }
                case FROM: {
                    switch ((SQLTokenId)this.seq.token().id()) {
                        case IDENTIFIER: {
                            if (!afterFromTableKeyword) break;
                            SQLStatementAnalyzer.TableIdent fromTable = this.parseTableIdent();
                            if (fromTable != null) {
                                this.fromTables.add(fromTable);
                            }
                            afterFromTableKeyword = false;
                            break;
                        }
                        case COMMA: {
                            afterFromTableKeyword = true;
                            break;
                        }
                        case KEYWORD: {
                            if (SQLStatementAnalyzer.isKeyword("JOIN", (TokenSequence<SQLTokenId>)this.seq)) {
                                afterFromTableKeyword = true;
                                break;
                            }
                            SQLStatement.Context newContext = this.getContextForKeywordAfterFrom();
                            if (newContext == null) break;
                            this.moveToContext(newContext);
                        }
                    }
                    continue block21;
                }
                case JOIN_CONDITION: {
                    switch ((SQLTokenId)this.seq.token().id()) {
                        case COMMA: {
                            this.moveToContext(SQLStatement.Context.FROM);
                            afterFromTableKeyword = true;
                            break;
                        }
                        case KEYWORD: {
                            if (!SQLStatementAnalyzer.isKeyword("JOIN", (TokenSequence<SQLTokenId>)this.seq)) break;
                            this.moveToContext(SQLStatement.Context.FROM);
                            afterFromTableKeyword = true;
                        }
                    }
                    continue block21;
                }
                case GROUP: {
                    if (!SQLStatementAnalyzer.isKeyword("BY", (TokenSequence<SQLTokenId>)this.seq)) continue block21;
                    this.moveToContext(SQLStatement.Context.GROUP_BY);
                    break;
                }
                case ORDER: {
                    if (!SQLStatementAnalyzer.isKeyword("BY", (TokenSequence<SQLTokenId>)this.seq)) continue block21;
                    this.moveToContext(SQLStatement.Context.ORDER_BY);
                    break;
                }
                default: {
                    SQLStatement.Context newState = this.getContextForKeywordAfterFrom();
                    if (newState == null) continue block21;
                    this.moveToContext(newState);
                }
            }
        } while (this.nextToken());
    }

    private List<String> analyzeSelectValue() {
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(this.getUnquotedIdentifier());
        boolean afterDot = false;
        block7: while (true) {
            if (!this.nextToken()) {
                return parts;
            }
            switch ((SQLTokenId)this.seq.token().id()) {
                case DOT: {
                    afterDot = true;
                    continue block7;
                }
                case IDENTIFIER: {
                    if (afterDot) {
                        afterDot = false;
                        parts.add(this.getUnquotedIdentifier());
                        continue block7;
                    }
                    parts.clear();
                    parts.add(this.getUnquotedIdentifier());
                    continue block7;
                }
                case LPAREN: {
                    parts.clear();
                    continue block7;
                }
                case COMMA: {
                    break block7;
                }
                case KEYWORD: {
                    if (SQLStatementAnalyzer.isKeyword("AS", (TokenSequence<SQLTokenId>)this.seq)) {
                        afterDot = false;
                        parts.clear();
                        continue block7;
                    }
                    if (!SQLStatementAnalyzer.isKeyword("FROM", (TokenSequence<SQLTokenId>)this.seq) && !this.isKeywordAfterFrom()) continue block7;
                    break block7;
                }
                default: {
                    continue block7;
                }
            }
            break;
        }
        this.seq.movePrevious();
        return parts;
    }

    private boolean isKeywordAfterFrom() {
        return this.getContextForKeywordAfterFrom() != null;
    }

    private SQLStatement.Context getContextForKeywordAfterFrom() {
        if (SQLStatementAnalyzer.isKeyword("ON", (TokenSequence<SQLTokenId>)this.seq)) {
            return SQLStatement.Context.JOIN_CONDITION;
        }
        if (SQLStatementAnalyzer.isKeyword("WHERE", (TokenSequence<SQLTokenId>)this.seq)) {
            return SQLStatement.Context.WHERE;
        }
        if (SQLStatementAnalyzer.isKeyword("GROUP", (TokenSequence<SQLTokenId>)this.seq)) {
            return SQLStatement.Context.GROUP;
        }
        if (SQLStatementAnalyzer.isKeyword("HAVING", (TokenSequence<SQLTokenId>)this.seq)) {
            return SQLStatement.Context.HAVING;
        }
        if (SQLStatementAnalyzer.isKeyword("ORDER", (TokenSequence<SQLTokenId>)this.seq)) {
            return SQLStatement.Context.ORDER;
        }
        return null;
    }
}

