/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.hcl.ast;

import java.util.Arrays;
import java.util.List;
import org.netbeans.modules.languages.hcl.ast.HCLExpression;
import org.netbeans.modules.languages.hcl.ast.HCLIdentifier;

public abstract class HCLForExpression
extends HCLExpression {
    public final HCLIdentifier keyVar;
    public final HCLIdentifier valueVar;
    public final HCLExpression iterable;
    public final HCLExpression condition;

    public HCLForExpression(HCLIdentifier keyVar, HCLIdentifier valueVar, HCLExpression iterable, HCLExpression condition) {
        this.keyVar = keyVar;
        this.valueVar = valueVar;
        this.iterable = iterable;
        this.condition = condition;
    }

    public static final class Object
    extends HCLForExpression {
        public final HCLExpression resultKey;
        public final HCLExpression resultValue;
        public final boolean grouping;

        public Object(HCLIdentifier keyVar, HCLIdentifier valueVar, HCLExpression iterable, HCLExpression condition, HCLExpression resultKey, HCLExpression resultValue, boolean grouping) {
            super(keyVar, valueVar, iterable, condition);
            this.resultKey = resultKey;
            this.resultValue = resultValue;
            this.grouping = grouping;
        }

        @Override
        public String asString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{for ");
            if (this.keyVar != null) {
                sb.append(this.keyVar).append(',');
            }
            sb.append(this.valueVar).append(" in ").append(this.iterable.asString()).append(':');
            sb.append(this.resultKey.asString()).append("=>").append(this.resultValue.asString());
            if (this.grouping) {
                sb.append("...");
            }
            if (this.condition != null) {
                sb.append(" if ").append(this.condition.asString());
            }
            sb.append('}');
            return sb.toString();
        }

        @Override
        public List<? extends HCLExpression> getChildren() {
            return Arrays.asList(this.iterable, this.resultKey, this.resultValue, this.condition);
        }
    }

    public static final class Tuple
    extends HCLForExpression {
        public final HCLExpression result;

        public Tuple(HCLIdentifier keyVar, HCLIdentifier valueVar, HCLExpression iterable, HCLExpression condition, HCLExpression result) {
            super(keyVar, valueVar, iterable, condition);
            this.result = result;
        }

        @Override
        public String asString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[for ");
            if (this.keyVar != null) {
                sb.append(this.keyVar).append(',');
            }
            sb.append(this.valueVar).append(" in ").append(this.iterable.asString()).append(':');
            sb.append(this.result.asString());
            if (this.condition != null) {
                sb.append(" if ").append(this.condition.asString());
            }
            sb.append(']');
            return sb.toString();
        }

        @Override
        public List<? extends HCLExpression> getChildren() {
            return Arrays.asList(this.iterable, this.result, this.condition);
        }
    }
}

