/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.tooling.server.state;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.netbeans.modules.glassfish.tooling.GlassFishStatus;
import org.netbeans.modules.glassfish.tooling.GlassFishStatusListener;
import org.netbeans.modules.glassfish.tooling.data.GlassFishServer;
import org.netbeans.modules.glassfish.tooling.data.GlassFishServerStatus;
import org.netbeans.modules.glassfish.tooling.data.GlassFishStatusCheck;
import org.netbeans.modules.glassfish.tooling.logging.Logger;
import org.netbeans.modules.glassfish.tooling.server.state.AbstractTask;
import org.netbeans.modules.glassfish.tooling.server.state.AdminPortTask;
import org.netbeans.modules.glassfish.tooling.server.state.GlassFishStatusEntity;
import org.netbeans.modules.glassfish.tooling.server.state.RunnerTask;
import org.netbeans.modules.glassfish.tooling.server.state.StatusJob;
import org.netbeans.modules.glassfish.tooling.server.state.StatusJobState;

public class StatusScheduler {
    private static final Logger LOGGER = new Logger(StatusScheduler.class);
    private static ScheduledThreadPoolExecutor scheduledExecutor;
    private static volatile StatusScheduler instance;
    private static final int DEFAULT_INTERNAL_CORE_POOL_SIZE = 3;
    private static final long DELAY = 6000L;
    private static final long INITIAL_DELAY = 2000L;
    private static final long DELAY_STARTUP = 3000L;
    private static final long INITIAL_DELAY_STARTUP = 1000L;
    private static final int CONNECT_TIMEOUT = 5000;
    private ScheduledThreadPoolExecutor executor;
    private final Map<GlassFishServer, StatusJob> jobs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(ScheduledThreadPoolExecutor executor) {
        Class<StatusScheduler> clazz = StatusScheduler.class;
        synchronized (StatusScheduler.class) {
            if (instance != null) {
                throw new IllegalStateException();
            }
            scheduledExecutor = executor;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static ScheduledThreadPoolExecutor newScheduledExecutor() {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(3, new ThreadFactory());
        executor.setRemoveOnCancelPolicy(true);
        return executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StatusScheduler getInstance() {
        if (instance != null) {
            return instance;
        }
        Class<StatusScheduler> clazz = StatusScheduler.class;
        synchronized (StatusScheduler.class) {
            if (instance == null) {
                if (scheduledExecutor == null) {
                    scheduledExecutor = StatusScheduler.newScheduledExecutor();
                }
                instance = new StatusScheduler(scheduledExecutor);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static long selectDelay(StatusJobState state) {
        switch (state) {
            case STARTUP: 
            case STARTUP_PORT: 
            case SHUTDOWN: 
            case SHUTDOWN_PORT: {
                return 3000L;
            }
        }
        return 6000L;
    }

    private static long selectInitialDelay(StatusJobState state) {
        switch (state) {
            case STARTUP: 
            case STARTUP_PORT: 
            case SHUTDOWN: 
            case SHUTDOWN_PORT: {
                return 1000L;
            }
        }
        return 2000L;
    }

    private StatusScheduler(ScheduledThreadPoolExecutor executor) {
        this.executor = executor;
        this.jobs = new HashMap<GlassFishServer, StatusJob>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(GlassFishServer srv) {
        boolean result;
        Map<GlassFishServer, StatusJob> map = this.jobs;
        synchronized (map) {
            result = this.jobs.containsKey(srv);
        }
        return result;
    }

    public GlassFishServerStatus get(GlassFishServer srv, GlassFishStatusListener listener) {
        StatusJob job = this.getJob(srv);
        if (job != null) {
            if (job.getState() == StatusJobState.NO_CHECK) {
                job.restartJob(this, listener);
            }
            return job.getStatus();
        }
        return null;
    }

    public boolean start(GlassFishServer srv, boolean force, GlassFishStatusListener listener, GlassFishStatus ... newState) {
        StatusJob job = this.getJob(srv);
        return job != null ? job.startState(this, force, listener, newState) : false;
    }

    public boolean shutdown(GlassFishServer srv) {
        StatusJob job = this.getJob(srv);
        return job != null ? job.shutdownState(this) : false;
    }

    public boolean add(GlassFishStatusEntity status, GlassFishStatusListener listener, boolean currentState, GlassFishStatus ... newState) {
        StatusJob job = new StatusJob(status);
        job.addStatusListener(listener, currentState, newState);
        boolean result = this.addJob(job);
        if (result) {
            job.scheduleNew(this);
        }
        return result;
    }

    public boolean add(GlassFishStatusEntity status) {
        StatusJob job = new StatusJob(status);
        boolean result = this.addJob(job);
        if (result) {
            job.scheduleNew(this);
        }
        return result;
    }

    public boolean remove(GlassFishServer srv) {
        StatusJob job = this.removeJob(srv);
        if (job != null) {
            this.remove(job);
        }
        return job != null;
    }

    public boolean suspend(GlassFishServer srv) {
        StatusJob job = this.getJob(srv);
        if (job == null) {
            return false;
        }
        job.stopJob(this);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatusJob getJob(GlassFishServer srv) {
        StatusJob job;
        Map<GlassFishServer, StatusJob> map = this.jobs;
        synchronized (map) {
            job = this.jobs.get(srv);
        }
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addJob(StatusJob job) {
        Map<GlassFishServer, StatusJob> map = this.jobs;
        synchronized (map) {
            if (this.jobs.get(job.getStatus().getServer()) == null) {
                this.jobs.put(job.getStatus().getServer(), job);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatusJob removeJob(GlassFishServer srv) {
        StatusJob job;
        Map<GlassFishServer, StatusJob> map = this.jobs;
        synchronized (map) {
            job = this.jobs.remove(srv);
        }
        return job;
    }

    private ScheduledFuture scheduleLocationsTask(StatusJob job, long initialDelay) {
        RunnerTask runnerTask = new RunnerTask(job, job.getLocations(), GlassFishStatusCheck.LOCATIONS);
        long delay = StatusScheduler.selectDelay(job.getState());
        ScheduledFuture<?> scheduledFuture = this.executor.scheduleWithFixedDelay(runnerTask, initialDelay, delay, TimeUnit.MILLISECONDS);
        job.getLocations().setTaskFuture(runnerTask, scheduledFuture);
        return scheduledFuture;
    }

    private ScheduledFuture scheduleVersionTask(StatusJob job, long initialDelay) {
        RunnerTask runnerTask = new RunnerTask(job, job.getVersion(), GlassFishStatusCheck.VERSION);
        long delay = StatusScheduler.selectDelay(job.getState());
        ScheduledFuture<?> scheduledFuture = this.executor.scheduleWithFixedDelay(runnerTask, initialDelay, delay, TimeUnit.MILLISECONDS);
        job.getVersion().setTaskFuture(runnerTask, scheduledFuture);
        return scheduledFuture;
    }

    private ScheduledFuture scheduleLocationsTask(StatusJob job) {
        long initialDelay = StatusScheduler.selectInitialDelay(job.getState());
        return this.scheduleLocationsTask(job, initialDelay);
    }

    private ScheduledFuture scheduleVersionTask(StatusJob job) {
        long initialDelay = StatusScheduler.selectInitialDelay(job.getState());
        return this.scheduleVersionTask(job, initialDelay);
    }

    private ScheduledFuture scheduleAdminPortTask(StatusJob job) {
        AdminPortTask portTask = new AdminPortTask(job, job.getPortCheck(), 5000);
        long delay = StatusScheduler.selectDelay(job.getState());
        long initialDelay = StatusScheduler.selectInitialDelay(job.getState());
        ScheduledFuture<?> scheduledFuture = this.executor.scheduleWithFixedDelay(portTask, initialDelay, delay, TimeUnit.MILLISECONDS);
        job.getPortCheck().setTaskFuture(portTask, scheduledFuture);
        return scheduledFuture;
    }

    void cancel(StatusJob.Task task) {
        AbstractTask runnable;
        ScheduledFuture future = task.getFuture();
        if (future != null) {
            future.cancel(true);
        }
        if ((runnable = task.getTask()) != null) {
            runnable.cancel();
            this.executor.remove(runnable);
        }
        task.clearTaskFuture();
    }

    private void portCheckOnly(StatusJob job) {
        this.scheduleAdminPortTask(job);
        job.getVersion().clearTaskFuture();
        job.getLocations().clearTaskFuture();
    }

    private void localChecksAtOnce(StatusJob job) {
        this.scheduleAdminPortTask(job);
        this.scheduleLocationsTask(job);
        job.getVersion().clearTaskFuture();
    }

    private void localChecksStepByStep(StatusJob job) {
        long delay = StatusScheduler.selectDelay(job.getState());
        long initialDelay = StatusScheduler.selectInitialDelay(job.getState());
        this.scheduleAdminPortTask(job);
        this.scheduleLocationsTask(job, initialDelay + delay / 2L);
        job.getVersion().clearTaskFuture();
    }

    private void localChecksCommand(StatusJob job) {
        long initialDelay = StatusScheduler.selectInitialDelay(job.getState());
        this.scheduleLocationsTask(job, initialDelay);
        job.getPortCheck().clearTaskFuture();
        job.getVersion().clearTaskFuture();
    }

    private void remoteChecksAtOnce(StatusJob job) {
        this.scheduleAdminPortTask(job);
        this.scheduleVersionTask(job);
        job.getLocations().clearTaskFuture();
    }

    private void remoteChecksStepByStep(StatusJob job) {
        long delay = StatusScheduler.selectDelay(job.getState());
        long initialDelay = StatusScheduler.selectInitialDelay(job.getState());
        this.scheduleAdminPortTask(job);
        this.scheduleVersionTask(job, initialDelay + delay / 2L);
        job.getLocations().clearTaskFuture();
    }

    private void remoteChecksCommand(StatusJob job) {
        long initialDelay = StatusScheduler.selectInitialDelay(job.getState());
        this.scheduleVersionTask(job, initialDelay);
        job.getPortCheck().clearTaskFuture();
        job.getLocations().clearTaskFuture();
    }

    private void noChecks(StatusJob job) {
        job.getPortCheck().clearTaskFuture();
        job.getLocations().clearTaskFuture();
        job.getVersion().clearTaskFuture();
    }

    void remove(StatusJob job) {
        this.cancel(job.getPortCheck());
        this.cancel(job.getVersion());
        this.cancel(job.getLocations());
        this.executor.purge();
    }

    void scheduleNew(StatusJob job) {
        String METHOD = "scheduleNew";
        switch (job.getState()) {
            case UNKNOWN: {
                this.portCheckOnly(job);
                return;
            }
        }
        throw new IllegalStateException(LOGGER.excMsg("scheduleNew", "illegalState"));
    }

    void reschedule(StatusJob job) {
        String METHOD = "reschedule";
        switch (job.getState()) {
            case NO_CHECK: {
                this.noChecks(job);
                return;
            }
            case STARTUP: 
            case SHUTDOWN_PORT: 
            case UNKNOWN: 
            case OFFLINE: {
                this.portCheckOnly(job);
                return;
            }
            case ONLINE: {
                if (job.getStatus().getServer().isRemote()) {
                    this.remoteChecksCommand(job);
                } else {
                    this.localChecksCommand(job);
                }
                return;
            }
            case SHUTDOWN: {
                if (job.getStatus().getServer().isRemote()) {
                    this.remoteChecksStepByStep(job);
                } else {
                    this.localChecksStepByStep(job);
                }
                return;
            }
            case STARTUP_PORT: 
            case OFFLINE_PORT: 
            case UNKNOWN_PORT: {
                if (job.getStatus().getServer().isRemote()) {
                    this.remoteChecksAtOnce(job);
                } else {
                    this.localChecksAtOnce(job);
                }
                return;
            }
        }
        throw new IllegalStateException(LOGGER.excMsg("reschedule", "unhandled"));
    }

    private static final class ThreadFactory
    implements java.util.concurrent.ThreadFactory {
        private static final String THREAD_NAME = "GlassFish Status Tasks";
        private static final ThreadGroup threadGroup = ThreadFactory.initThreadGroup();

        private ThreadFactory() {
        }

        private static ThreadGroup initThreadGroup() {
            ThreadGroup tg = Thread.currentThread().getThreadGroup();
            if (tg != null) {
                ThreadGroup tgParrent;
                while ((tgParrent = tg.getParent()) != null) {
                    tg = tgParrent;
                }
            }
            return new ThreadGroup(tg, THREAD_NAME);
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(threadGroup, r, THREAD_NAME);
            t.setDaemon(true);
            return t;
        }
    }
}

