/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.tooling.server.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.glassfish.tooling.server.parser.TreeParser;
import org.netbeans.modules.glassfish.tooling.server.parser.XMLReader;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class JvmConfigReader
extends TreeParser.NodeListener
implements XMLReader {
    private static String JVM_OPTIONS_TAG = "jvm-options";
    private String serverName;
    private ArrayList<String> optList = new ArrayList();
    private HashMap<String, String> propMap = new HashMap();
    private boolean isMonitoringEnabled = false;
    private String serverConfigName;
    private boolean readConfig = false;
    private StringBuilder b = new StringBuilder();

    public JvmConfigReader(String serverName) {
        this.serverName = serverName;
    }

    public TreeParser.NodeListener getServerFinder() {
        return new TreeParser.NodeListener(){

            @Override
            public void readAttributes(String qname, Attributes attributes) throws SAXException {
                if ((JvmConfigReader.this.serverConfigName == null || JvmConfigReader.this.serverConfigName.length() == 0) && JvmConfigReader.this.serverName.equals(attributes.getValue("name"))) {
                    JvmConfigReader.this.serverConfigName = attributes.getValue("config-ref");
                }
            }
        };
    }

    public TreeParser.NodeListener getConfigFinder() {
        return new TreeParser.NodeListener(){

            @Override
            public void readAttributes(String qname, Attributes attributes) throws SAXException {
                if (JvmConfigReader.this.serverConfigName != null && JvmConfigReader.this.serverConfigName.equals(attributes.getValue("name"))) {
                    JvmConfigReader.this.readConfig = true;
                }
            }

            @Override
            public void endNode(String qname) throws SAXException {
                if ("config".equals(qname)) {
                    JvmConfigReader.this.readConfig = false;
                }
            }
        };
    }

    @Override
    public void readAttributes(String qname, Attributes attributes) throws SAXException {
        if (this.readConfig) {
            int attrLen = attributes.getLength();
            for (int i = 0; i < attrLen; ++i) {
                String name = attributes.getLocalName(i);
                if (name == null || name.isEmpty()) {
                    name = attributes.getQName(i);
                }
                String value = attributes.getValue(i);
                if (name == null || name.length() <= 0 || value == null || value.length() <= 0) continue;
                this.propMap.put(name, value);
            }
        }
    }

    @Override
    public void readCData(String qname, char[] ch, int start, int length) throws SAXException {
        if (this.readConfig && JVM_OPTIONS_TAG.equals(qname)) {
            this.b.append(ch, start, length);
        }
    }

    @Override
    public void endNode(String qname) throws SAXException {
        if (this.readConfig && JVM_OPTIONS_TAG.equals(qname)) {
            this.optList.add(this.b.toString());
            this.b.delete(0, this.b.length());
        }
    }

    public TreeParser.NodeListener getMonitoringFinder() {
        return new TreeParser.NodeListener(){

            @Override
            public void readAttributes(String qname, Attributes attributes) throws SAXException {
                if (JvmConfigReader.this.readConfig) {
                    JvmConfigReader.this.isMonitoringEnabled = !"false".equals(attributes.getValue("monitoring-enabled"));
                }
            }
        };
    }

    @Override
    public List<TreeParser.Path> getPathsToListen() {
        LinkedList<TreeParser.Path> paths = new LinkedList<TreeParser.Path>();
        paths.add(new TreeParser.Path("/domain/servers/server", this.getServerFinder()));
        paths.add(new TreeParser.Path("/domain/configs/config", this.getConfigFinder()));
        paths.add(new TreeParser.Path("/domain/configs/config/java-config", this));
        paths.add(new TreeParser.Path("/domain/configs/config/monitoring-service", this.getMonitoringFinder()));
        return paths;
    }

    public List<String> getOptList() {
        return this.optList;
    }

    public Map<String, String> getPropMap() {
        return this.propMap;
    }

    public boolean isMonitoringEnabled() {
        return this.isMonitoringEnabled;
    }
}

