/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.ui.wizard;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.maven.api.MavenValidators;
import org.netbeans.modules.maven.api.archetype.ProjectInfo;
import org.netbeans.modules.maven.j2ee.ui.wizard.Bundle;
import org.netbeans.modules.maven.j2ee.ui.wizard.EAWizardPanel;
import org.netbeans.modules.maven.j2ee.ui.wizard.ServerSelectionHelper;
import org.netbeans.modules.maven.j2ee.ui.wizard.archetype.J2eeArchetypeFactory;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.ValidatorUtils;
import org.netbeans.validation.api.builtin.stringvalidation.StringValidators;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.ValidationItem;
import org.netbeans.validation.api.ui.ValidationUI;
import org.netbeans.validation.api.ui.swing.SwingValidationGroup;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class EAVisualPanel
extends JPanel {
    private EAWizardPanel panel;
    private final ValidationGroup vg;
    private final ServerSelectionHelper helper;
    private JButton addButton;
    private JCheckBox chkEjb;
    private JCheckBox chkWeb;
    private JComboBox j2eeVersion;
    private JLabel jLabel1;
    private JLabel lblEEVersion;
    private JLabel lblEar;
    private JComboBox serverModel;
    private JTextField tfEar;
    private JTextField tfEjb;
    private JTextField tfWeb;

    public EAVisualPanel(EAWizardPanel panel) {
        this.panel = panel;
        this.initComponents();
        this.helper = new ServerSelectionHelper(this.serverModel, this.j2eeVersion, J2eeModule.Type.EAR);
        this.vg = ValidationGroup.create((ValidationUI[])new ValidationUI[0]);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                EAVisualPanel.this.addArtifactIdValidatorFor(EAVisualPanel.this.tfWeb);
                EAVisualPanel.this.addArtifactIdValidatorFor(EAVisualPanel.this.tfEar);
                EAVisualPanel.this.addArtifactIdValidatorFor(EAVisualPanel.this.tfEjb);
            }
        };
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            EventQueue.invokeLater(r);
        }
        SwingValidationGroup.setComponentName((JComponent)this.tfWeb, (String)"Web ArtifactId");
        SwingValidationGroup.setComponentName((JComponent)this.tfEar, (String)"Ear ArtifactId");
        SwingValidationGroup.setComponentName((JComponent)this.tfEjb, (String)"Ejb ArtifactId");
        this.getAccessibleContext().setAccessibleDescription(Bundle.LBL_EESettings());
    }

    private void addArtifactIdValidatorFor(JTextField textField) {
        this.vg.add((Object)textField, ValidatorUtils.merge((Validator)MavenValidators.createArtifactIdValidators(), (Validator)StringValidators.REQUIRE_VALID_FILENAME));
    }

    @Override
    public String getName() {
        return Bundle.LBL_EESettings();
    }

    void readSettings(WizardDescriptor wizardDescriptor) {
        this.fillTextFields(wizardDescriptor);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EAVisualPanel.this.panel.getValidationGroup().addItem((ValidationItem)EAVisualPanel.this.vg, true);
            }
        });
    }

    void storeSettings(WizardDescriptor d) {
        File parent = (File)d.getProperty("projdir");
        Profile profile = this.helper.getSelectedProfile();
        if (profile == null) {
            profile = Profile.JAVA_EE_8_FULL;
        }
        this.helper.storeServerSettings(d);
        this.storeEarSettings(d, profile, parent);
        this.storeEjbSettings(d, profile, parent);
        this.storeWebSettings(d, profile, parent);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EAVisualPanel.this.panel.getValidationGroup().remove((ValidationItem)EAVisualPanel.this.vg);
            }
        });
    }

    private void storeEarSettings(WizardDescriptor d, Profile profile, File parent) {
        String earText = this.tfEar.getText().trim();
        d.putProperty("ear_projdir", (Object)new File(parent, earText));
        d.putProperty("ear_versionInfo", (Object)this.createProjectInfo(d, earText));
        d.putProperty("ear_archetype", (Object)J2eeArchetypeFactory.getInstance().findArchetypeFor(J2eeModule.Type.EAR, profile));
    }

    private void storeEjbSettings(WizardDescriptor d, Profile profile, File parent) {
        if (this.chkEjb.isSelected()) {
            String ejbText = this.tfEjb.getText().trim();
            d.putProperty("ejb_projdir", (Object)new File(parent, ejbText));
            d.putProperty("ejb_versionInfo", (Object)this.createProjectInfo(d, ejbText));
            d.putProperty("ejb_archetype", (Object)J2eeArchetypeFactory.getInstance().findArchetypeFor(J2eeModule.Type.EJB, profile));
        } else {
            d.putProperty("ejb_projdir", null);
            d.putProperty("ejb_versionInfo", null);
            d.putProperty("ejb_archetype", null);
        }
    }

    private void storeWebSettings(WizardDescriptor d, Profile profile, File parent) {
        if (this.chkWeb.isSelected()) {
            String webText = this.tfWeb.getText().trim();
            d.putProperty("web_projdir", (Object)new File(parent, webText));
            d.putProperty("web_versionInfo", (Object)this.createProjectInfo(d, webText));
            d.putProperty("web_archetype", (Object)J2eeArchetypeFactory.getInstance().findArchetypeFor(J2eeModule.Type.WAR, profile));
        } else {
            d.putProperty("web_projdir", null);
            d.putProperty("web_versionInfo", null);
            d.putProperty("web_archetype", null);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EAVisualPanel.this.panel.getValidationGroup().remove((ValidationItem)EAVisualPanel.this.vg);
            }
        });
    }

    private ProjectInfo createProjectInfo(WizardDescriptor d, String artifactId) {
        return new ProjectInfo((String)d.getProperty("groupId"), artifactId, (String)d.getProperty("version"), null);
    }

    private void fillTextFields(WizardDescriptor wiz) {
        String artifactId = (String)wiz.getProperty("artifactId");
        this.tfEar.setText(artifactId + "-ear");
        this.tfWeb.setText(artifactId + "-web");
        this.tfEjb.setText(artifactId + "-ejb");
    }

    private void initComponents() {
        this.j2eeVersion = new JComboBox();
        this.lblEEVersion = new JLabel();
        this.chkEjb = new JCheckBox();
        this.chkWeb = new JCheckBox();
        this.lblEar = new JLabel();
        this.tfWeb = new JTextField();
        this.tfEjb = new JTextField();
        this.tfEar = new JTextField();
        this.jLabel1 = new JLabel();
        this.serverModel = new JComboBox();
        this.addButton = new JButton();
        this.lblEEVersion.setLabelFor(this.j2eeVersion);
        Mnemonics.setLocalizedText((JLabel)this.lblEEVersion, (String)NbBundle.getMessage(EAVisualPanel.class, (String)"EAVisualPanel.lblEEVersion.text"));
        this.chkEjb.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.chkEjb, (String)NbBundle.getMessage(EAVisualPanel.class, (String)"EAVisualPanel.chkEjb.text"));
        this.chkEjb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EAVisualPanel.this.chkEjbActionPerformed(evt);
            }
        });
        this.chkWeb.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.chkWeb, (String)NbBundle.getMessage(EAVisualPanel.class, (String)"EAVisualPanel.chkWeb.text"));
        this.chkWeb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EAVisualPanel.this.chkWebActionPerformed(evt);
            }
        });
        this.lblEar.setLabelFor(this.tfEar);
        Mnemonics.setLocalizedText((JLabel)this.lblEar, (String)NbBundle.getMessage(EAVisualPanel.class, (String)"EAVisualPanel.lblEar.text"));
        this.tfWeb.setText(NbBundle.getMessage(EAVisualPanel.class, (String)"EAVisualPanel.tfWeb.text"));
        this.tfEjb.setText(NbBundle.getMessage(EAVisualPanel.class, (String)"EAVisualPanel.tfEjb.text"));
        this.tfEar.setText(NbBundle.getMessage(EAVisualPanel.class, (String)"EAVisualPanel.tfEar.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(EAVisualPanel.class, (String)"EAVisualPanel.jLabel1.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(EAVisualPanel.class, (String)"EAVisualPanel.addButton.text"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EAVisualPanel.this.addButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblEEVersion).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.j2eeVersion, -2, -1, -2).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.serverModel, 0, 315, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addButton)))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chkWeb).addComponent(this.chkEjb).addComponent(this.lblEar)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tfEar, -1, 216, Short.MAX_VALUE).addComponent(this.tfWeb, -1, 216, Short.MAX_VALUE).addComponent(this.tfEjb, -1, 216, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 69, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.serverModel, -2, -1, -2).addComponent(this.addButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblEEVersion).addComponent(this.j2eeVersion, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chkEjb).addComponent(this.tfEjb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.chkWeb).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblEar)).addGroup(layout.createSequentialGroup().addComponent(this.tfWeb, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfEar, -2, -1, -2))).addContainerGap(145, Short.MAX_VALUE)));
        this.j2eeVersion.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EAVisualPanel.class, (String)"EAVisualPanel.cmbEEVersion.AccessibleContext.accessibleDescription"));
        this.chkEjb.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EAVisualPanel.class, (String)"EAVisualPanel.chkEjb.AccessibleContext.accessibleDescription"));
        this.chkWeb.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EAVisualPanel.class, (String)"EAVisualPanel.chkWeb.AccessibleContext.accessibleDescription"));
        this.tfWeb.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EAVisualPanel.class, (String)"EAVisualPanel.tfWeb.AccessibleContext.accessibleName"));
        this.tfWeb.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EAVisualPanel.class, (String)"EAVisualPanel.tfWeb.AccessibleContext.accessibleDescription"));
        this.tfEjb.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EAVisualPanel.class, (String)"EAVisualPanel.tfEjb.AccessibleContext.accessibleName"));
        this.tfEjb.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EAVisualPanel.class, (String)"EAVisualPanel.tfEjb.AccessibleContext.accessibleDescription"));
        this.tfEar.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EAVisualPanel.class, (String)"EAVisualPanel.tfEar.AccessibleContext.accessibleDescription"));
    }

    private void chkEjbActionPerformed(ActionEvent evt) {
        this.tfEjb.setEnabled(this.chkEjb.isSelected());
        this.vg.performValidation();
    }

    private void chkWebActionPerformed(ActionEvent evt) {
        this.tfWeb.setEnabled(this.chkWeb.isSelected());
        this.vg.performValidation();
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        this.helper.addServerButtonPressed();
    }
}

