/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2ee.api.ejbjar.Ear;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.javaee.project.api.JavaEEProjectSettings;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.customizer.ModelHandle2;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.modules.maven.j2ee.OneTimeDeployment;
import org.netbeans.modules.maven.j2ee.SessionContent;
import org.netbeans.modules.maven.j2ee.execution.ExecutionChecker;
import org.netbeans.modules.maven.j2ee.ui.SelectProjectPanel;
import org.netbeans.modules.maven.j2ee.utils.LoggingUtils;
import org.netbeans.modules.maven.j2ee.utils.MavenProjectSupport;
import org.netbeans.modules.maven.j2ee.utils.Server;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.ProjectConfigurationProvider;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class SelectAppServerPanel
extends JPanel {
    private NotificationLineSupport nls;
    private Project project;
    private JButton btChange;
    private ButtonGroup buttonGroup1;
    private JComboBox comServer;
    private JLabel lblProject;
    private JLabel lblServer;
    private JRadioButton rbDontRemember;
    JRadioButton rbIgnore;
    JRadioButton rbPermanent;
    JRadioButton rbSession;

    private SelectAppServerPanel(boolean showIgnore, Project project) {
        this.project = project;
        this.initComponents();
        this.loadComboModel();
        if (showIgnore) {
            this.checkIgnoreEnablement();
            this.comServer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SelectAppServerPanel.this.checkIgnoreEnablement();
                }
            });
            this.rbIgnore.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    SelectAppServerPanel.this.printIgnoreWarning();
                }
            });
        } else {
            this.rbIgnore.setVisible(false);
        }
        this.updateProjectLbl();
        this.rbPermanentStateChanged(null);
    }

    public static boolean showServerSelectionDialog(Project project, J2eeModuleProvider provider, RunConfig config) {
        if ("DEV-NULL".equals(provider.getServerInstanceID())) {
            SelectAppServerPanel panel = new SelectAppServerPanel(SelectAppServerPanel.isGoalOverridden(config), project);
            DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(SelectAppServerPanel.class, (String)"TIT_Select"));
            panel.setNLS(dd.createNotificationLineSupport());
            Object obj = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
            if (obj == NotifyDescriptor.OK_OPTION) {
                String instanceId = panel.getSelectedServerInstance();
                String serverId = panel.getSelectedServerType();
                if (!"DEV-NULL".equals(instanceId)) {
                    boolean permanent = panel.isPermanent();
                    boolean doNotRemember = panel.isDoNotRemember();
                    if (doNotRemember) {
                        OneTimeDeployment oneTimeDeployment = (OneTimeDeployment)project.getLookup().lookup(OneTimeDeployment.class);
                        if (oneTimeDeployment != null) {
                            oneTimeDeployment.setServerInstanceId(instanceId);
                        }
                        MavenProjectSupport.changeServer(project, true);
                    } else if (permanent) {
                        SelectAppServerPanel.persistServer(project, instanceId, serverId, panel.getChosenProject());
                    } else {
                        SessionContent sc = (SessionContent)project.getLookup().lookup(SessionContent.class);
                        if (sc != null) {
                            sc.setServerInstanceId(instanceId);
                        }
                        MavenProjectSupport.changeServer(project, true);
                    }
                    LoggingUtils.logUsage(ExecutionChecker.class, "USG_PROJECT_CONFIG_MAVEN_SERVER", new Object[]{MavenProjectSupport.obtainServerName(project)}, "maven");
                    return true;
                }
                if (panel.isIgnored() && config != null) {
                    SelectAppServerPanel.removeNetbeansDeployFromActionMappings(project, config.getActionName());
                    return true;
                }
            }
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(SelectAppServerPanel.class, (String)"ERR_Action_without_deployment_server"));
            return false;
        }
        return true;
    }

    private static void removeNetbeansDeployFromActionMappings(Project project, String actionName) {
        try {
            ProjectConfiguration cfg = ((ProjectConfigurationProvider)project.getLookup().lookup(ProjectConfigurationProvider.class)).getActiveConfiguration();
            NetbeansActionMapping mapp = ModelHandle2.getMapping((String)actionName, (Project)project, (ProjectConfiguration)cfg);
            if (mapp != null) {
                mapp.getProperties().remove("netbeans.deploy");
                ModelHandle2.putMapping((NetbeansActionMapping)mapp, (Project)project, (ProjectConfiguration)cfg);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static boolean isGoalOverridden(RunConfig config) {
        if (config == null) {
            return false;
        }
        return !config.getGoals().isEmpty();
    }

    private static void persistServer(Project project, String iID, String sID, Project targetPrj) {
        JavaEEProjectSettings.setServerInstanceID((Project)project, (String)iID);
        MavenProjectSupport.setServerID(project, sID);
        MavenProjectSupport.changeServer(project, true);
        SubprojectProvider spp = (SubprojectProvider)targetPrj.getLookup().lookup(SubprojectProvider.class);
        Set childrenProjs = spp.getSubprojects();
        if (!childrenProjs.contains(project)) {
            NbMavenProject.fireMavenProjectReload((Project)project);
        }
        for (Project curPrj : childrenProjs) {
            NbMavenProject.fireMavenProjectReload((Project)curPrj);
        }
    }

    private String getSelectedServerType() {
        return ((Server)this.comServer.getSelectedItem()).getServerID();
    }

    private String getSelectedServerInstance() {
        return ((Server)this.comServer.getSelectedItem()).getServerInstanceID();
    }

    private boolean isPermanent() {
        return this.rbPermanent.isSelected();
    }

    private boolean isIgnored() {
        return this.rbIgnore.isSelected();
    }

    private boolean isDoNotRemember() {
        return this.rbDontRemember.isSelected();
    }

    private Project getChosenProject() {
        return this.project;
    }

    private void loadComboModel() {
        J2eeModule.Type type;
        Ear ear = Ear.getEar((FileObject)this.project.getProjectDirectory());
        EjbJar ejb = EjbJar.getEjbJar((FileObject)this.project.getProjectDirectory());
        WebModule war = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
        J2eeModule.Type type2 = ear != null ? J2eeModule.Type.EAR : (war != null ? J2eeModule.Type.WAR : (type = ejb != null ? J2eeModule.Type.EJB : J2eeModule.Type.CAR));
        Profile profile = ear != null ? ear.getJ2eeProfile() : (war != null ? war.getJ2eeProfile() : (ejb != null ? ejb.getJ2eeProfile() : Profile.JAVA_EE_6_FULL));
        String[] ids = Deployment.getDefault().getServerInstanceIDs(Collections.singletonList(type), profile);
        ArrayList<Server> col = new ArrayList<Server>();
        col.add(new Server("DEV-NULL"));
        for (int i = 0; i < ids.length; ++i) {
            Server wr = new Server(ids[i]);
            col.add(wr);
        }
        this.comServer.setModel(new DefaultComboBoxModel<Object>(col.toArray()));
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.lblServer = new JLabel();
        this.comServer = new JComboBox();
        this.rbSession = new JRadioButton();
        this.rbPermanent = new JRadioButton();
        this.rbIgnore = new JRadioButton();
        this.lblProject = new JLabel();
        this.btChange = new JButton();
        this.rbDontRemember = new JRadioButton();
        this.lblServer.setLabelFor(this.comServer);
        Mnemonics.setLocalizedText((JLabel)this.lblServer, (String)NbBundle.getMessage(SelectAppServerPanel.class, (String)"SelectAppServerPanel.lblServer.text"));
        this.buttonGroup1.add(this.rbSession);
        Mnemonics.setLocalizedText((AbstractButton)this.rbSession, (String)NbBundle.getMessage(SelectAppServerPanel.class, (String)"SelectAppServerPanel.rbSession.text"));
        this.buttonGroup1.add(this.rbPermanent);
        Mnemonics.setLocalizedText((AbstractButton)this.rbPermanent, (String)NbBundle.getMessage(SelectAppServerPanel.class, (String)"SelectAppServerPanel.rbPermanent.text"));
        this.rbPermanent.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SelectAppServerPanel.this.rbPermanentStateChanged(evt);
            }
        });
        this.buttonGroup1.add(this.rbIgnore);
        Mnemonics.setLocalizedText((AbstractButton)this.rbIgnore, (String)NbBundle.getBundle(SelectAppServerPanel.class).getString("SelectAppServerPanel.rbIgnore.text"));
        this.lblProject.setFont(this.lblProject.getFont().deriveFont((float)this.lblProject.getFont().getSize() - 1.0f));
        Mnemonics.setLocalizedText((JLabel)this.lblProject, (String)NbBundle.getMessage(SelectAppServerPanel.class, (String)"SelectAppServerPanel.lblProject.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btChange, (String)NbBundle.getMessage(SelectAppServerPanel.class, (String)"SelectAppServerPanel.btChange.text"));
        this.btChange.setToolTipText(NbBundle.getMessage(SelectAppServerPanel.class, (String)"SelectAppServerPanel.btChange.toolTipText"));
        this.btChange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectAppServerPanel.this.btChangeActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.rbDontRemember);
        this.rbDontRemember.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.rbDontRemember, (String)NbBundle.getMessage(SelectAppServerPanel.class, (String)"SelectAppServerPanel.rbDontRemember.text"));
        this.rbDontRemember.setToolTipText(NbBundle.getMessage(SelectAppServerPanel.class, (String)"SelectAppServerPanel.rbDontRemember.toolTipText"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.lblServer).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comServer, 0, 443, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.rbPermanent).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btChange)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rbIgnore).addGroup(layout.createSequentialGroup().addGap(11, 11, 11).addComponent(this.lblProject)).addComponent(this.rbDontRemember).addComponent(this.rbSession)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblServer).addComponent(this.comServer, -2, -1, -2)).addGap(32, 32, 32).addComponent(this.rbDontRemember).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.rbSession).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btChange, -2, 23, -2).addComponent(this.rbPermanent)).addGap(18, 18, 18).addComponent(this.lblProject).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.rbIgnore).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void rbPermanentStateChanged(ChangeEvent evt) {
        boolean isSel = this.rbPermanent.isSelected();
        this.btChange.setEnabled(isSel);
        this.lblProject.setEnabled(isSel);
        if (this.nls != null) {
            if (isSel) {
                this.nls.setInformationMessage(NbBundle.getMessage(SelectAppServerPanel.class, (String)"MSG_ParentHint"));
            } else {
                this.nls.clearMessages();
            }
        }
    }

    private void btChangeActionPerformed(ActionEvent evt) {
        SelectProjectPanel spp = new SelectProjectPanel(this.project);
        DialogDescriptor dd = new DialogDescriptor((Object)spp, NbBundle.getMessage(SelectAppServerPanel.class, (String)"TIT_ChooseParent"));
        spp.attachDD(dd);
        Object obj = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        if (obj == NotifyDescriptor.OK_OPTION) {
            this.project = spp.getSelectedProject();
            this.updateProjectLbl();
        }
    }

    private void checkIgnoreEnablement() {
        String selectedServer = this.getSelectedServerType();
        if (selectedServer == null || "DEV-NULL".equals(selectedServer)) {
            this.rbIgnore.setEnabled(true);
        } else {
            if (this.rbIgnore.isSelected()) {
                this.rbSession.setSelected(true);
            }
            this.rbIgnore.setEnabled(false);
        }
    }

    private void setNLS(NotificationLineSupport notif) {
        this.nls = notif;
    }

    private void printIgnoreWarning() {
        if (this.rbIgnore.isSelected()) {
            this.nls.setWarningMessage(NbBundle.getMessage(SelectAppServerPanel.class, (String)"WARN_Ignore_Server"));
        } else {
            this.nls.clearMessages();
        }
    }

    private void updateProjectLbl() {
        ProjectInformation pi = ProjectUtils.getInformation((Project)this.project);
        if (pi != null) {
            this.lblProject.setText(NbBundle.getMessage(SelectAppServerPanel.class, (String)"MSG_InProject", (Object)pi.getDisplayName()));
        }
    }
}

