/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.execution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.api.extexecution.startup.StartupExtender;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.maven.api.execute.ActiveJ2SEPlatformProvider;
import org.netbeans.modules.maven.api.execute.ExecutionContext;
import org.netbeans.modules.maven.api.execute.LateBoundPrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.PrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.j2ee.execution.DeploymentHelper;
import org.netbeans.modules.maven.j2ee.execution.DeploymentLogger;
import org.netbeans.modules.maven.j2ee.web.WebModuleProviderImpl;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class PrerequisitesCheckerImpl
implements PrerequisitesChecker,
LateBoundPrerequisitesChecker {
    private final List<String> SINGLE_ACTIONS = Arrays.asList("run.single.deploy", "debug.single.deploy", "profile.deploy");
    private final List applicableActions = Arrays.asList("run", "run.single.deploy", "debug", "debug.single.deploy", "profile", "profile.deploy");

    public boolean checkRunConfig(RunConfig config) {
        String urlPath;
        Boolean alwaysBuild;
        String actionName = config.getActionName();
        if ("profile.test.single".equals(actionName)) {
            StartupExtender.StartMode mode = StartupExtender.StartMode.TEST_PROFILE;
            for (Map.Entry entry : config.getProperties().entrySet()) {
                if (!((String)entry.getKey()).equals("exec.args")) continue;
                ArrayList args = new ArrayList();
                InstanceContent ic = new InstanceContent();
                Project p = config.getProject();
                if (p != null) {
                    ic.add((Object)p);
                    ActiveJ2SEPlatformProvider pp = (ActiveJ2SEPlatformProvider)p.getLookup().lookup(ActiveJ2SEPlatformProvider.class);
                    if (pp != null) {
                        ic.add((Object)pp.getJavaPlatform());
                    }
                }
                for (StartupExtender group : StartupExtender.getExtenders((Lookup)new AbstractLookup((AbstractLookup.Content)ic), (StartupExtender.StartMode)mode)) {
                    args.addAll(group.getArguments());
                }
                if (args.isEmpty()) continue;
                StringBuilder b = new StringBuilder();
                for (String arg : args) {
                    b.append(arg).append(' ');
                }
                b.append((String)entry.getValue());
                config.setProperty((String)entry.getKey(), b.toString());
            }
        }
        if ((alwaysBuild = (Boolean)config.getProject().getProjectDirectory().getAttribute("netbeans.always.build")) == null) {
            alwaysBuild = Boolean.FALSE;
        }
        if (DeploymentHelper.isProfileMode(config)) {
            alwaysBuild = Boolean.TRUE;
        }
        Boolean standardExecution = Boolean.FALSE;
        if ("run.single.main".equals(actionName) || "debug.single.main".equals(actionName) || "profile.single.main".equals(actionName)) {
            standardExecution = Boolean.TRUE;
        }
        config.setInternalProperty("skip.build", (Object)(alwaysBuild == false ? 1 : 0));
        config.setInternalProperty("standard.execution", (Object)standardExecution);
        if (!this.applicableActions.contains(actionName)) {
            return true;
        }
        if (this.SINGLE_ACTIONS.contains(actionName) && ((urlPath = (String)config.getProperties().get("netbeans.deploy.clientUrlPart")) == null || "".equals(urlPath))) {
            return false;
        }
        J2eeModuleProvider provider = (J2eeModuleProvider)config.getProject().getLookup().lookup(J2eeModuleProvider.class);
        if (provider != null) {
            this.checkWarInplace(config, provider);
        }
        return true;
    }

    private void checkWarInplace(RunConfig config, J2eeModuleProvider provider) {
        if (provider instanceof WebModuleProviderImpl) {
            Iterator it = config.getGoals().iterator();
            boolean inplace = false;
            while (it.hasNext()) {
                String goal = (String)it.next();
                if (goal.indexOf(":inplace") <= -1) continue;
                inplace = true;
                break;
            }
            ((WebModuleProviderImpl)provider).getModuleImpl().setWarInplace(inplace);
        }
    }

    public boolean checkRunConfig(RunConfig config, ExecutionContext con) {
        String actionName = config.getActionName();
        if (!"clean".equals(actionName) && !"rebuild".equals(actionName)) {
            return true;
        }
        J2eeModuleProvider provider = (J2eeModuleProvider)config.getProject().getLookup().lookup(J2eeModuleProvider.class);
        if (provider != null) {
            String serverID = provider.getServerID();
            String serverInstanceID = provider.getServerInstanceID();
            if (serverID == null || serverInstanceID == null || "DEV-NULL".equals(serverID) || "DEV-NULL".equals(serverInstanceID)) {
                return true;
            }
            try {
                Deployment.getDefault().undeploy(provider, false, (Deployment.Logger)new DeploymentLogger(con.getInputOutput().getOut()));
            }
            catch (Deployment.DeploymentException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return true;
    }
}

