/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import com.sun.tools.javac.util.JCDiagnostic;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.tools.Diagnostic;
import org.netbeans.modules.java.source.parsing.CompilationInfoImpl;

public class Hacks {
    private static final Logger LOG = Logger.getLogger(Hacks.class.getName());

    public static boolean isSyntaxError(Diagnostic<?> d) {
        JCDiagnostic jcd = Hacks.getJCDiagnostic(d);
        if (jcd == null) {
            return false;
        }
        return jcd.isFlagSet(JCDiagnostic.DiagnosticFlag.SYNTAX);
    }

    public static Diagnostic[] getNestedDiagnostics(Diagnostic<?> d) {
        ArrayList<Diagnostic> diags = new ArrayList<Diagnostic>();
        Hacks.getNestedDiagnostics(d, diags);
        if (diags.isEmpty()) {
            return null;
        }
        return diags.toArray(new Diagnostic[diags.size()]);
    }

    private static void getNestedDiagnostics(Diagnostic<?> d, List<Diagnostic> diags) {
        JCDiagnostic jcd = Hacks.getJCDiagnostic(d);
        if (jcd == null) {
            return;
        }
        Object[] args = jcd.getArgs();
        if (args == null || args.length == 0) {
            return;
        }
        for (Object o : args) {
            if (!(o instanceof Diagnostic)) continue;
            diags.add((Diagnostic)o);
            Hacks.getNestedDiagnostics((Diagnostic)o, diags);
            break;
        }
    }

    private static JCDiagnostic getJCDiagnostic(Diagnostic<?> d) {
        if (d instanceof JCDiagnostic) {
            return (JCDiagnostic)d;
        }
        if (d instanceof CompilationInfoImpl.RichDiagnostic && ((CompilationInfoImpl.RichDiagnostic)d).getDelegate() instanceof JCDiagnostic) {
            return ((CompilationInfoImpl.RichDiagnostic)d).getDelegate();
        }
        if ("org.netbeans.modules.java.source.parsing.CompilationInfoImpl$DiagnosticListenerImpl$D".equals(d.getClass().getName())) {
            try {
                Field delegate = d.getClass().getDeclaredField("delegate");
                delegate.setAccessible(true);
                return Hacks.getJCDiagnostic((Diagnostic)delegate.get(d));
            }
            catch (Exception ex) {
                LOG.log(Level.FINE, null, ex);
            }
        }
        return null;
    }

    public static Object getDiagnosticParam(Diagnostic<?> d, int index) {
        JCDiagnostic jcd = Hacks.getJCDiagnostic(d);
        if (jcd == null) {
            return null;
        }
        Object[] args = jcd.getArgs();
        if (args == null || args.length <= index) {
            return null;
        }
        return args[index];
    }
}

