/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.platformdefinition;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.LocalDate;
import java.time.Month;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.lang.model.SourceVersion;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.java.j2seplatform.spi.J2SEPlatformDefaultJavadoc;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class J2SEPlatformDefaultJavadocImpl
implements J2SEPlatformDefaultJavadoc {
    private static final Logger LOG = Logger.getLogger(J2SEPlatformDefaultJavadocImpl.class.getName());

    @Override
    public Collection<URI> getDefaultJavadoc(@NonNull JavaPlatform platform) {
        ArrayList<? extends URI> result = new ArrayList<URI>();
        JavadocFilter filter = new JavadocFilter();
        for (FileObject folder : platform.getInstallFolders()) {
            for (FileObject file : folder.getChildren()) {
                result.addAll(filter.accept(file));
            }
        }
        if (!result.isEmpty()) {
            return Collections.unmodifiableList(result);
        }
        String version = platform.getSpecification().getVersion().toString();
        String location = J2SEPlatformDefaultJavadocImpl.computeJavaDocURL(version);
        if (location != null) {
            try {
                return Collections.singletonList(new URI(location));
            }
            catch (URISyntaxException x) {
                LOG.log(Level.INFO, null, x);
            }
        }
        return Collections.emptyList();
    }

    private static String computeJavaDocURL(String version) {
        switch (version) {
            case "1.0": 
            case "1.1": 
            case "1.2": 
            case "1.3": 
            case "1.4": {
                return null;
            }
            case "1.5": {
                return "https://docs.oracle.com/javase/1.5.0/docs/api/";
            }
            case "1.6": {
                return "https://docs.oracle.com/javase/6/docs/api/";
            }
            case "1.7": {
                return "https://docs.oracle.com/javase/7/docs/api/";
            }
            case "1.8": {
                return "https://docs.oracle.com/javase/8/docs/api/";
            }
        }
        try {
            int feature = Integer.parseInt(version);
            if (feature >= 9) {
                int latestGA = J2SEPlatformDefaultJavadocImpl.computeLatestGAVersion();
                if (feature <= latestGA) {
                    return "https://docs.oracle.com/en/java/javase/" + feature + "/docs/api/";
                }
                if (feature <= latestGA + 3) {
                    return "https://download.java.net/java/early_access/jdk" + feature + "/docs/api/";
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        LOG.log(Level.WARNING, "unrecognized Java spec version: {0}", version);
        return null;
    }

    private static int computeLatestGAVersion() {
        LocalDate jdk9 = LocalDate.of(2017, Month.SEPTEMBER, 21);
        int latest = 9 + (int)(ChronoUnit.MONTHS.between(jdk9, LocalDate.now()) / 6L);
        return Math.max(latest, SourceVersion.latest().ordinal());
    }

    private static final class JavadocFilter {
        private static final Pattern DOCS_FILE_PATTERN = Pattern.compile(".*docs.*\\.(zip|jar)", 2);
        private static final Pattern JAVAFX_FILE_PATTERN = Pattern.compile(".*j(ava)?fx.*", 2);
        private static final Collection<String> DOCS_PATHS;
        private static final Map<String, String> VENDOR_DOCS;

        private JavadocFilter() {
        }

        @NonNull
        Collection<? extends URI> accept(@NonNull FileObject fo) {
            if (fo.canRead()) {
                if (fo.isFolder()) {
                    if ("docs".equals(fo.getName())) {
                        return Collections.singleton(fo.toURI());
                    }
                } else if (fo.isData()) {
                    FileObject root;
                    String nameExt = fo.getNameExt();
                    String vendorPath = VENDOR_DOCS.get(nameExt);
                    if (vendorPath != null) {
                        if (FileUtil.isArchiveFile((FileObject)fo)) {
                            try {
                                return Collections.singleton(new URL(FileUtil.getArchiveRoot((URL)fo.toURL()).toExternalForm() + vendorPath).toURI());
                            }
                            catch (MalformedURLException | URISyntaxException e) {
                                LOG.log(Level.INFO, "Invalid Javadoc URI for file : {0}, reason: {1}", new Object[]{FileUtil.getFileDisplayName((FileObject)fo), e.getMessage()});
                            }
                        }
                    } else if (DOCS_FILE_PATTERN.matcher(nameExt).matches() && !JAVAFX_FILE_PATTERN.matcher(nameExt).matches() && (root = FileUtil.getArchiveRoot((FileObject)fo)) != null) {
                        ArrayList<URI> roots = new ArrayList<URI>(DOCS_PATHS.size());
                        for (String path : DOCS_PATHS) {
                            FileObject docRoot = root.getFileObject(path);
                            if (docRoot == null) continue;
                            roots.add(docRoot.toURI());
                        }
                        return Collections.unmodifiableCollection(roots);
                    }
                }
            }
            return Collections.emptySet();
        }

        static {
            ArrayList<String> paths = new ArrayList<String>(3);
            paths.add("docs/api/");
            paths.add("docs/jdk/api/");
            paths.add("docs/jre/api/");
            DOCS_PATHS = Collections.unmodifiableList(paths);
            HashMap<String, String> docs = new HashMap<String, String>();
            docs.put("appledocs.jar", "appledoc/api/");
            VENDOR_DOCS = Collections.unmodifiableMap(docs);
        }
    }
}

