/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.inspect.webkit.actions;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import org.netbeans.modules.css.lib.api.CssParserResult;
import org.netbeans.modules.css.model.api.Declaration;
import org.netbeans.modules.css.model.api.Model;
import org.netbeans.modules.css.model.api.PropertyDeclaration;
import org.netbeans.modules.css.model.api.StyleSheet;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.web.inspect.CSSUtils;
import org.netbeans.modules.web.inspect.actions.Resource;
import org.netbeans.modules.web.inspect.webkit.RemoteStyleSheetCache;
import org.netbeans.modules.web.inspect.webkit.Utilities;
import org.netbeans.modules.web.inspect.webkit.actions.GoToRuleSourceAction;
import org.netbeans.modules.web.webkit.debugging.api.css.Property;
import org.netbeans.modules.web.webkit.debugging.api.css.Rule;
import org.netbeans.modules.web.webkit.debugging.api.css.StyleSheetBody;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class GoToPropertySourceAction
extends AbstractAction {
    private static final RequestProcessor RP = new RequestProcessor(GoToPropertySourceAction.class);
    private final Node node;

    public GoToPropertySourceAction(Node node) {
        this.putValue("Name", NbBundle.getMessage(GoToPropertySourceAction.class, (String)"GoToPropertySourceAction.displayName"));
        this.node = node;
        this.setEnabled(true);
        this.disable();
    }

    @Override
    public void actionPerformed(final ActionEvent e) {
        if (RP.isRequestProcessorThread()) {
            Lookup lookup = this.node.getLookup();
            Rule rule = (Rule)lookup.lookup(Rule.class);
            Property property = (Property)lookup.lookup(Property.class);
            Node parent = this.node.getParentNode();
            Property shorthandProperty = (Property)parent.getLookup().lookup(Property.class);
            String shorthand = shorthandProperty == null ? null : shorthandProperty.getName();
            Resource resource = (Resource)lookup.lookup(Resource.class);
            FileObject fob = resource.toFileObject();
            if (fob == null || fob.isFolder()) {
                StyleSheetBody body = rule.getParentStyleSheet();
                fob = RemoteStyleSheetCache.getDefault().getFileObject(body);
                if (fob == null) {
                    return;
                }
            }
            try {
                Source source = Source.create((FileObject)fob);
                ParserManager.parse(Collections.singleton(source), (UserTask)new GoToPropertyTask(fob, rule, property, shorthand));
            }
            catch (ParseException ex) {
                Logger.getLogger(GoToRuleSourceAction.class.getName()).log(Level.INFO, null, ex);
            }
        } else {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    GoToPropertySourceAction.this.actionPerformed(e);
                }
            });
        }
    }

    final void disable() {
        if (RP.isRequestProcessorThread()) {
            Lookup lookup = this.node.getLookup();
            Rule rule = (Rule)lookup.lookup(Rule.class);
            Property property = (Property)lookup.lookup(Property.class);
            Resource resource = (Resource)lookup.lookup(Resource.class);
            final boolean enable = rule != null && property != null && resource != null ? resource.toFileObject() != null || rule.getParentStyleSheet() != null : false;
            if (!enable) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GoToPropertySourceAction.this.setEnabled(enable);
                    }
                });
            }
        } else {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    GoToPropertySourceAction.this.disable();
                }
            });
        }
    }

    static class GoToPropertyTask
    extends UserTask {
        private final FileObject fob;
        private final Rule rule;
        private final Property property;
        private final String shorthand;

        GoToPropertyTask(FileObject fob, Rule rule, Property property, String shorthand) {
            this.fob = fob;
            this.rule = rule;
            this.property = property;
            this.shorthand = shorthand;
        }

        public void run(ResultIterator resultIterator) throws Exception {
            final boolean[] found = new boolean[1];
            for (final CssParserResult result : Utilities.cssParserResults(resultIterator)) {
                final Model sourceModel = Model.getModel((CssParserResult)result);
                sourceModel.runReadTask(new Model.ModelTask(){

                    public void run(StyleSheet styleSheet) {
                        org.netbeans.modules.css.model.api.Rule modelRule = Utilities.findRuleInStyleSheet(sourceModel, styleSheet, rule);
                        if (modelRule != null) {
                            found[0] = true;
                            StyleSheetBody body = rule.getParentStyleSheet();
                            String styleSheetText = body == null ? null : body.getText();
                            String propertyName = property.getName().trim();
                            PropertyDeclaration modelProperty = this.findProperty(modelRule, propertyName);
                            if (modelProperty == null && shorthand != null) {
                                modelProperty = this.findProperty(modelRule, shorthand);
                            }
                            int snapshotOffset = modelProperty == null ? modelRule.getStartOffset() : modelProperty.getPropertyValue().getStartOffset();
                            final int offset = result.getSnapshot().getOriginalOffset(snapshotOffset);
                            if (!CSSUtils.goToSourceBySourceMap(fob, sourceModel, styleSheetText, offset) && !Utilities.goToMetaSource(modelRule)) {
                                EventQueue.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        CSSUtils.openAtOffset(fob, offset);
                                    }
                                });
                            }
                        }
                    }

                    private PropertyDeclaration findProperty(org.netbeans.modules.css.model.api.Rule rule, String propertyName) {
                        for (Declaration declaration : rule.getDeclarations().getDeclarations()) {
                            PropertyDeclaration modelPropertyDeclaration = declaration.getPropertyDeclaration();
                            org.netbeans.modules.css.model.api.Property modelProperty = modelPropertyDeclaration.getProperty();
                            String modelPropertyName = modelProperty.getContent().toString().trim();
                            if (!propertyName.equals(modelPropertyName)) continue;
                            return modelPropertyDeclaration;
                        }
                        return null;
                    }
                });
                if (!found[0]) continue;
                break;
            }
        }
    }
}

