/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.devops.model.Trigger;
import com.oracle.bmc.devops.model.TriggerAction;
import com.oracle.bmc.devops.model.TriggerCreateResult;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="triggerSource")
@JsonFilter(value="explicitlySetFilter")
public final class GitlabTriggerCreateResult
extends TriggerCreateResult {
    @JsonProperty(value="secret")
    private final String secret;
    @JsonProperty(value="triggerUrl")
    private final String triggerUrl;
    @JsonProperty(value="connectionId")
    private final String connectionId;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public GitlabTriggerCreateResult(String id, String displayName, String description, String projectId, String compartmentId, Date timeCreated, Date timeUpdated, Trigger.LifecycleState lifecycleState, String lifecycleDetails, List<TriggerAction> actions, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags, String secret, String triggerUrl, String connectionId) {
        super(id, displayName, description, projectId, compartmentId, timeCreated, timeUpdated, lifecycleState, lifecycleDetails, actions, freeformTags, definedTags, systemTags);
        this.secret = secret;
        this.triggerUrl = triggerUrl;
        this.connectionId = connectionId;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getTriggerUrl() {
        return this.triggerUrl;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("GitlabTriggerCreateResult(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", secret=").append(String.valueOf(this.secret));
        sb.append(", triggerUrl=").append(String.valueOf(this.triggerUrl));
        sb.append(", connectionId=").append(String.valueOf(this.connectionId));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GitlabTriggerCreateResult)) {
            return false;
        }
        GitlabTriggerCreateResult other = (GitlabTriggerCreateResult)((Object)o);
        return Objects.equals(this.secret, other.secret) && Objects.equals(this.triggerUrl, other.triggerUrl) && Objects.equals(this.connectionId, other.connectionId) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.secret == null ? 43 : this.secret.hashCode());
        result = result * 59 + (this.triggerUrl == null ? 43 : this.triggerUrl.hashCode());
        result = result * 59 + (this.connectionId == null ? 43 : this.connectionId.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="projectId")
        private String projectId;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="lifecycleState")
        private Trigger.LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="actions")
        private List<TriggerAction> actions;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonProperty(value="secret")
        private String secret;
        @JsonProperty(value="triggerUrl")
        private String triggerUrl;
        @JsonProperty(value="connectionId")
        private String connectionId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            this.__explicitlySet__.add("projectId");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder lifecycleState(Trigger.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder actions(List<TriggerAction> actions) {
            this.actions = actions;
            this.__explicitlySet__.add("actions");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public Builder secret(String secret) {
            this.secret = secret;
            this.__explicitlySet__.add("secret");
            return this;
        }

        public Builder triggerUrl(String triggerUrl) {
            this.triggerUrl = triggerUrl;
            this.__explicitlySet__.add("triggerUrl");
            return this;
        }

        public Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            this.__explicitlySet__.add("connectionId");
            return this;
        }

        public GitlabTriggerCreateResult build() {
            GitlabTriggerCreateResult model = new GitlabTriggerCreateResult(this.id, this.displayName, this.description, this.projectId, this.compartmentId, this.timeCreated, this.timeUpdated, this.lifecycleState, this.lifecycleDetails, this.actions, this.freeformTags, this.definedTags, this.systemTags, this.secret, this.triggerUrl, this.connectionId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(GitlabTriggerCreateResult model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("projectId")) {
                this.projectId(model.getProjectId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("actions")) {
                this.actions(model.getActions());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            if (model.wasPropertyExplicitlySet("secret")) {
                this.secret(model.getSecret());
            }
            if (model.wasPropertyExplicitlySet("triggerUrl")) {
                this.triggerUrl(model.getTriggerUrl());
            }
            if (model.wasPropertyExplicitlySet("connectionId")) {
                this.connectionId(model.getConnectionId());
            }
            return this;
        }
    }
}

