/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.devops.model.BuildSource;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="connectionType")
@JsonFilter(value="explicitlySetFilter")
public final class GithubBuildSource
extends BuildSource {
    @JsonProperty(value="connectionId")
    private final String connectionId;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public GithubBuildSource(String name, String repositoryUrl, String branch, String connectionId) {
        super(name, repositoryUrl, branch);
        this.connectionId = connectionId;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("GithubBuildSource(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", connectionId=").append(String.valueOf(this.connectionId));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GithubBuildSource)) {
            return false;
        }
        GithubBuildSource other = (GithubBuildSource)((Object)o);
        return Objects.equals(this.connectionId, other.connectionId) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.connectionId == null ? 43 : this.connectionId.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="repositoryUrl")
        private String repositoryUrl;
        @JsonProperty(value="branch")
        private String branch;
        @JsonProperty(value="connectionId")
        private String connectionId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder repositoryUrl(String repositoryUrl) {
            this.repositoryUrl = repositoryUrl;
            this.__explicitlySet__.add("repositoryUrl");
            return this;
        }

        public Builder branch(String branch) {
            this.branch = branch;
            this.__explicitlySet__.add("branch");
            return this;
        }

        public Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            this.__explicitlySet__.add("connectionId");
            return this;
        }

        public GithubBuildSource build() {
            GithubBuildSource model = new GithubBuildSource(this.name, this.repositoryUrl, this.branch, this.connectionId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(GithubBuildSource model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("repositoryUrl")) {
                this.repositoryUrl(model.getRepositoryUrl());
            }
            if (model.wasPropertyExplicitlySet("branch")) {
                this.branch(model.getBranch());
            }
            if (model.wasPropertyExplicitlySet("connectionId")) {
                this.connectionId(model.getConnectionId());
            }
            return this;
        }
    }
}

