/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.devops.model.DeployStageExecutionStep;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DeployStageExecutionProgressDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="targetId")
    private final String targetId;
    @JsonProperty(value="targetGroup")
    private final String targetGroup;
    @JsonProperty(value="steps")
    private final List<DeployStageExecutionStep> steps;
    @JsonProperty(value="rollbackSteps")
    private final List<DeployStageExecutionStep> rollbackSteps;

    @Deprecated
    @ConstructorProperties(value={"targetId", "targetGroup", "steps", "rollbackSteps"})
    public DeployStageExecutionProgressDetails(String targetId, String targetGroup, List<DeployStageExecutionStep> steps, List<DeployStageExecutionStep> rollbackSteps) {
        this.targetId = targetId;
        this.targetGroup = targetGroup;
        this.steps = steps;
        this.rollbackSteps = rollbackSteps;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getTargetId() {
        return this.targetId;
    }

    public String getTargetGroup() {
        return this.targetGroup;
    }

    public List<DeployStageExecutionStep> getSteps() {
        return this.steps;
    }

    public List<DeployStageExecutionStep> getRollbackSteps() {
        return this.rollbackSteps;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DeployStageExecutionProgressDetails(");
        sb.append("super=").append(super.toString());
        sb.append("targetId=").append(String.valueOf(this.targetId));
        sb.append(", targetGroup=").append(String.valueOf(this.targetGroup));
        sb.append(", steps=").append(String.valueOf(this.steps));
        sb.append(", rollbackSteps=").append(String.valueOf(this.rollbackSteps));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeployStageExecutionProgressDetails)) {
            return false;
        }
        DeployStageExecutionProgressDetails other = (DeployStageExecutionProgressDetails)((Object)o);
        return Objects.equals(this.targetId, other.targetId) && Objects.equals(this.targetGroup, other.targetGroup) && Objects.equals(this.steps, other.steps) && Objects.equals(this.rollbackSteps, other.rollbackSteps) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.targetId == null ? 43 : this.targetId.hashCode());
        result = result * 59 + (this.targetGroup == null ? 43 : this.targetGroup.hashCode());
        result = result * 59 + (this.steps == null ? 43 : this.steps.hashCode());
        result = result * 59 + (this.rollbackSteps == null ? 43 : this.rollbackSteps.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="targetId")
        private String targetId;
        @JsonProperty(value="targetGroup")
        private String targetGroup;
        @JsonProperty(value="steps")
        private List<DeployStageExecutionStep> steps;
        @JsonProperty(value="rollbackSteps")
        private List<DeployStageExecutionStep> rollbackSteps;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder targetId(String targetId) {
            this.targetId = targetId;
            this.__explicitlySet__.add("targetId");
            return this;
        }

        public Builder targetGroup(String targetGroup) {
            this.targetGroup = targetGroup;
            this.__explicitlySet__.add("targetGroup");
            return this;
        }

        public Builder steps(List<DeployStageExecutionStep> steps) {
            this.steps = steps;
            this.__explicitlySet__.add("steps");
            return this;
        }

        public Builder rollbackSteps(List<DeployStageExecutionStep> rollbackSteps) {
            this.rollbackSteps = rollbackSteps;
            this.__explicitlySet__.add("rollbackSteps");
            return this;
        }

        public DeployStageExecutionProgressDetails build() {
            DeployStageExecutionProgressDetails model = new DeployStageExecutionProgressDetails(this.targetId, this.targetGroup, this.steps, this.rollbackSteps);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DeployStageExecutionProgressDetails model) {
            if (model.wasPropertyExplicitlySet("targetId")) {
                this.targetId(model.getTargetId());
            }
            if (model.wasPropertyExplicitlySet("targetGroup")) {
                this.targetGroup(model.getTargetGroup());
            }
            if (model.wasPropertyExplicitlySet("steps")) {
                this.steps(model.getSteps());
            }
            if (model.wasPropertyExplicitlySet("rollbackSteps")) {
                this.rollbackSteps(model.getRollbackSteps());
            }
            return this;
        }
    }
}

