/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.debug.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.Watch;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.debug.Context;
import org.netbeans.modules.web.debug.actions.MainProjectManager;
import org.netbeans.modules.web.debug.breakpoints.JspLineBreakpoint;
import org.netbeans.modules.web.debug.util.Utils;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.netbeans.spi.project.ActionProvider;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;

public class JspRunToCursorActionProvider
extends ActionsProviderSupport {
    private static final RequestProcessor RP = new RequestProcessor(JspRunToCursorActionProvider.class);
    private JspLineBreakpoint breakpoint;

    public JspRunToCursorActionProvider() {
        Listener listener = new Listener();
        MainProjectManager.getDefault().addPropertyChangeListener(listener);
        EditorContextDispatcher.getDefault().addPropertyChangeListener("text/x-jsp", (PropertyChangeListener)listener);
        EditorContextDispatcher.getDefault().addPropertyChangeListener("text/x-tag", (PropertyChangeListener)listener);
        DebuggerManager.getDebuggerManager().addDebuggerListener((DebuggerManagerListener)listener);
        this.setEnabledIfItShouldBe();
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_RUN_TO_CURSOR);
    }

    public void doAction(Object action) {
        this.removeBreakpoint();
        this.createBreakpoint();
        final Lookup lkp = MainProjectManager.getDefault().getMainProject().getLookup();
        final ActionProvider ap = (ActionProvider)lkp.lookup(ActionProvider.class);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ap.invokeAction("debug", lkp);
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Pair<Boolean, ? extends Callable<Boolean>> shouldBeEnabled() {
        Project p;
        if (!Utils.isJsp(Context.getCurrentFile())) {
            return Pair.of((Object)false, null);
        }
        if (SwingUtilities.isEventDispatchThread()) {
            final Future<Project> pl = MainProjectManager.getDefault().getMainProjectLazy();
            if (!pl.isDone()) return Pair.of(null, (Object)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    Project p = (Project)pl.get();
                    if (p == null) {
                        return false;
                    }
                    return JspRunToCursorActionProvider.isDebuggableProject(p);
                }
            });
            try {
                p = pl.get();
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return Pair.of((Object)false, null);
            }
            catch (ExecutionException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return Pair.of((Object)false, null);
            }
        } else {
            p = MainProjectManager.getDefault().getMainProject();
        }
        if (p != null) return Pair.of((Object)JspRunToCursorActionProvider.isDebuggableProject(p), null);
        return Pair.of((Object)false, null);
    }

    private static boolean isDebuggableProject(Project p) {
        int i;
        ActionProvider actionProvider = (ActionProvider)p.getLookup().lookup(ActionProvider.class);
        if (actionProvider == null) {
            return false;
        }
        String[] sa = actionProvider.getSupportedActions();
        int k = sa.length;
        for (i = 0; i < k && !"debug".equals(sa[i]); ++i) {
        }
        if (i == k) {
            return false;
        }
        return ((ActionProvider)p.getLookup().lookup(ActionProvider.class)).isActionEnabled("debug", p.getLookup());
    }

    private void setEnabledIfItShouldBe() {
        Pair<Boolean, ? extends Callable<Boolean>> shouldBeEnabled = this.shouldBeEnabled();
        if (shouldBeEnabled.first() != null) {
            this.setEnabled(ActionsManager.ACTION_RUN_TO_CURSOR, (Boolean)shouldBeEnabled.first());
        } else {
            final Callable lazyEnable = (Callable)shouldBeEnabled.second();
            RP.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        Boolean enabled = (Boolean)lazyEnable.call();
                        JspRunToCursorActionProvider.this.setEnabled(ActionsManager.ACTION_RUN_TO_CURSOR, enabled);
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
        }
    }

    private void createBreakpoint() {
        this.breakpoint = JspLineBreakpoint.create(Context.getCurrentURL(), Context.getCurrentLineNumber());
        this.breakpoint.setHidden(true);
        DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)this.breakpoint);
    }

    private void removeBreakpoint() {
        if (this.breakpoint != null) {
            DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)this.breakpoint);
            this.breakpoint = null;
        }
    }

    private class Listener
    implements PropertyChangeListener,
    DebuggerManagerListener {
        private Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e == null) {
                return;
            }
            if (e.getPropertyName() == "state") {
                int state = (Integer)e.getNewValue();
                if (state == 4 || state == 3) {
                    JspRunToCursorActionProvider.this.removeBreakpoint();
                }
                return;
            }
            JspRunToCursorActionProvider.this.setEnabledIfItShouldBe();
        }

        public void sessionRemoved(Session session) {
            JspRunToCursorActionProvider.this.removeBreakpoint();
        }

        public void breakpointAdded(Breakpoint breakpoint) {
        }

        public void breakpointRemoved(Breakpoint breakpoint) {
        }

        public Breakpoint[] initBreakpoints() {
            return new Breakpoint[0];
        }

        public void initWatches() {
        }

        public void sessionAdded(Session session) {
        }

        public void watchAdded(Watch watch) {
        }

        public void watchRemoved(Watch watch) {
        }

        public void engineAdded(DebuggerEngine engine) {
            JPDADebugger debugger = (JPDADebugger)engine.lookupFirst(null, JPDADebugger.class);
            if (debugger == null) {
                return;
            }
            debugger.addPropertyChangeListener("state", (PropertyChangeListener)this);
        }

        public void engineRemoved(DebuggerEngine engine) {
            JPDADebugger debugger = (JPDADebugger)engine.lookupFirst(null, JPDADebugger.class);
            if (debugger == null) {
                return;
            }
            debugger.removePropertyChangeListener("state", (PropertyChangeListener)this);
        }
    }
}

