/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.editor.hints;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.awt.EventQueue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.editor.hints.WebServicesRulesEngine;
import org.netbeans.modules.websvc.editor.hints.common.ProblemContext;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.WSDLModelFactory;
import org.netbeans.modules.xml.xam.ComponentEvent;
import org.netbeans.modules.xml.xam.ComponentListener;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.HintsController;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class WebServicesHintsProvider {
    private static final Object singleInstanceLock = new Object();
    private static WebServicesHintsProvider runningInstance = null;
    private FileObject file;
    private boolean cancelled = false;
    private ProblemContext context = null;
    private List<ErrorDescription> problemsFound = new ArrayList<ErrorDescription>();
    private final Object cancellationLock = new Object();
    private WSDLModel wsdlModel;
    private Service service;
    private ComponentListener changeListener;
    private static final RequestProcessor WS_HINTS_RP = new RequestProcessor(WebServicesHintsProvider.class);

    public WebServicesHintsProvider(FileObject file) {
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        this.cancelled = true;
        Object object = this.cancellationLock;
        synchronized (object) {
            if (this.context != null) {
                this.context.setCancelled(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(CompilationInfo info) throws Exception {
        Object object = singleInstanceLock;
        synchronized (object) {
            if (runningInstance != null) {
                runningInstance.cancel();
            }
            runningInstance = this;
            this.cancelled = false;
            this.problemsFound.clear();
            for (Tree tree : info.getCompilationUnit().getTypeDecls()) {
                if (this.isCancelled()) break;
                if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind())) continue;
                TreePath path = info.getTrees().getPath(info.getCompilationUnit(), tree);
                TypeElement javaClass = (TypeElement)info.getTrees().getElement(path);
                if (javaClass == null) continue;
                this.initServiceMetadata(javaClass);
                this.createProblemContext(info, javaClass);
                WebServicesRulesEngine rulesEngine = new WebServicesRulesEngine();
                javaClass.accept(rulesEngine, this.context);
                this.problemsFound.addAll(rulesEngine.getProblemsFound());
                Object object2 = this.cancellationLock;
                synchronized (object2) {
                    this.context = null;
                }
            }
            HintsController.setErrors((FileObject)this.file, (String)"WebService Verification", this.problemsFound);
            runningInstance = null;
        }
    }

    private void createProblemContext(CompilationInfo info, TypeElement javaClass) {
        this.context = new ProblemContext();
        this.context.setJavaClass(javaClass);
        this.context.setFileObject(this.file);
        this.context.setCompilationInfo(info);
        if (this.service != null) {
            this.context.addUserObject(this.service);
        }
        if (this.wsdlModel != null) {
            this.context.addUserObject(this.wsdlModel);
        }
    }

    private void initServiceMetadata(TypeElement javaClass) {
        FileObject wsdlFolder;
        JAXWSSupport jaxwsSupport;
        JaxWsModel jaxwsModel;
        Project owner;
        if (this.service == null && (owner = FileOwnerQuery.getOwner((FileObject)this.file)) != null && (jaxwsModel = (JaxWsModel)owner.getLookup().lookup(JaxWsModel.class)) != null) {
            this.service = jaxwsModel.findServiceByImplementationClass(javaClass.getQualifiedName().toString());
        }
        if (this.service != null && this.service.getLocalWsdlFile() != null && (jaxwsSupport = JAXWSSupport.getJAXWSSupport((FileObject)this.file)) != null && (wsdlFolder = jaxwsSupport.getLocalWsdlFolderForService(this.service.getName(), false)) != null) {
            FileObject wsdlFo = wsdlFolder.getFileObject(this.service.getLocalWsdlFile());
            if (wsdlFo == null) {
                return;
            }
            WSDLModel tmpModel = WSDLModelFactory.getDefault().getModel(Utilities.getModelSource((FileObject)wsdlFo, (boolean)true));
            if (tmpModel != this.wsdlModel) {
                if (this.wsdlModel != null && this.changeListener != null) {
                    this.wsdlModel.removeComponentListener(this.changeListener);
                    this.changeListener = null;
                }
                this.wsdlModel = tmpModel;
                if (this.wsdlModel != null) {
                    if (this.changeListener == null) {
                        this.changeListener = (ComponentListener)WeakListeners.create(ComponentListener.class, (EventListener)((Object)new WsdlModelListener(this.file)), (Object)this.wsdlModel);
                    }
                    this.wsdlModel.addComponentListener(this.changeListener);
                }
            }
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public List<? extends ErrorDescription> getProblemsFound() {
        return this.problemsFound;
    }

    static /* synthetic */ RequestProcessor access$000() {
        return WS_HINTS_RP;
    }

    private class WsdlModelListener
    extends RescanTrigger
    implements ComponentListener {
        WsdlModelListener(FileObject file) {
            super(file);
        }

        public void valueChanged(ComponentEvent evt) {
            if (!WebServicesHintsProvider.this.isCancelled()) {
                this.rescan();
            }
        }

        public void childrenAdded(ComponentEvent evt) {
            if (!WebServicesHintsProvider.this.isCancelled()) {
                this.rescan();
            }
        }

        public void childrenDeleted(ComponentEvent evt) {
            if (!WebServicesHintsProvider.this.isCancelled()) {
                this.rescan();
            }
        }
    }

    private abstract class RescanTrigger
    implements Runnable {
        private FileObject file;
        private JavaSource javaSrc;
        private final RequestProcessor.Task wsHintsTask = WebServicesHintsProvider.access$000().create((Runnable)this);

        RescanTrigger(FileObject file) {
            this.file = file;
        }

        void rescan() {
            if (this.javaSrc == null) {
                this.javaSrc = JavaSource.forFileObject((FileObject)this.file);
            }
            if (this.javaSrc != null) {
                try {
                    if (EventQueue.isDispatchThread()) {
                        this.wsHintsTask.schedule(100);
                    } else {
                        this.javaSrc.runUserActionTask((Task)new ProblemFinderCompControl(this.file), true);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void run() {
            try {
                this.javaSrc.runUserActionTask((Task)new ProblemFinderCompControl(this.file), true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static class ProblemFinderCompControl
    extends WebServicesHintsProvider
    implements CancellableTask<CompilationController> {
        public ProblemFinderCompControl(FileObject file) {
            super(file);
        }

        public void run(CompilationController controller) throws Exception {
            controller.toPhase(JavaSource.Phase.RESOLVED);
            super.run((CompilationInfo)controller);
        }
    }

    public static class ProblemFinderCompInfo
    extends WebServicesHintsProvider
    implements CancellableTask<CompilationInfo> {
        public ProblemFinderCompInfo(FileObject file) {
            super(file);
        }
    }
}

