/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.platform;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.java.j2seplatform.spi.J2SEPlatformDefaultSources;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public class JavaFxDefaultSourcesImpl
implements J2SEPlatformDefaultSources {
    private static final String FX_SOURCES = "javafx-src.zip";

    @NonNull
    public List<URI> getDefaultSources(@NonNull JavaPlatform platform) {
        Collection fos = platform.getInstallFolders();
        if (fos.isEmpty()) {
            return Collections.emptyList();
        }
        File javaHome = FileUtil.toFile((FileObject)((FileObject)fos.iterator().next()));
        if (javaHome == null) {
            return Collections.emptyList();
        }
        return JavaFxDefaultSourcesImpl.getFxSources(javaHome);
    }

    private static List<URI> getFxSources(@NonNull File javaHome) {
        try {
            File f = new File(javaHome, FX_SOURCES);
            if (f.exists() && f.canRead()) {
                URL url = FileUtil.getArchiveRoot((URL)Utilities.toURI((File)f).toURL());
                URI uri = url.toURI();
                return Collections.singletonList(uri);
            }
        }
        catch (MalformedURLException | URISyntaxException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return Collections.emptyList();
    }
}

